/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.network.ws;

import com.apollographql.apollo3.api.AnyAdapter;
import com.apollographql.apollo3.api.ApolloRequest;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.http.DefaultHttpRequestComposer;
import com.apollographql.apollo3.api.internal.json.BufferedSourceJsonReader;
import com.apollographql.apollo3.api.json.JsonReader;
import com.apollographql.apollo3.network.ws.WsFrameType;
import com.apollographql.apollo3.network.ws.WsMessage;
import com.apollographql.apollo3.network.ws.WsProtocol;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003H\u0016J\u0018\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0003H\u0016J.\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\"\b\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H\u0016J.\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\"\b\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0016R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/apollographql/apollo3/network/ws/GraphQLWsProtocol;", "Lcom/apollographql/apollo3/network/ws/WsProtocol;", "connectionPayload", "", "", "", "frameType", "Lcom/apollographql/apollo3/network/ws/WsFrameType;", "(Ljava/util/Map;Lcom/apollographql/apollo3/network/ws/WsFrameType;)V", "getFrameType", "()Lcom/apollographql/apollo3/network/ws/WsFrameType;", "name", "getName", "()Ljava/lang/String;", "connectionInit", "connectionTerminate", "operationStart", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "request", "Lcom/apollographql/apollo3/api/ApolloRequest;", "operationStop", "parseMessage", "Lcom/apollographql/apollo3/network/ws/WsMessage;", "string", "apollo-runtime"})
public final class GraphQLWsProtocol
implements WsProtocol {
    @Nullable
    private final Map<String, Object> connectionPayload;
    @NotNull
    private final WsFrameType frameType;

    public GraphQLWsProtocol(@Nullable Map<String, ? extends Object> connectionPayload, @NotNull WsFrameType frameType) {
        Intrinsics.checkNotNullParameter((Object)((Object)frameType), (String)"frameType");
        this.connectionPayload = connectionPayload;
        this.frameType = frameType;
    }

    public /* synthetic */ GraphQLWsProtocol(Map map2, WsFrameType wsFrameType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = null;
        }
        if ((n & 2) != 0) {
            wsFrameType = WsFrameType.Binary;
        }
        this(map2, wsFrameType);
    }

    @Override
    @NotNull
    public WsFrameType getFrameType() {
        return this.frameType;
    }

    @Override
    @NotNull
    public String getName() {
        return "graphql-transport-ws";
    }

    @Override
    @NotNull
    public Map<String, Object> connectionInit() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"connection_init")};
        Map map2 = MapsKt.mutableMapOf((Pair[])pairArray);
        if (this.connectionPayload != null) {
            map2.put("payload", this.connectionPayload);
        }
        return map2;
    }

    @Override
    @Nullable
    public Map<String, Object> connectionTerminate() {
        return null;
    }

    @Override
    @NotNull
    public <D extends Operation.Data> Map<String, Object> operationStart(@NotNull ApolloRequest<D> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"subscribe"), TuplesKt.to((Object)"id", (Object)request.getRequestUuid().toString()), TuplesKt.to((Object)"payload", (Object)DefaultHttpRequestComposer.Companion.composePayload(request))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public <D extends Operation.Data> Map<String, Object> operationStop(@NotNull ApolloRequest<D> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"complete"), TuplesKt.to((Object)"id", (Object)request.getRequestUuid().toString())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public WsMessage parseMessage(@NotNull String string) {
        WsMessage wsMessage;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Map map2 = (Map)AnyAdapter.INSTANCE.fromResponse((JsonReader)new BufferedSourceJsonReader((BufferedSource)new Buffer().writeUtf8(string)));
        Object v = map2.get("type");
        if (Intrinsics.areEqual(v, (Object)"connection_ack")) {
            wsMessage = WsMessage.ConnectionAck.INSTANCE;
        } else if (Intrinsics.areEqual(v, (Object)"next")) {
            Object v2 = map2.get("id");
            if (v2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String string2 = (String)v2;
            v2 = map2.get("payload");
            if (v2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            wsMessage = new WsMessage.OperationData(string2, (Map)v2);
        } else if (Intrinsics.areEqual(v, (Object)"error")) {
            Object v3 = map2.get("id");
            if (v3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String string3 = (String)v3;
            v3 = map2.get("payload");
            if (v3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            wsMessage = new WsMessage.OperationError(string3, (Map)v3);
        } else if (Intrinsics.areEqual(v, (Object)"complete")) {
            Object v4 = map2.get("id");
            if (v4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            wsMessage = new WsMessage.OperationComplete((String)v4);
        } else {
            wsMessage = new WsMessage.Unknown(map2);
        }
        return wsMessage;
    }

    public GraphQLWsProtocol() {
        this(null, null, 3, null);
    }
}

