/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.sql;

import com.apollographql.apollo3.cache.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.CacheKey;
import com.apollographql.apollo3.cache.normalized.NormalizedCache;
import com.apollographql.apollo3.cache.normalized.Record;
import com.apollographql.apollo3.cache.normalized.sql.CacheQueries;
import com.apollographql.apollo3.cache.normalized.sql.internal.RecordsetDataSource;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J$\u0010\u0007\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b0\bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/apollographql/apollo3/cache/normalized/sql/SqlNormalizedCache;", "Lcom/apollographql/apollo3/cache/normalized/NormalizedCache;", "cacheQueries", "Lcom/apollographql/apollo3/cache/normalized/sql/CacheQueries;", "(Lcom/apollographql/apollo3/cache/normalized/sql/CacheQueries;)V", "clearAll", "", "dump", "", "Lkotlin/reflect/KClass;", "", "Lcom/apollographql/apollo3/cache/normalized/Record;", "loadRecord", "key", "cacheHeaders", "Lcom/apollographql/apollo3/cache/CacheHeaders;", "loadRecords", "", "keys", "merge", "", "record", "records", "remove", "", "cacheKey", "Lcom/apollographql/apollo3/cache/normalized/CacheKey;", "cascade", "apollo-normalized-cache-sqlite"})
public final class SqlNormalizedCache
extends NormalizedCache {
    private final CacheQueries cacheQueries;

    @Nullable
    public Record loadRecord(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)cacheHeaders, (String)"cacheHeaders");
        Record record = RecordsetDataSource.INSTANCE.selectRecord(this.cacheQueries, key);
        if (record != null) {
            if (cacheHeaders.hasHeader("evict-after-read")) {
                RecordsetDataSource.INSTANCE.deleteRecord(this.cacheQueries, key, false);
            }
            return record;
        }
        NormalizedCache normalizedCache = this.getNextCache();
        return normalizedCache != null ? normalizedCache.loadRecord(key, cacheHeaders) : null;
    }

    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkParameterIsNotNull(keys, (String)"keys");
        Intrinsics.checkParameterIsNotNull((Object)cacheHeaders, (String)"cacheHeaders");
        Collection<Record> records = RecordsetDataSource.INSTANCE.selectRecords(this.cacheQueries, keys);
        if (cacheHeaders.hasHeader("evict-after-read")) {
            Iterable $this$forEach$iv = records;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Record record = (Record)element$iv;
                boolean bl = false;
                RecordsetDataSource.INSTANCE.deleteRecord(this.cacheQueries, record.getKey(), false);
            }
        }
        return records;
    }

    public void clearAll() {
        NormalizedCache normalizedCache = this.getNextCache();
        if (normalizedCache != null) {
            normalizedCache.clearAll();
        }
        RecordsetDataSource.INSTANCE.deleteAllRecords(this.cacheQueries);
    }

    public boolean remove(@NotNull CacheKey cacheKey, boolean cascade) {
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        return RecordsetDataSource.INSTANCE.deleteRecord(this.cacheQueries, cacheKey.getKey(), cascade);
    }

    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkParameterIsNotNull(records, (String)"records");
        Intrinsics.checkParameterIsNotNull((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        return RecordsetDataSource.INSTANCE.updateRecords(this.cacheQueries, records);
    }

    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkParameterIsNotNull((Object)record, (String)"record");
        Intrinsics.checkParameterIsNotNull((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        return RecordsetDataSource.INSTANCE.updateRecord(this.cacheQueries, record);
    }

    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()), RecordsetDataSource.INSTANCE.selectAllRecords(this.cacheQueries)));
        NormalizedCache normalizedCache = this.getNextCache();
        Map map2 = normalizedCache != null ? normalizedCache.dump() : null;
        boolean bl = false;
        Map map3 = map2;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        return MapsKt.plus((Map)map, (Map)map3);
    }

    public SqlNormalizedCache(@NotNull CacheQueries cacheQueries) {
        Intrinsics.checkParameterIsNotNull((Object)cacheQueries, (String)"cacheQueries");
        this.cacheQueries = cacheQueries;
    }
}

