/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.sql.internal;

import app.cash.sqldelight.db.QueryResult;
import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.db.SqlDriver;
import app.cash.sqldelight.db.SqlSchema;
import com.apollographql.apollo3.cache.normalized.sql.internal.BlobRecordDatabase;
import com.apollographql.apollo3.cache.normalized.sql.internal.FactoryImplementationsKt;
import com.apollographql.apollo3.cache.normalized.sql.internal.JsonRecordDatabase;
import com.apollographql.apollo3.cache.normalized.sql.internal.RecordDatabase;
import com.apollographql.apollo3.cache.normalized.sql.internal.blob.BlobDatabase;
import com.apollographql.apollo3.cache.normalized.sql.internal.json.JsonDatabase;
import com.apollographql.apollo3.exception.ApolloExceptionHandlerKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001f\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\n"}, d2={"createRecordDatabase", "Lcom/apollographql/apollo3/cache/normalized/sql/internal/RecordDatabase;", "driver", "Lapp/cash/sqldelight/db/SqlDriver;", "withDates", "", "getSchema", "Lapp/cash/sqldelight/db/SqlSchema;", "Lapp/cash/sqldelight/db/QueryResult$Value;", "", "apollo-normalized-cache-sqlite-incubating"})
public final class FactoryHelpersKt {
    @NotNull
    public static final RecordDatabase createRecordDatabase(@NotNull SqlDriver driver, boolean withDates) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        FactoryImplementationsKt.maybeCreateOrMigrateSchema(driver, FactoryHelpersKt.getSchema(withDates));
        List tableNames = new ArrayList();
        try {
            SqlDriver.DefaultImpls.executeQuery$default((SqlDriver)driver, null, (String)"SELECT name FROM sqlite_master WHERE type='table' ORDER BY name;", (Function1)((Function1)new Function1<SqlCursor, QueryResult<Unit>>((List<String>)tableNames){
                final /* synthetic */ List<String> $tableNames;
                {
                    this.$tableNames = $tableNames;
                    super(1);
                }

                @NotNull
                public final QueryResult<Unit> invoke(@NotNull SqlCursor cursor) {
                    Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
                    while (((Boolean)cursor.next().getValue()).booleanValue()) {
                        String string = cursor.getString(0);
                        if (string == null) {
                            string = "";
                        }
                        this.$tableNames.add(string);
                    }
                    return QueryResult.Value.box-impl((Object)QueryResult.Companion.getUnit-mlR-ZEE());
                }
            }), (int)0, null, (int)16, null);
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("An exception occurred while looking up the table names", e));
        }
        String expectedTableName = withDates ? "blobs" : "records";
        if (!(tableNames.isEmpty() || tableNames.contains(expectedTableName))) {
            boolean bl = false;
            String string = "Apollo: Cannot find the '" + expectedTableName + "' table, did you change the 'withDates' parameter? (found '" + tableNames + "' instead)";
            throw new IllegalStateException(string.toString());
        }
        return withDates ? (RecordDatabase)new BlobRecordDatabase(BlobDatabase.Companion.invoke(driver).getBlobQueries()) : (RecordDatabase)new JsonRecordDatabase(JsonDatabase.Companion.invoke(driver).getJsonQueries());
    }

    @NotNull
    public static final SqlSchema<QueryResult.Value<Unit>> getSchema(boolean withDates) {
        return withDates ? BlobDatabase.Companion.getSchema() : JsonDatabase.Companion.getSchema();
    }
}

