/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.sql;

import app.cash.sqldelight.db.SqlDriver;
import app.cash.sqldelight.driver.jdbc.sqlite.JdbcSqliteDriver;
import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.cache.normalized.api.NormalizedCacheFactory;
import com.apollographql.apollo3.cache.normalized.sql.SqlNormalizedCache;
import com.apollographql.apollo3.cache.normalized.sql.internal.Blob2RecordDatabase;
import com.apollographql.apollo3.cache.normalized.sql.internal.FactoryImplementationsKt;
import com.apollographql.apollo3.cache.normalized.sql.internal.blob2.Blob2Database;
import com.apollographql.apollo3.cache.normalized.sql.internal.blob2.Blob2Queries;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/apollographql/apollo3/cache/normalized/sql/TrimmableNormalizedCacheFactory;", "Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCacheFactory;", "url", "", "maxSize", "", "trimFactor", "", "(Ljava/lang/String;Ljava/lang/Long;F)V", "driver", "Lapp/cash/sqldelight/driver/jdbc/sqlite/JdbcSqliteDriver;", "Ljava/lang/Long;", "create", "Lcom/apollographql/apollo3/cache/normalized/sql/SqlNormalizedCache;", "apollo-normalized-cache-sqlite-incubating"})
@ApolloExperimental
public final class TrimmableNormalizedCacheFactory
extends NormalizedCacheFactory {
    @NotNull
    private final String url;
    @Nullable
    private final Long maxSize;
    private final float trimFactor;
    @NotNull
    private final JdbcSqliteDriver driver;

    public TrimmableNormalizedCacheFactory(@NotNull String url, @Nullable Long maxSize, float trimFactor) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
        this.maxSize = maxSize;
        this.trimFactor = trimFactor;
        this.driver = new JdbcSqliteDriver(this.url, null, 2, null);
    }

    public /* synthetic */ TrimmableNormalizedCacheFactory(String string, Long l, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = null;
        }
        if ((n & 4) != 0) {
            f = 0.1f;
        }
        this(string, l, f);
    }

    @NotNull
    public SqlNormalizedCache create() {
        long size;
        String path;
        FactoryImplementationsKt.maybeCreateOrMigrateSchema((SqlDriver)this.driver, Blob2Database.Companion.getSchema());
        Blob2Database database = Blob2Database.Companion.invoke((SqlDriver)this.driver);
        Blob2Queries queries = database.getBlob2Queries();
        if (this.maxSize != null && !StringsKt.isBlank((CharSequence)(path = StringsKt.substringAfter$default((String)this.url, (String)"jdbc:sqlite:", null, (int)2, null))) && (size = new File(path).length()) >= this.maxSize) {
            long count2 = ((Number)queries.count().executeAsOne()).longValue();
            queries.trim((long)((float)count2 * this.trimFactor));
            SqlDriver.DefaultImpls.execute$default((SqlDriver)((SqlDriver)this.driver), null, (String)"VACUUM", (int)0, null, (int)8, null);
        }
        return new SqlNormalizedCache(new Blob2RecordDatabase(queries));
    }
}

