/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized;

import com.apollographql.apollo3.cache.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.CacheKey;
import com.apollographql.apollo3.cache.normalized.MemoryCache;
import com.apollographql.apollo3.cache.normalized.NormalizedCache;
import com.apollographql.apollo3.cache.normalized.Record;
import com.apollographql.apollo3.cache.normalized.internal.LruCache;
import com.apollographql.apollo3.mpp.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001'B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\r\u0010\u0010\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0011J$\u0010\u0012\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00150\u00130\u0013H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\"H\u0016J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"Lcom/apollographql/apollo3/cache/normalized/MemoryCache;", "Lcom/apollographql/apollo3/cache/normalized/NormalizedCache;", "maxSizeBytes", "", "expireAfterMillis", "", "(IJ)V", "lruCache", "Lcom/apollographql/apollo3/cache/normalized/internal/LruCache;", "", "Lcom/apollographql/apollo3/cache/normalized/MemoryCache$CacheEntry;", "size", "getSize", "()I", "clearAll", "", "clearCurrentCache", "clearCurrentCache$apollo_normalized_cache", "dump", "", "Lkotlin/reflect/KClass;", "Lcom/apollographql/apollo3/cache/normalized/Record;", "loadRecord", "key", "cacheHeaders", "Lcom/apollographql/apollo3/cache/CacheHeaders;", "loadRecords", "", "keys", "merge", "", "record", "records", "remove", "", "cacheKey", "Lcom/apollographql/apollo3/cache/normalized/CacheKey;", "cascade", "pattern", "CacheEntry", "apollo-normalized-cache"})
public final class MemoryCache
extends NormalizedCache {
    private final int maxSizeBytes;
    private final long expireAfterMillis;
    @NotNull
    private final LruCache<String, CacheEntry> lruCache;

    public MemoryCache(int maxSizeBytes, long expireAfterMillis) {
        this.maxSizeBytes = maxSizeBytes;
        this.expireAfterMillis = expireAfterMillis;
        this.lruCache = new LruCache(this.maxSizeBytes, lruCache.1.INSTANCE);
    }

    public /* synthetic */ MemoryCache(int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 2) != 0) {
            l = -1L;
        }
        this(n, l);
    }

    public final int getSize() {
        return this.lruCache.size();
    }

    @Nullable
    public Record loadRecord(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        Record record;
        CacheEntry cacheEntry;
        CacheEntry cacheEntry2;
        boolean bl;
        CacheEntry cacheEntry3;
        CacheEntry cacheEntry4;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        CacheEntry cacheEntry5 = this.lruCache.get(key);
        if (cacheEntry5 == null) {
            cacheEntry4 = null;
        } else {
            cacheEntry3 = cacheEntry5;
            boolean bl2 = false;
            bl = false;
            CacheEntry cacheEntry6 = cacheEntry3;
            boolean bl3 = false;
            if (cacheEntry6.isExpired() || cacheHeaders.hasHeader("evict-after-read")) {
                this.lruCache.remove(key);
            }
            cacheEntry4 = cacheEntry3;
        }
        cacheEntry3 = cacheEntry2 = cacheEntry4;
        if (cacheEntry3 == null) {
            cacheEntry = null;
        } else {
            CacheEntry cacheEntry7 = cacheEntry3;
            bl = false;
            boolean bl4 = false;
            CacheEntry it = cacheEntry7;
            boolean bl5 = false;
            cacheEntry = cacheEntry5 = !it.isExpired() ? cacheEntry7 : null;
        }
        if (cacheEntry5 == null) {
            cacheEntry3 = this.getNextCache();
            if (cacheEntry3 == null) {
                record = null;
            } else {
                Record record2 = cacheEntry3.loadRecord(key, cacheHeaders);
                if (record2 == null) {
                    record = null;
                } else {
                    Record record3 = record2;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Record nextCachedRecord = record3;
                    boolean bl8 = false;
                    this.lruCache.set(key, new CacheEntry(nextCachedRecord, this.expireAfterMillis));
                    record = record3;
                }
            }
        } else {
            record = cacheEntry5.getRecord();
        }
        return record;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys, @NotNull CacheHeaders cacheHeaders) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Iterable $this$mapNotNull$iv = keys;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Record record;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String key = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.loadRecord(key, cacheHeaders) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Record it$iv$iv = record;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void clearAll() {
        this.lruCache.clear();
        NormalizedCache normalizedCache = this.getNextCache();
        if (normalizedCache != null) {
            normalizedCache.clearAll();
        }
    }

    public boolean remove(@NotNull CacheKey cacheKey, boolean cascade) {
        boolean bl;
        NormalizedCache normalizedCache;
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        CacheEntry cacheEntry = this.lruCache.remove(cacheKey.getKey());
        if (cascade && cacheEntry != null) {
            for (CacheKey cacheReference : cacheEntry.getRecord().referencedFields()) {
                this.remove(new CacheKey(cacheReference.getKey()), true);
            }
        }
        boolean chainRemoved = (normalizedCache = this.getNextCache()) == null ? false : (bl = normalizedCache.remove(cacheKey, cascade));
        return cacheEntry != null || chainRemoved;
    }

    public int remove(@NotNull String pattern) {
        int n;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Regex regex = NormalizedCache.Companion.patternToRegex(pattern);
        int total = 0;
        HashSet keys = new HashSet(this.lruCache.keys());
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!regex.matches((CharSequence)it)) continue;
            this.lruCache.remove(it);
            int n2 = total;
            total = n2 + 1;
        }
        NormalizedCache normalizedCache = this.getNextCache();
        int chainRemoved = normalizedCache == null ? 0 : (n = normalizedCache.remove(pattern));
        return total + chainRemoved;
    }

    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders) {
        Pair pair;
        Set set;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        Record oldRecord = this.loadRecord(record.getKey(), cacheHeaders);
        if (oldRecord == null) {
            this.lruCache.set(record.getKey(), new CacheEntry(record, this.expireAfterMillis));
            set = record.fieldKeys();
        } else {
            pair = oldRecord.mergeWith(record);
            Record mergedRecord = (Record)pair.component1();
            Set changedKeys2 = (Set)pair.component2();
            this.lruCache.set(record.getKey(), new CacheEntry(mergedRecord, this.expireAfterMillis));
            set = changedKeys2;
        }
        Set changedKeys3 = set;
        pair = this.getNextCache();
        pair = pair == null ? null : pair.merge(record, cacheHeaders);
        boolean bl = false;
        Object object = pair;
        if (object == null) {
            object = SetsKt.emptySet();
        }
        return SetsKt.plus((Set)changedKeys3, (Iterable)((Iterable)object));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        Iterable $this$flatMap$iv = records;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Record record = (Record)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.merge(record, cacheHeaders);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object = this.lruCache.dump();
        KClass kClass = Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass());
        boolean $i$f$mapValues = false;
        void var3_4 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $dstr$_u24__u24$entry;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map2;
            boolean bl2 = false;
            void var16_17 = $dstr$_u24__u24$entry;
            boolean bl3 = false;
            CacheEntry entry3 = (CacheEntry)var16_17.getValue();
            Record record = entry3.getRecord();
            map.put(k2, record);
        }
        map = destination$iv$iv;
        Map map3 = MapsKt.mapOf((Pair)TuplesKt.to((Object)kClass, (Object)map));
        object = this.getNextCache();
        object = object == null ? null : object.dump();
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = MapsKt.emptyMap();
        }
        return MapsKt.plus((Map)map3, (Map)object2);
    }

    public final void clearCurrentCache$apollo_normalized_cache() {
        this.lruCache.clear();
    }

    public MemoryCache() {
        this(0, 0L, 3, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo3/cache/normalized/MemoryCache$CacheEntry;", "", "record", "Lcom/apollographql/apollo3/cache/normalized/Record;", "expireAfterMillis", "", "(Lcom/apollographql/apollo3/cache/normalized/Record;J)V", "cachedAtMillis", "getCachedAtMillis", "()J", "getExpireAfterMillis", "isExpired", "", "()Z", "getRecord", "()Lcom/apollographql/apollo3/cache/normalized/Record;", "sizeInBytes", "", "getSizeInBytes", "()I", "apollo-normalized-cache"})
    private static final class CacheEntry {
        @NotNull
        private final Record record;
        private final long expireAfterMillis;
        private final long cachedAtMillis;
        private final int sizeInBytes;

        public CacheEntry(@NotNull Record record, long expireAfterMillis) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            this.record = record;
            this.expireAfterMillis = expireAfterMillis;
            this.cachedAtMillis = UtilsKt.currentTimeMillis();
            this.sizeInBytes = this.record.getSizeInBytes() + 8;
        }

        @NotNull
        public final Record getRecord() {
            return this.record;
        }

        public final long getExpireAfterMillis() {
            return this.expireAfterMillis;
        }

        public final long getCachedAtMillis() {
            return this.cachedAtMillis;
        }

        public final int getSizeInBytes() {
            return this.sizeInBytes;
        }

        public final boolean isExpired() {
            return this.expireAfterMillis < 0L ? false : UtilsKt.currentTimeMillis() - this.cachedAtMillis >= this.expireAfterMillis;
        }
    }
}

