/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.internal;

import com.apollographql.apollo3.api.Executable;
import com.apollographql.apollo3.api.FieldSet;
import com.apollographql.apollo3.api.MergedField;
import com.apollographql.apollo3.cache.normalized.CacheReference;
import com.apollographql.apollo3.cache.normalized.Record;
import com.apollographql.apollo3.cache.normalized.internal.RealCacheKeyBuilder;
import com.apollographql.apollo3.cache.normalized.internal.ShouldSkipKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012(\u0010\u0004\u001a$\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u00a2\u0006\u0002\u0010\tJH\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u00072\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u0016\u0010\u001a\u001a\u00020\b*\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002J4\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0018*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00182\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J*\u0010\u0013\u001a\u00020\u001f*\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00072\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J@\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007*\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u0004\u001a$\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/apollographql/apollo3/cache/normalized/internal/Normalizer;", "", "variables", "Lcom/apollographql/apollo3/api/Executable$Variables;", "cacheKeyForObject", "Lkotlin/Function2;", "Lcom/apollographql/apollo3/api/MergedField;", "", "", "(Lcom/apollographql/apollo3/api/Executable$Variables;Lkotlin/jvm/functions/Function2;)V", "cacheKeyBuilder", "Lcom/apollographql/apollo3/cache/normalized/internal/RealCacheKeyBuilder;", "getCacheKeyForObject", "()Lkotlin/jvm/functions/Function2;", "records", "", "Lcom/apollographql/apollo3/cache/normalized/Record;", "getVariables", "()Lcom/apollographql/apollo3/api/Executable$Variables;", "normalize", "map", "path", "rootKey", "fieldSets", "", "Lcom/apollographql/apollo3/api/FieldSet;", "append", "next", "field", "fieldType", "Lcom/apollographql/apollo3/api/MergedField$Type$List;", "Lcom/apollographql/apollo3/cache/normalized/CacheReference;", "toFields", "apollo-normalized-cache"})
public final class Normalizer {
    @NotNull
    private final Executable.Variables variables;
    @NotNull
    private final Function2<MergedField, Map<String, ? extends Object>, String> cacheKeyForObject;
    @NotNull
    private final Map<String, Record> records;
    @NotNull
    private final RealCacheKeyBuilder cacheKeyBuilder;

    public Normalizer(@NotNull Executable.Variables variables, @NotNull Function2<? super MergedField, ? super Map<String, ? extends Object>, String> cacheKeyForObject) {
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        Intrinsics.checkNotNullParameter(cacheKeyForObject, (String)"cacheKeyForObject");
        this.variables = variables;
        this.cacheKeyForObject = cacheKeyForObject;
        boolean bl = false;
        this.records = new LinkedHashMap();
        this.cacheKeyBuilder = new RealCacheKeyBuilder();
    }

    @NotNull
    public final Executable.Variables getVariables() {
        return this.variables;
    }

    @NotNull
    public final Function2<MergedField, Map<String, ? extends Object>, String> getCacheKeyForObject() {
        return this.cacheKeyForObject;
    }

    @NotNull
    public final Map<String, Record> normalize(@NotNull Map<String, ? extends Object> map, @Nullable String path, @NotNull String rootKey, @NotNull List<FieldSet> fieldSets) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)rootKey, (String)"rootKey");
        Intrinsics.checkNotNullParameter(fieldSets, (String)"fieldSets");
        Map<String, Record> map2 = this.records;
        Record record = new Record(rootKey, this.toFields(map, path, fieldSets), null, 4, null);
        boolean bl = false;
        map2.put(rootKey, record);
        return this.records;
    }

    private final CacheReference normalize(Map<String, ? extends Object> $this$normalize, String path, MergedField field) {
        String string = (String)this.cacheKeyForObject.invoke((Object)field, $this$normalize);
        String key = string == null ? path : string;
        Record newRecord = new Record(key, this.toFields($this$normalize, key, field.getFieldSets()), null, 4, null);
        Record existingRecord = this.records.get(key);
        Record mergedRecord = existingRecord != null ? (Record)existingRecord.mergeWith(newRecord).getFirst() : newRecord;
        Map<String, Record> map = this.records;
        boolean bl = false;
        map.put(key, mergedRecord);
        return new CacheReference(key);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> toFields(Map<String, ? extends Object> $this$toFields, String path, List<FieldSet> fieldSets) {
        void $this$mapNotNullTo$iv$iv;
        FieldSet fieldSet;
        Object v0;
        FieldSet it;
        boolean $i$f$firstOrNull;
        Iterable $this$firstOrNull$iv;
        block9: {
            $this$firstOrNull$iv = fieldSets;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (FieldSet)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)$this$toFields.get("__typename"))) continue;
                v0 = element$iv;
                break block9;
            }
            v0 = null;
        }
        FieldSet fieldSet2 = v0;
        if (fieldSet2 == null) {
            Object v1;
            block10: {
                $this$firstOrNull$iv = fieldSets;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (FieldSet)element$iv;
                    boolean bl = false;
                    if (!(it.getType() == null)) continue;
                    v1 = element$iv;
                    break block10;
                }
                v1 = null;
            }
            fieldSet = v1;
        } else {
            fieldSet = fieldSet2;
        }
        FieldSet fieldSet3 = fieldSet;
        boolean bl = fieldSet3 != null;
        boolean $this$firstOrNull$iv2 = false;
        $i$f$firstOrNull = false;
        if (!bl) {
            boolean bl2 = false;
            String $i$f$firstOrNull2 = "No field set found at " + path + " on typeCondition " + $this$toFields;
            throw (Throwable)new IllegalStateException($i$f$firstOrNull2.toString());
        }
        MergedField[] $this$mapNotNull$iv = fieldSet3.getMergedFields();
        boolean $i$f$mapNotNull = false;
        MergedField[] $i$f$firstOrNull2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var12_19 = $this$forEach$iv$iv$iv;
        int n = ((void)var12_19).length;
        for (int i = 0; i < n; ++i) {
            Pair pair;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var12_19[i];
            boolean bl3 = false;
            void it2 = element$iv$iv;
            boolean bl4 = false;
            if (ShouldSkipKt.shouldSkip((MergedField)it2, this.getVariables().getValueMap())) {
                pair = null;
            } else {
                MergedField.Type unwrappedType;
                CacheReference value = $this$toFields.get(it2.getResponseName());
                boolean bl5 = !(it2.getType() instanceof MergedField.Type.NotNull) || value != null;
                boolean bl6 = false;
                boolean bl7 = false;
                bl7 = false;
                boolean bl8 = false;
                if (!bl5) {
                    boolean bl9 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                String fieldKey = this.cacheKeyBuilder.build((MergedField)it2, this.getVariables());
                MergedField.Type type = it2.getType();
                MergedField.Type.NotNull notNull = type instanceof MergedField.Type.NotNull ? (MergedField.Type.NotNull)type : null;
                MergedField.Type type2 = notNull == null ? null : notNull.getOfType();
                MergedField.Type type3 = unwrappedType = type2 == null ? it2.getType() : type2;
                pair = TuplesKt.to((Object)fieldKey, value == null ? null : (unwrappedType instanceof MergedField.Type.List ? this.normalize((List)value, this.append(path, fieldKey), (MergedField)it2, (MergedField.Type.List)unwrappedType) : (unwrappedType instanceof MergedField.Type.Named.Object ? this.normalize((Map)value, this.append(path, fieldKey), (MergedField)it2) : value)));
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl10 = false;
            boolean bl11 = false;
            Pair it$iv$iv = pair2;
            boolean bl12 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final String append(String $this$append, String next) {
        return $this$append == null ? next : $this$append + '.' + next;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Object> normalize(List<? extends Object> $this$normalize, String path, MergedField field, MergedField.Type.List fieldType) {
        void $this$mapIndexedTo$iv$iv;
        Object object = fieldType.getOfType();
        MergedField.Type.NotNull notNull = object instanceof MergedField.Type.NotNull ? (MergedField.Type.NotNull)object : null;
        MergedField.Type type = notNull == null ? null : notNull.getOfType();
        MergedField.Type unwrappedType = type == null ? fieldType.getOfType() : type;
        Iterable $this$mapIndexed$iv = $this$normalize;
        boolean $i$f$mapIndexed = false;
        object = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void value;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            CacheReference cacheReference = value == null ? null : (unwrappedType instanceof MergedField.Type.List ? this.normalize((List)value, this.append(path, String.valueOf((int)index)), field, (MergedField.Type.List)unwrappedType) : (unwrappedType instanceof MergedField.Type.Named.Object ? this.normalize((Map)value, this.append(path, String.valueOf((int)index)), field) : value));
            collection.add(cacheReference);
        }
        return (List)destination$iv$iv;
    }
}

