/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.ApolloClient;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.ExecutionContext;
import com.apollographql.apollo3.api.MutableExecutionOptions;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.cache.http.ApolloHttpCache;
import com.apollographql.apollo3.cache.http.CachingHttpInterceptor;
import com.apollographql.apollo3.cache.http.DiskLruHttpCache;
import com.apollographql.apollo3.cache.http.HttpFetchPolicy;
import com.apollographql.apollo3.cache.http.HttpFetchPolicyContext;
import com.apollographql.apollo3.cache.http.internal.CacheHeadersHttpInterceptor;
import com.apollographql.apollo3.cache.http.internal.HttpCacheApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.network.NetworkTransport;
import com.apollographql.apollo3.network.http.HttpInfo;
import com.apollographql.apollo3.network.http.HttpInterceptor;
import com.apollographql.apollo3.network.http.HttpNetworkTransport;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileSystem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a!\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\u0006\u001a\u0019\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a2\u0006\u0002\b\u0006\u001a#\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u00112\u0006\u0010\u000f\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013\u001a#\u0010\u0014\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u00112\u0006\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0015\u001a#\u0010\u0016\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u00112\u0006\u0010\u0016\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0017\u001a#\u0010\u0018\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u00112\u0006\u0010\u0018\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0017\"%\u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000e\"\u0015\u0010\u0000\u001a\u00020\b*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"httpCache", "Lcom/apollographql/apollo3/ApolloClient$Builder;", "directory", "Ljava/io/File;", "maxSize", "", "configureApolloClientBuilder", "apolloHttpCache", "Lcom/apollographql/apollo3/cache/http/ApolloHttpCache;", "isFromHttpCache", "", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/api/ApolloResponse;", "(Lcom/apollographql/apollo3/api/ApolloResponse;)Z", "httpFetchPolicy", "T", "Lcom/apollographql/apollo3/api/MutableExecutionOptions;", "Lcom/apollographql/apollo3/cache/http/HttpFetchPolicy;", "(Lcom/apollographql/apollo3/api/MutableExecutionOptions;Lcom/apollographql/apollo3/cache/http/HttpFetchPolicy;)Ljava/lang/Object;", "httpExpireTimeout", "(Lcom/apollographql/apollo3/api/MutableExecutionOptions;J)Ljava/lang/Object;", "httpExpireAfterRead", "(Lcom/apollographql/apollo3/api/MutableExecutionOptions;Z)Ljava/lang/Object;", "httpDoNotStore", "Lcom/apollographql/apollo3/ApolloClient;", "getHttpCache", "(Lcom/apollographql/apollo3/ApolloClient;)Lcom/apollographql/apollo3/cache/http/ApolloHttpCache;", "apollo-http-cache"})
@JvmName(name="HttpCache")
@SourceDebugExtension(value={"SMAP\nHttpCacheExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpCacheExtensions.kt\ncom/apollographql/apollo3/cache/http/HttpCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n295#2,2:134\n295#2,2:136\n295#2,2:138\n1755#2,3:140\n295#2,2:143\n*S KotlinDebug\n*F\n+ 1 HttpCacheExtensions.kt\ncom/apollographql/apollo3/cache/http/HttpCache\n*L\n71#1:134,2\n74#1:136,2\n81#1:138,2\n90#1:140,3\n127#1:143,2\n*E\n"})
public final class HttpCache {
    @JvmName(name="configureApolloClientBuilder")
    @NotNull
    public static final ApolloClient.Builder configureApolloClientBuilder(@NotNull ApolloClient.Builder $this$httpCache, @NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)$this$httpCache, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return HttpCache.configureApolloClientBuilder($this$httpCache, new DiskLruHttpCache(FileSystem.SYSTEM, directory, maxSize));
    }

    @JvmName(name="configureApolloClientBuilder")
    @NotNull
    public static final ApolloClient.Builder configureApolloClientBuilder(@NotNull ApolloClient.Builder $this$httpCache, @NotNull ApolloHttpCache apolloHttpCache) {
        ApolloClient.Builder builder;
        Map apolloRequestToCacheKey;
        CachingHttpInterceptor cachingHttpInterceptor;
        block8: {
            Object v4;
            ApolloClient.Builder $this$httpCache_u24lambda_u247;
            block7: {
                Object v2;
                HttpInterceptor it;
                Iterable $this$firstOrNull$iv;
                ApolloClient.Builder $this$httpCache_u24lambda_u244;
                block6: {
                    Object v0;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)$this$httpCache, (String)"<this>");
                        Intrinsics.checkNotNullParameter((Object)apolloHttpCache, (String)"apolloHttpCache");
                        cachingHttpInterceptor = new CachingHttpInterceptor(apolloHttpCache);
                        apolloRequestToCacheKey = new LinkedHashMap();
                        $this$httpCache_u24lambda_u244 = builder = $this$httpCache;
                        boolean bl = false;
                        $this$firstOrNull$iv = $this$httpCache_u24lambda_u244.getHttpInterceptors();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = (HttpInterceptor)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof CacheHeadersHttpInterceptor)) continue;
                            v0 = element$iv;
                            break block5;
                        }
                        v0 = null;
                    }
                    HttpInterceptor httpInterceptor = v0;
                    if (httpInterceptor != null) {
                        HttpInterceptor it2 = httpInterceptor;
                        boolean bl = false;
                        $this$httpCache_u24lambda_u244.removeHttpInterceptor(it2);
                    }
                    $this$firstOrNull$iv = $this$httpCache_u24lambda_u244.getHttpInterceptors();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (HttpInterceptor)element$iv;
                        boolean bl = false;
                        if (!(it instanceof CachingHttpInterceptor)) continue;
                        v2 = element$iv;
                        break block6;
                    }
                    v2 = null;
                }
                HttpInterceptor httpInterceptor = v2;
                if (httpInterceptor != null) {
                    HttpInterceptor it3 = httpInterceptor;
                    boolean bl = false;
                    $this$httpCache_u24lambda_u244.removeHttpInterceptor(it3);
                }
                $this$httpCache_u24lambda_u247 = builder = builder.addHttpInterceptor((HttpInterceptor)new CacheHeadersHttpInterceptor(apolloRequestToCacheKey)).addHttpInterceptor((HttpInterceptor)cachingHttpInterceptor);
                boolean bl = false;
                $this$firstOrNull$iv = $this$httpCache_u24lambda_u247.getInterceptors();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (ApolloInterceptor)element$iv;
                    boolean bl3 = false;
                    if (!(it instanceof HttpCacheApolloInterceptor)) continue;
                    v4 = element$iv;
                    break block7;
                }
                v4 = null;
            }
            ApolloInterceptor apolloInterceptor = v4;
            if (apolloInterceptor == null) break block8;
            ApolloInterceptor it = apolloInterceptor;
            boolean bl = false;
            $this$httpCache_u24lambda_u247.removeInterceptor(it);
        }
        return builder.addInterceptor((ApolloInterceptor)new HttpCacheApolloInterceptor(apolloRequestToCacheKey, cachingHttpInterceptor));
    }

    public static final <D extends Operation.Data> boolean isFromHttpCache(@NotNull ApolloResponse<D> $this$isFromHttpCache) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter($this$isFromHttpCache, (String)"<this>");
            Object object = (HttpInfo)$this$isFromHttpCache.executionContext.get((ExecutionContext.Key)HttpInfo.Key);
            if (object != null && (object = object.getHeaders()) != null) {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        HttpHeader it = (HttpHeader)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"X-APOLLO-FROM-CACHE")) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public static final <T> T httpFetchPolicy(@NotNull MutableExecutionOptions<T> $this$httpFetchPolicy, @NotNull HttpFetchPolicy httpFetchPolicy) {
        Intrinsics.checkNotNullParameter($this$httpFetchPolicy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)httpFetchPolicy), (String)"httpFetchPolicy");
        return (T)$this$httpFetchPolicy.addExecutionContext((ExecutionContext)new HttpFetchPolicyContext(httpFetchPolicy));
    }

    public static final <T> T httpExpireTimeout(@NotNull MutableExecutionOptions<T> $this$httpExpireTimeout, long httpExpireTimeout) {
        Intrinsics.checkNotNullParameter($this$httpExpireTimeout, (String)"<this>");
        return (T)$this$httpExpireTimeout.addHttpHeader("X-APOLLO-EXPIRE-TIMEOUT", String.valueOf(httpExpireTimeout));
    }

    public static final <T> T httpExpireAfterRead(@NotNull MutableExecutionOptions<T> $this$httpExpireAfterRead, boolean httpExpireAfterRead) {
        Intrinsics.checkNotNullParameter($this$httpExpireAfterRead, (String)"<this>");
        return (T)$this$httpExpireAfterRead.addHttpHeader("X-APOLLO-EXPIRE-AFTER-READ", String.valueOf(httpExpireAfterRead));
    }

    public static final <T> T httpDoNotStore(@NotNull MutableExecutionOptions<T> $this$httpDoNotStore, boolean httpDoNotStore) {
        Intrinsics.checkNotNullParameter($this$httpDoNotStore, (String)"<this>");
        return (T)$this$httpDoNotStore.addHttpHeader("X-APOLLO-CACHE-DO-NOT-STORE", String.valueOf(httpDoNotStore));
    }

    @NotNull
    public static final ApolloHttpCache getHttpCache(@NotNull ApolloClient $this$httpCache) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$httpCache, (String)"<this>");
            NetworkTransport networkTransport = $this$httpCache.getNetworkTransport();
            HttpNetworkTransport httpNetworkTransport = networkTransport instanceof HttpNetworkTransport ? (HttpNetworkTransport)networkTransport : null;
            if (httpNetworkTransport == null) {
                throw new IllegalStateException("cannot get the HttpCache, networkTransport is not a HttpNetworkTransport".toString());
            }
            HttpNetworkTransport httpNetworkTransport2 = httpNetworkTransport;
            Iterable $this$firstOrNull$iv = httpNetworkTransport2.getInterceptors();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HttpInterceptor it = (HttpInterceptor)element$iv;
                boolean bl = false;
                if (!(it instanceof CachingHttpInterceptor)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        HttpInterceptor httpInterceptor = v1;
        if (httpInterceptor == null) {
            throw new IllegalStateException("no http cache configured".toString());
        }
        HttpInterceptor cachingHttpInterceptor = httpInterceptor;
        return ((CachingHttpInterceptor)cachingHttpInterceptor).getCache();
    }
}

