/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http.internal;

import java.io.IOException;
import java.net.ProtocolException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Protocol;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0007H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/apollographql/apollo3/cache/http/internal/StatusLine;", "", "protocol", "Lokhttp3/Protocol;", "code", "", "message", "", "(Lokhttp3/Protocol;ILjava/lang/String;)V", "getCode", "()I", "getMessage", "()Ljava/lang/String;", "getProtocol", "()Lokhttp3/Protocol;", "toString", "Companion", "apollo-http-cache"})
public final class StatusLine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Protocol protocol;
    private final int code;
    @Nullable
    private final String message;
    public static final int HTTP_TEMP_REDIRECT = 307;
    public static final int HTTP_PERM_REDIRECT = 308;
    public static final int HTTP_CONTINUE = 100;

    public StatusLine(@Nullable Protocol protocol, int code, @Nullable String message) {
        this.protocol = protocol;
        this.code = code;
        this.message = message;
    }

    @Nullable
    public final Protocol getProtocol() {
        return this.protocol;
    }

    public final int getCode() {
        return this.code;
    }

    @Nullable
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.protocol == Protocol.HTTP_1_0 ? "HTTP/1.0" : "HTTP/1.1");
        result.append(' ').append(this.code);
        if (this.message != null) {
            result.append(' ').append(this.message);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/apollographql/apollo3/cache/http/internal/StatusLine$Companion;", "", "()V", "HTTP_CONTINUE", "", "HTTP_PERM_REDIRECT", "HTTP_TEMP_REDIRECT", "get", "Lcom/apollographql/apollo3/cache/http/internal/StatusLine;", "response", "Lokhttp3/Response;", "parse", "statusLine", "", "apollo-http-cache"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StatusLine get(@NotNull Response response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            return new StatusLine(response.protocol(), response.code(), response.message());
        }

        @NotNull
        public final StatusLine parse(@NotNull String statusLine) throws IOException {
            int n;
            int n2;
            Intrinsics.checkNotNullParameter((Object)statusLine, (String)"statusLine");
            int codeStart = 0;
            Protocol protocol = null;
            if (StringsKt.startsWith$default((String)statusLine, (String)"HTTP/1.", (boolean)false, (int)2, null)) {
                Protocol protocol2;
                if (statusLine.length() < 9 || statusLine.charAt(8) != ' ') {
                    throw new ProtocolException(Intrinsics.stringPlus((String)"Unexpected status line: ", (Object)statusLine));
                }
                int httpMinorVersion = statusLine.charAt(7) - 48;
                codeStart = 9;
                switch (httpMinorVersion) {
                    case 0: {
                        protocol2 = Protocol.HTTP_1_0;
                        break;
                    }
                    case 1: {
                        protocol2 = Protocol.HTTP_1_1;
                        break;
                    }
                    default: {
                        throw new ProtocolException(Intrinsics.stringPlus((String)"Unexpected status line: ", (Object)statusLine));
                    }
                }
                protocol = protocol2;
            } else if (StringsKt.startsWith$default((String)statusLine, (String)"ICY ", (boolean)false, (int)2, null)) {
                protocol = Protocol.HTTP_1_0;
                codeStart = 4;
            } else {
                throw new ProtocolException(Intrinsics.stringPlus((String)"Unexpected status line: ", (Object)statusLine));
            }
            if (statusLine.length() < codeStart + 3) {
                throw new ProtocolException(Intrinsics.stringPlus((String)"Unexpected status line: ", (Object)statusLine));
            }
            int code = 0;
            try {
                String string = statusLine;
                int n3 = codeStart + 3;
                n2 = 0;
                String string2 = string.substring(codeStart, n3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string = string2;
                n3 = 0;
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                throw new ProtocolException(Intrinsics.stringPlus((String)"Unexpected status line: ", (Object)statusLine));
            }
            code = n;
            String message = "";
            if (statusLine.length() > codeStart + 3) {
                if (statusLine.charAt(codeStart + 3) != ' ') {
                    throw new ProtocolException(Intrinsics.stringPlus((String)"Unexpected status line: ", (Object)statusLine));
                }
                String string = statusLine;
                n2 = codeStart + 4;
                boolean bl = false;
                String string3 = string.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                message = string3;
            }
            return new StatusLine(protocol, code, message);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

