/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.cache.http.Utils;
import com.apollographql.apollo3.cache.http.internal.StatusLine;
import java.io.Closeable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CipherSuite;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.TlsVersion;
import okhttp3.internal.http.HttpMethod;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0002\u001a\u00020#H\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u000e\u0010(\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020)R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/apollographql/apollo3/cache/http/ResponseHeaderRecord;", "", "source", "Lokio/Source;", "(Lokio/Source;)V", "response", "Lokhttp3/Response;", "(Lokhttp3/Response;)V", "code", "", "handshake", "Lokhttp3/Handshake;", "isHttps", "", "()Z", "message", "", "protocol", "Lokhttp3/Protocol;", "receivedResponseMillis", "", "requestMethod", "responseHeaders", "Lokhttp3/Headers;", "sentRequestMillis", "url", "varyHeaders", "addHeaderLenient", "", "headersBuilder", "Lokhttp3/Headers$Builder;", "line", "readCertificateList", "", "Ljava/security/cert/Certificate;", "Lokio/BufferedSource;", "writeCertList", "sink", "Lokio/BufferedSink;", "certificates", "writeTo", "Lokio/Sink;", "Companion", "apollo-http-cache"})
public final class ResponseHeaderRecord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @Nullable
    private final Headers varyHeaders;
    @NotNull
    private final String requestMethod;
    @Nullable
    private final Protocol protocol;
    private final int code;
    @Nullable
    private final String message;
    @NotNull
    private final Headers responseHeaders;
    @Nullable
    private final Handshake handshake;
    private final long sentRequestMillis;
    private final long receivedResponseMillis;
    @NotNull
    private static final String SENT_MILLIS = "OkHttp-Sent-Millis";
    @NotNull
    private static final String RECEIVED_MILLIS = "OkHttp-Received-Millis";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseHeaderRecord(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Closeable closeable = (Closeable)source;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Handshake handshake;
            Source it = (Source)closeable;
            boolean bl3 = false;
            BufferedSource buffer = Okio.buffer((Source)it);
            this.url = buffer.readUtf8LineStrict();
            this.requestMethod = buffer.readUtf8LineStrict();
            Headers.Builder varyHeadersBuilder = new Headers.Builder();
            int varyRequestHeaderLineCount = ResponseHeaderRecord.Companion.readInt(buffer);
            int n = 0;
            if (n < varyRequestHeaderLineCount) {
                do {
                    int i = n++;
                    this.addHeaderLenient(varyHeadersBuilder, buffer.readUtf8LineStrict());
                } while (n < varyRequestHeaderLineCount);
            }
            this.varyHeaders = varyHeadersBuilder.build();
            StatusLine statusLine = StatusLine.Companion.parse(buffer.readUtf8LineStrict());
            this.protocol = statusLine.getProtocol();
            this.code = statusLine.getCode();
            this.message = statusLine.getMessage();
            Headers.Builder responseHeadersBuilder = new Headers.Builder();
            int n2 = 0;
            int responseHeaderLineCount = ResponseHeaderRecord.Companion.readInt(buffer);
            if (n2 < responseHeaderLineCount) {
                do {
                    int i = n2++;
                    this.addHeaderLenient(responseHeadersBuilder, buffer.readUtf8LineStrict());
                } while (n2 < responseHeaderLineCount);
            }
            String sendRequestMillisString = responseHeadersBuilder.get(SENT_MILLIS);
            String receivedResponseMillisString = responseHeadersBuilder.get(RECEIVED_MILLIS);
            responseHeadersBuilder.removeAll(SENT_MILLIS);
            responseHeadersBuilder.removeAll(RECEIVED_MILLIS);
            Intrinsics.checkNotNullExpressionValue((Object)sendRequestMillisString, (String)"sendRequestMillisString");
            String string = sendRequestMillisString;
            boolean bl4 = false;
            this.sentRequestMillis = Long.parseLong(string);
            Intrinsics.checkNotNullExpressionValue((Object)receivedResponseMillisString, (String)"receivedResponseMillisString");
            string = receivedResponseMillisString;
            bl4 = false;
            this.receivedResponseMillis = Long.parseLong(string);
            string = responseHeadersBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"responseHeadersBuilder.build()");
            this.responseHeaders = string;
            if (this.isHttps()) {
                String blank = buffer.readUtf8LineStrict();
                CharSequence charSequence = blank;
                boolean bl5 = false;
                if (charSequence.length() > 0) {
                    throw new IOException("expected \"\" but was \"" + blank + '\"');
                }
                String cipherSuiteString = buffer.readUtf8LineStrict();
                CipherSuite cipherSuite = CipherSuite.forJavaName((String)cipherSuiteString);
                List<Certificate> peerCertificates = this.readCertificateList(buffer);
                List<Certificate> localCertificates = this.readCertificateList(buffer);
                TlsVersion tlsVersion = !buffer.exhausted() ? TlsVersion.forJavaName((String)buffer.readUtf8LineStrict()) : null;
                handshake = Handshake.get((TlsVersion)tlsVersion, (CipherSuite)cipherSuite, peerCertificates, localCertificates);
            } else {
                handshake = null;
            }
            this.handshake = handshake;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public ResponseHeaderRecord(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String string = response.request().url().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.request().url().toString()");
        this.url = string;
        this.varyHeaders = Utils.INSTANCE.varyHeaders(response);
        string = response.request().method();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.request().method()");
        this.requestMethod = string;
        this.protocol = response.protocol();
        this.code = response.code();
        this.message = response.message();
        string = response.headers();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.headers()");
        this.responseHeaders = string;
        this.handshake = response.handshake();
        this.sentRequestMillis = response.sentRequestAtMillis();
        this.receivedResponseMillis = response.receivedResponseAtMillis();
    }

    public final void writeTo(@NotNull Sink sink) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        BufferedSink bufferedSink = Okio.buffer((Sink)sink);
        bufferedSink.writeUtf8(this.url).writeByte(10);
        bufferedSink.writeUtf8(this.requestMethod).writeByte(10);
        Object object = this.varyHeaders;
        Intrinsics.checkNotNull((Object)object);
        bufferedSink.writeDecimalLong((long)object.size()).writeByte(10);
        object = this;
        boolean bl = false;
        int n = 0;
        ResponseHeaderRecord $this$writeTo_u24lambda_u2d1 = (ResponseHeaderRecord)object;
        boolean bl2 = false;
        int i = 0;
        Object object2 = $this$writeTo_u24lambda_u2d1.varyHeaders;
        Intrinsics.checkNotNull((Object)object2);
        int size = object2.size();
        while (i < size) {
            object2 = $this$writeTo_u24lambda_u2d1.varyHeaders.name(i);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"varyHeaders.name(i)");
            BufferedSink bufferedSink2 = bufferedSink.writeUtf8((String)object2).writeUtf8(": ");
            object2 = $this$writeTo_u24lambda_u2d1.varyHeaders.value(i);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"varyHeaders.value(i)");
            bufferedSink2.writeUtf8((String)object2).writeByte(10);
            int n2 = i;
            i = n2 + 1;
        }
        bufferedSink.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
        bufferedSink.writeDecimalLong((long)(this.responseHeaders.size() + 2)).writeByte(10);
        int i2 = 0;
        int size2 = this.responseHeaders.size();
        while (i2 < size2) {
            String string = this.responseHeaders.name(i2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"responseHeaders.name(i)");
            BufferedSink bufferedSink3 = bufferedSink.writeUtf8(string).writeUtf8(": ");
            string = this.responseHeaders.value(i2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"responseHeaders.value(i)");
            bufferedSink3.writeUtf8(string).writeByte(10);
            n = i2;
            i2 = n + 1;
        }
        bufferedSink.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
        bufferedSink.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
        if (this.isHttps()) {
            bufferedSink.writeByte(10);
            Handshake handshake = this.handshake;
            Intrinsics.checkNotNull((Object)handshake);
            Object object3 = handshake.cipherSuite().javaName();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"handshake!!.cipherSuite().javaName()");
            bufferedSink.writeUtf8((String)object3).writeByte(10);
            object3 = this.handshake.peerCertificates();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"handshake.peerCertificates()");
            this.writeCertList(bufferedSink, (List<? extends Certificate>)object3);
            object3 = this.handshake.localCertificates();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"handshake.localCertificates()");
            this.writeCertList(bufferedSink, (List<? extends Certificate>)object3);
            if (this.handshake.tlsVersion() != null) {
                object3 = this.handshake.tlsVersion().javaName();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"handshake.tlsVersion().javaName()");
                bufferedSink.writeUtf8((String)object3).writeByte(10);
            }
        }
        bufferedSink.close();
    }

    private final boolean isHttps() {
        return StringsKt.startsWith$default((String)this.url, (String)"https://", (boolean)false, (int)2, null);
    }

    private final List<Certificate> readCertificateList(BufferedSource source) throws IOException {
        List list;
        int length = ResponseHeaderRecord.Companion.readInt(source);
        if (length == -1) {
            list = CollectionsKt.emptyList();
        } else {
            List list2;
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                List result = new ArrayList(length);
                int n = 0;
                if (n < length) {
                    do {
                        int i = n++;
                        String line = source.readUtf8LineStrict();
                        Buffer bytes = new Buffer();
                        Object object = ByteString.Companion.decodeBase64(line);
                        if (object != null) {
                            ByteString byteString = object;
                            boolean bl = false;
                            boolean bl2 = false;
                            ByteString it = byteString;
                            boolean bl3 = false;
                            bytes.write(it);
                        }
                        object = certificateFactory.generateCertificate(bytes.inputStream());
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"certificateFactory.generateCertificate(bytes.inputStream())");
                        result.add(object);
                    } while (n < length);
                }
                list2 = result;
            }
            catch (CertificateException e) {
                throw new IOException(e.getMessage());
            }
            list = list2;
        }
        return list;
    }

    private final void writeCertList(BufferedSink sink, List<? extends Certificate> certificates) throws IOException {
        try {
            sink.writeDecimalLong((long)certificates.size()).writeByte(10);
            int i = 0;
            int size = certificates.size();
            while (i < size) {
                byte[] bytes = certificates.get(i).getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
                String line = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])bytes, (int)0, (int)0, (int)3, null).base64();
                sink.writeUtf8(line).writeByte(10);
                int n = i;
                i = n + 1;
            }
        }
        catch (CertificateEncodingException e) {
            throw new IOException(e.getMessage());
        }
    }

    @NotNull
    public final Response response() {
        RequestBody body = null;
        if (HttpMethod.permitsRequestBody((String)this.requestMethod)) {
            body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)"");
        }
        Request cacheRequest = new Request.Builder().url(this.url).method(this.requestMethod, body).headers(this.varyHeaders).build();
        Response response = new Response.Builder().request(cacheRequest).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"Builder()\n        .request(cacheRequest)\n        .protocol(protocol)\n        .code(code)\n        .message(message)\n        .headers(responseHeaders)\n        .handshake(handshake)\n        .sentRequestAtMillis(sentRequestMillis)\n        .receivedResponseAtMillis(receivedResponseMillis)\n        .build()");
        return response;
    }

    private final void addHeaderLenient(Headers.Builder headersBuilder, String line) {
        int index = StringsKt.indexOf$default((CharSequence)line, (String)":", (int)1, (boolean)false, (int)4, null);
        if (index != -1) {
            String string = line;
            int n = 0;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, index);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = line;
            n = index + 1;
            bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            headersBuilder.add(string3, string5);
        } else if (StringsKt.startsWith$default((String)line, (String)":", (boolean)false, (int)2, null)) {
            String string = line;
            int n = 1;
            boolean bl = false;
            String string6 = string;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            headersBuilder.add("", string7);
        } else {
            headersBuilder.add("", line);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/apollographql/apollo3/cache/http/ResponseHeaderRecord$Companion;", "", "()V", "RECEIVED_MILLIS", "", "SENT_MILLIS", "readInt", "", "source", "Lokio/BufferedSource;", "apollo-http-cache"})
    public static final class Companion {
        private Companion() {
        }

        private final int readInt(BufferedSource source) throws IOException {
            int n;
            try {
                long result;
                block5: {
                    String line;
                    block4: {
                        result = source.readDecimalLong();
                        line = source.readUtf8LineStrict();
                        if (result < 0L || result > Integer.MAX_VALUE) break block4;
                        CharSequence charSequence = line;
                        boolean bl = false;
                        if (!(charSequence.length() > 0)) break block5;
                    }
                    throw new IOException("expected an int but was \"" + result + line + '\"');
                }
                n = (int)result;
            }
            catch (NumberFormatException e) {
                throw new IOException(e.getMessage());
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

