/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.ApolloClient;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.ExecutionContext;
import com.apollographql.apollo3.api.ExecutionParameters;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.http.HttpContextKt;
import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.cache.http.CachingHttpEngine;
import com.apollographql.apollo3.cache.http.HttpFetchPolicy;
import com.apollographql.apollo3.network.NetworkTransport;
import com.apollographql.apollo3.network.http.HttpEngine;
import com.apollographql.apollo3.network.http.HttpInfo;
import com.apollographql.apollo3.network.http.HttpNetworkTransport;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a-\u0010\f\u001a\u0002H\r\"\u000e\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e*\b\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0010\u001a-\u0010\u0011\u001a\u0002H\r\"\u000e\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e*\b\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u0012\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0010\u001a-\u0010\u0013\u001a\u0002H\r\"\u000e\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e*\b\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0015\u001a-\u0010\u0016\u001a\u0002H\r\"\u000e\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e*\b\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019\"%\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0005\u00a8\u0006\u001a"}, d2={"isFromHttpCache", "", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/api/ApolloResponse;", "(Lcom/apollographql/apollo3/api/ApolloResponse;)Z", "withHttpCache", "Lcom/apollographql/apollo3/ApolloClient;", "directory", "Ljava/io/File;", "maxSize", "", "withHttpDoNotStore", "T", "Lcom/apollographql/apollo3/api/ExecutionParameters;", "doNotStore", "(Lcom/apollographql/apollo3/api/ExecutionParameters;Z)Lcom/apollographql/apollo3/api/ExecutionParameters;", "withHttpExpireAfterRead", "expireAfterRead", "withHttpExpireTimeout", "millis", "(Lcom/apollographql/apollo3/api/ExecutionParameters;J)Lcom/apollographql/apollo3/api/ExecutionParameters;", "withHttpFetchPolicy", "httpFetchPolicy", "Lcom/apollographql/apollo3/cache/http/HttpFetchPolicy;", "(Lcom/apollographql/apollo3/api/ExecutionParameters;Lcom/apollographql/apollo3/cache/http/HttpFetchPolicy;)Lcom/apollographql/apollo3/api/ExecutionParameters;", "apollo-http-cache"})
public final class HttpCacheExtensionsKt {
    @NotNull
    public static final ApolloClient withHttpCache(@NotNull ApolloClient $this$withHttpCache, @NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)$this$withHttpCache, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        NetworkTransport networkTransport = $this$withHttpCache.getNetworkTransport();
        boolean bl = networkTransport instanceof HttpNetworkTransport;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "withHttpCache requires a HttpNetworkTransport";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return ApolloClient.copy$default((ApolloClient)$this$withHttpCache, (NetworkTransport)((NetworkTransport)HttpNetworkTransport.copy$default((HttpNetworkTransport)((HttpNetworkTransport)networkTransport), null, (HttpEngine)new CachingHttpEngine(directory, maxSize, null, ((HttpNetworkTransport)networkTransport).getEngine(), 4, null), null, (int)5, null)), null, null, null, null, null, null, (int)126, null);
    }

    public static final <D extends Operation.Data> boolean isFromHttpCache(@NotNull ApolloResponse<? extends D> $this$isFromHttpCache) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isFromHttpCache, (String)"<this>");
        HttpInfo httpInfo = (HttpInfo)$this$isFromHttpCache.executionContext.get((ExecutionContext.Key)HttpInfo.Key);
        if (httpInfo == null) {
            bl = false;
        } else {
            List list = httpInfo.getHeaders();
            if (list == null) {
                bl = false;
            } else {
                boolean bl2;
                boolean bl3;
                block7: {
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            HttpHeader it = (HttpHeader)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"X-APOLLO-FROM-CACHE")) continue;
                            bl3 = true;
                            break block7;
                        }
                        bl3 = false;
                    }
                }
                bl = bl2 = bl3;
            }
        }
        return bl;
    }

    @NotNull
    public static final <T extends ExecutionParameters<T>> T withHttpFetchPolicy(@NotNull ExecutionParameters<T> $this$withHttpFetchPolicy, @NotNull HttpFetchPolicy httpFetchPolicy) {
        String string;
        Intrinsics.checkNotNullParameter($this$withHttpFetchPolicy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)httpFetchPolicy), (String)"httpFetchPolicy");
        HttpFetchPolicy httpFetchPolicy2 = httpFetchPolicy;
        int n = WhenMappings.$EnumSwitchMapping$0[httpFetchPolicy2.ordinal()];
        switch (n) {
            case 1: {
                string = "CACHE_FIRST";
                break;
            }
            case 2: {
                string = "CACHE_ONLY";
                break;
            }
            case 3: {
                string = "NETWORK_FIRST";
                break;
            }
            case 4: {
                string = "NETWORK_ONLY";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String policyStr = string;
        return (T)HttpContextKt.withHttpHeader($this$withHttpFetchPolicy, (String)"X-APOLLO-CACHE-FETCH-POLICY", (String)policyStr);
    }

    @NotNull
    public static final <T extends ExecutionParameters<T>> T withHttpExpireTimeout(@NotNull ExecutionParameters<T> $this$withHttpExpireTimeout, long millis) {
        Intrinsics.checkNotNullParameter($this$withHttpExpireTimeout, (String)"<this>");
        return (T)HttpContextKt.withHttpHeader($this$withHttpExpireTimeout, (String)"X-APOLLO-EXPIRE-TIMEOUT", (String)String.valueOf(millis));
    }

    @NotNull
    public static final <T extends ExecutionParameters<T>> T withHttpExpireAfterRead(@NotNull ExecutionParameters<T> $this$withHttpExpireAfterRead, boolean expireAfterRead) {
        Intrinsics.checkNotNullParameter($this$withHttpExpireAfterRead, (String)"<this>");
        return (T)HttpContextKt.withHttpHeader($this$withHttpExpireAfterRead, (String)"X-APOLLO-EXPIRE-AFTER-READ", (String)String.valueOf(expireAfterRead));
    }

    @NotNull
    public static final <T extends ExecutionParameters<T>> T withHttpDoNotStore(@NotNull ExecutionParameters<T> $this$withHttpDoNotStore, boolean doNotStore) {
        Intrinsics.checkNotNullParameter($this$withHttpDoNotStore, (String)"<this>");
        return (T)HttpContextKt.withHttpHeader($this$withHttpDoNotStore, (String)"X-APOLLO-CACHE-DO-NOT-STORE", (String)String.valueOf(doNotStore));
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpFetchPolicy.values().length];
            nArray[HttpFetchPolicy.CacheFirst.ordinal()] = 1;
            nArray[HttpFetchPolicy.CacheOnly.ordinal()] = 2;
            nArray[HttpFetchPolicy.NetworkFirst.ordinal()] = 3;
            nArray[HttpFetchPolicy.NetworkOnly.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

