/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.connection;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.EventListener;
import com.apollographql.apollo3.relocated.okhttp3.Request;
import com.apollographql.apollo3.relocated.okhttp3.Response;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.Exchange$ResponseBodySource;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.ExchangeFinder;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealCall;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealCall$timeout$1;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealConnection;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealConnection$newWebSocketStreams$1;
import com.apollographql.apollo3.relocated.okhttp3.internal.http.ExchangeCodec;
import com.apollographql.apollo3.relocated.okhttp3.internal.http.RealResponseBody;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.ConnectionShutdownException;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.ErrorCode;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.StreamResetException;
import com.apollographql.apollo3.relocated.okio.AsyncTimeout$Companion;
import com.apollographql.apollo3.relocated.okio.BufferedSource;
import com.apollographql.apollo3.relocated.okio.RealBufferedSink;
import com.apollographql.apollo3.relocated.okio.RealBufferedSource;
import com.apollographql.apollo3.relocated.okio.Source;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;

public final class Exchange {
    public final RealCall call;
    public final EventListener eventListener;
    public final ExchangeFinder finder;
    public final ExchangeCodec codec;
    public boolean isDuplex;
    public boolean hasFailure;
    public final RealConnection connection;

    public Exchange(RealCall realCall, EventListener eventListener, ExchangeFinder exchangeFinder, ExchangeCodec exchangeCodec) {
        Intrinsics.checkNotNullParameter(realCall, "call");
        Intrinsics.checkNotNullParameter(eventListener, "eventListener");
        this.call = realCall;
        this.eventListener = eventListener;
        this.finder = exchangeFinder;
        this.codec = exchangeCodec;
        this.connection = exchangeCodec.getConnection();
    }

    public final void writeRequestHeaders(Request object) {
        EventListener eventListener;
        Exchange exchange;
        Exchange exchange2;
        Exchange exchange3;
        Exchange exchange4;
        try {
            Exchange exchange5 = eventListener2;
            exchange4 = exchange5;
            exchange3 = exchange5;
            exchange2 = exchange5;
            exchange = exchange5;
            eventListener = exchange5.eventListener;
        }
        catch (IOException iOException) {
            Exchange exchange6 = eventListener2;
            Exchange exchange7 = eventListener2;
            EventListener eventListener2 = exchange7.eventListener;
            RealCall realCall = exchange7.call;
            eventListener2.getClass();
            Intrinsics.checkNotNullParameter(realCall, "call");
            exchange6.trackFailure(iOException);
            throw iOException;
        }
        RealCall realCall = exchange3.call;
        eventListener.getClass();
        Intrinsics.checkNotNullParameter(realCall, "call");
        exchange2.codec.writeRequestHeaders((Request)object);
        object = exchange.eventListener;
        RealCall realCall2 = exchange4.call;
        object.getClass();
        Intrinsics.checkNotNullParameter(realCall2, "call");
    }

    public final RealResponseBody openResponseBody(Response closeable) {
        RealBufferedSource realBufferedSource;
        RealResponseBody realResponseBody;
        Exchange$ResponseBodySource exchange$ResponseBodySource;
        String string;
        Response response2;
        Exchange exchange;
        Exchange exchange2;
        try {
            Exchange exchange3 = eventListener;
            exchange2 = exchange3;
            exchange = exchange3;
            response2 = closeable;
            string = "Content-Type";
        }
        catch (IOException iOException) {
            Exchange exchange4 = eventListener;
            Exchange exchange5 = eventListener;
            EventListener eventListener = exchange5.eventListener;
            RealCall realCall = exchange5.call;
            eventListener.getClass();
            Intrinsics.checkNotNullParameter(realCall, "call");
            exchange4.trackFailure(iOException);
            throw iOException;
        }
        response2.headers.get(string);
        long l = exchange2.codec.reportedContentLength((Response)closeable);
        closeable = exchange.codec.openResponseBodySource((Response)closeable);
        Exchange$ResponseBodySource exchange$ResponseBodySource2 = exchange$ResponseBodySource;
        exchange$ResponseBodySource = new Exchange$ResponseBodySource((Exchange)((Object)eventListener), (Source)closeable, l);
        RealResponseBody realResponseBody2 = realResponseBody;
        RealResponseBody realResponseBody3 = realResponseBody;
        long l2 = l;
        closeable = realBufferedSource;
        realBufferedSource = new RealBufferedSource(exchange$ResponseBodySource2);
        realResponseBody2(l2, (RealBufferedSource)closeable);
        return realResponseBody3;
    }

    public final RealConnection$newWebSocketStreams$1 newWebSocketStreams() {
        Object object = this.call;
        if (((RealCall)object).timeoutEarlyExit ^ true) {
            ((RealCall)object).timeoutEarlyExit = true;
            RealCall$timeout$1 realCall$timeout$1 = ((RealCall)object).timeout;
            realCall$timeout$1.getClass();
            AsyncTimeout$Companion.access$cancelScheduledTimeout(realCall$timeout$1);
            object = this.codec.getConnection();
            object.getClass();
            Socket socket = ((RealConnection)object).socket;
            Closeable closeable = socket;
            Object object2 = object;
            Intrinsics.checkNotNull(closeable);
            closeable = ((RealConnection)object2).source;
            Intrinsics.checkNotNull(closeable);
            RealBufferedSink realBufferedSink = ((RealConnection)object2).sink;
            Intrinsics.checkNotNull(realBufferedSink);
            socket.setSoTimeout(0);
            synchronized (object) {
                ((RealConnection)object).noNewExchanges = true;
                return new RealConnection$newWebSocketStreams$1((BufferedSource)closeable, realBufferedSink, this);
            }
        }
        throw new IllegalStateException("Check failed.".toString());
    }

    public final void noNewExchangesOnConnection() {
        RealConnection realConnection = ((Exchange)((Object)realConnection)).codec.getConnection();
        synchronized (realConnection) {
            realConnection.noNewExchanges = true;
            return;
        }
    }

    public final void detachWithViolence() {
        Exchange exchange = this;
        exchange.codec.cancel();
        exchange.call.messageDone$okhttp(this, true, true, null);
    }

    public final IOException bodyComplete(boolean bl, boolean bl2, IOException iOException) {
        EventListener eventListener;
        if (iOException != null) {
            this.trackFailure(iOException);
        }
        if (bl2) {
            if (iOException != null) {
                Exchange exchange = this;
                eventListener = exchange.eventListener;
                RealCall realCall = exchange.call;
                eventListener.getClass();
                Intrinsics.checkNotNullParameter(realCall, "call");
            } else {
                Exchange exchange = this;
                eventListener = exchange.eventListener;
                RealCall realCall = exchange.call;
                eventListener.getClass();
                Intrinsics.checkNotNullParameter(realCall, "call");
            }
        }
        if (bl) {
            if (iOException != null) {
                Exchange exchange = this;
                eventListener = exchange.eventListener;
                RealCall realCall = exchange.call;
                eventListener.getClass();
                Intrinsics.checkNotNullParameter(realCall, "call");
            } else {
                Exchange exchange = this;
                eventListener = exchange.eventListener;
                RealCall realCall = exchange.call;
                eventListener.getClass();
                Intrinsics.checkNotNullParameter(realCall, "call");
            }
        }
        return this.call.messageDone$okhttp(this, bl2, bl, iOException);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void trackFailure(IOException object) {
        Exchange exchange = realConnection;
        exchange.hasFailure = true;
        exchange.finder.trackFailure((IOException)object);
        RealConnection realConnection = exchange.codec.getConnection();
        RealCall realCall = exchange.call;
        synchronized (realConnection) {
            Intrinsics.checkNotNullParameter(realCall, "call");
            if (object instanceof StreamResetException) {
                ErrorCode errorCode = ((StreamResetException)object).errorCode;
                if (errorCode == ErrorCode.REFUSED_STREAM) {
                    realConnection.refusedStreamCount = realConnection.refusedStreamCount + 1;
                    if (realConnection.refusedStreamCount <= 1) return;
                    realConnection.noNewExchanges = true;
                    ++realConnection.routeFailureCount;
                    return;
                }
                if (errorCode == ErrorCode.CANCEL && realCall.canceled) {
                    return;
                }
                realConnection.noNewExchanges = true;
                ++realConnection.routeFailureCount;
                return;
            }
            if (realConnection.isMultiplexed$okhttp()) {
                if (!(object instanceof ConnectionShutdownException)) return;
            }
            realConnection.noNewExchanges = true;
            if (realConnection.successCount != 0) return;
            RealConnection.connectFailed$okhttp(realCall.client, realConnection.route, object);
            ++realConnection.routeFailureCount;
            return;
        }
    }
}

