/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.tls;

import com.apollographql.apollo3.relocated.kotlin.collections.EmptyList;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.kotlin.text.Regex;
import com.apollographql.apollo3.relocated.kotlin.text.StringsKt__StringsJVMKt;
import com.apollographql.apollo3.relocated.kotlin.text.StringsKt__StringsKt;
import com.apollographql.apollo3.relocated.okhttp3.internal.HostnamesKt;
import com.apollographql.apollo3.relocated.okhttp3.internal.Util;
import com.apollographql.apollo3.relocated.okio.Utf8;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public final class OkHostnameVerifier
implements HostnameVerifier {
    public static final OkHostnameVerifier INSTANCE = new OkHostnameVerifier();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean verify(String object, X509Certificate iterator2) {
        Intrinsics.checkNotNullParameter(object, "host");
        Regex regex = Util.VERIFY_AS_IP_ADDRESS;
        regex.getClass();
        if (regex.nativePattern.matcher((CharSequence)object).matches()) {
            object = HostnamesKt.toCanonicalHost((String)object);
            if ((iterator2 = OkHostnameVerifier.getSubjectAltNames(iterator2, 7)).isEmpty()) return false;
            iterator2 = iterator2.iterator();
            do {
                if (!iterator2.hasNext()) return false;
            } while (!Intrinsics.areEqual(object, HostnamesKt.toCanonicalHost((String)iterator2.next())));
            return true;
        } else {
            boolean bl;
            if (((String)object).length() == (int)Utf8.size$default((String)object)) {
                Object object2 = object;
                object = Locale.US;
                Intrinsics.checkNotNullExpressionValue(object, "Locale.US");
                object = ((String)object2).toLowerCase((Locale)object);
                Intrinsics.checkNotNullExpressionValue(object, "(this as java.lang.String).toLowerCase(locale)");
            }
            if ((iterator2 = OkHostnameVerifier.getSubjectAltNames((X509Certificate)((Object)iterator2), 2)).isEmpty()) return false;
            iterator2 = iterator2.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object object3 = (String)iterator2.next();
                if (!(((String)object).length() == 0 || StringsKt__StringsJVMKt.startsWith((String)object, ".", false) || StringsKt__StringsJVMKt.endsWith((String)object, "..", false))) {
                    if (!(object3 == null || ((String)object3).length() == 0 || StringsKt__StringsJVMKt.startsWith((String)object3, ".", false) || StringsKt__StringsJVMKt.endsWith((String)object3, "..", false))) {
                        Object object4 = !StringsKt__StringsJVMKt.endsWith((String)object, ".", false) ? ((String)object).concat(".") : object;
                        if (!StringsKt__StringsJVMKt.endsWith((String)object3, ".", false)) {
                            object3 = ((String)object3).concat(".");
                        }
                        if (((String)object3).length() == (int)Utf8.size$default((String)object3)) {
                            String string = object3;
                            object3 = Locale.US;
                            Intrinsics.checkNotNullExpressionValue(object3, "Locale.US");
                            object3 = string.toLowerCase((Locale)object3);
                            Intrinsics.checkNotNullExpressionValue(object3, "(this as java.lang.String).toLowerCase(locale)");
                        }
                        if (!StringsKt__StringsKt.contains$default((CharSequence)object3, "*")) {
                            bl = Intrinsics.areEqual(object4, object3);
                            continue;
                        }
                        if (StringsKt__StringsJVMKt.startsWith((String)object3, "*.", false) && StringsKt__StringsKt.indexOf$default((CharSequence)object3, '*', 1, false, 4) == -1 && ((String)object4).length() >= ((String)object3).length() && !Intrinsics.areEqual("*.", object3)) {
                            object3 = ((String)object3).substring(1);
                            Intrinsics.checkNotNullExpressionValue(object3, "(this as java.lang.String).substring(startIndex)");
                            if (StringsKt__StringsJVMKt.endsWith((String)object4, (String)object3, false)) {
                                int n = ((String)object4).length() - ((String)object3).length();
                                if (n <= 0) return true;
                                if (StringsKt__StringsKt.lastIndexOf$default((CharSequence)object4, '.', n - 1, 4) == -1) return true;
                            }
                        }
                    }
                }
                bl = false;
            } while (!bl);
        }
        return true;
    }

    public static List getSubjectAltNames(X509Certificate object, int n) {
        block12: {
            ArrayList arrayList;
            object = ((X509Certificate)object).getSubjectAlternativeNames();
            if (object == null) break block12;
            Object object2 = object;
            object = arrayList;
            arrayList = new ArrayList();
            Iterator iterator2 = object2.iterator();
            while (true) {
                if (!iterator2.hasNext()) break;
                List list = (List)iterator2.next();
                if (list == null) continue;
                if (list.size() < 2) continue;
                if (Intrinsics.areEqual(list.get(0), n) ^ true) continue;
                if ((list = list.get(1)) == null) continue;
                ((ArrayList)object).add((String)((Object)list));
            }
            return object;
        }
        try {
            return EmptyList.INSTANCE;
        }
        catch (CertificateParsingException certificateParsingException) {
            return EmptyList.INSTANCE;
        }
    }

    @Override
    public final boolean verify(String string, SSLSession sSLSession) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter(string, "host");
            Intrinsics.checkNotNullParameter(sSLSession, "session");
            boolean bl2 = string.length() == (int)Utf8.size$default(string);
            if (bl2) {
                block5: {
                    Certificate certificate;
                    try {
                        certificate = sSLSession.getPeerCertificates()[0];
                        if (certificate == null) break block5;
                    }
                    catch (SSLException sSLException) {}
                    bl = OkHostnameVerifier.verify(string, (X509Certificate)certificate);
                    break block6;
                }
                throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            bl = false;
        }
        return bl;
    }
}

