/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.platform.android;

import android.net.http.X509TrustManagerExtensions;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.internal.tls.CertificateChainCleaner;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.X509TrustManager;

public final class AndroidCertificateChainCleaner
extends CertificateChainCleaner {
    public final X509TrustManager trustManager;
    public final X509TrustManagerExtensions x509TrustManagerExtensions;

    public AndroidCertificateChainCleaner(X509TrustManager x509TrustManager, X509TrustManagerExtensions x509TrustManagerExtensions) {
        this.trustManager = x509TrustManager;
        this.x509TrustManagerExtensions = x509TrustManagerExtensions;
    }

    @Override
    public final List clean(String string, List x509CertificateArray) {
        Intrinsics.checkNotNullParameter(x509CertificateArray, "chain");
        Intrinsics.checkNotNullParameter(string, "hostname");
        x509CertificateArray = x509CertificateArray.toArray(new X509Certificate[0]);
        if (x509CertificateArray != null) {
            X509Certificate[] x509CertificateArray2 = x509CertificateArray3;
            X509Certificate[] x509CertificateArray3 = x509CertificateArray;
            try {
                List list = x509CertificateArray2.x509TrustManagerExtensions.checkServerTrusted(x509CertificateArray3, "RSA", string);
                Intrinsics.checkNotNullExpressionValue(list, "x509TrustManagerExtensio\u2026ficates, \"RSA\", hostname)");
                return list;
            }
            catch (CertificateException certificateException) {
                SSLPeerUnverifiedException sSLPeerUnverifiedException = new SSLPeerUnverifiedException(certificateException.getMessage());
                sSLPeerUnverifiedException.initCause(certificateException);
                throw sSLPeerUnverifiedException;
            }
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
    }

    public final boolean equals(Object object) {
        return object instanceof AndroidCertificateChainCleaner && ((AndroidCertificateChainCleaner)object).trustManager == this.trustManager;
    }

    public final int hashCode() {
        return System.identityHashCode(this.trustManager);
    }
}

