/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import com.apollographql.apollo3.relocated.kotlin.collections.ArraysKt___ArraysKt;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.kotlin.text.Regex;
import java.util.regex.Pattern;
import kotlin.Metadata;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0010\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\u001a\u0011\u0010\u0001\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0001\u0010\u0002\u001a\u0011\u0010\u0003\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0002\u001a\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0000*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0002\u001a\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0002\u001a\u0011\u0010\u0006\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0002\u001a\u0011\u0010\u0007\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\u0002\"\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"", "escapeJavaReservedWord", "(Ljava/lang/String;)Ljava/lang/String;", "escapeKotlinReservedWord", "escapeTypeReservedWord", "escapeCompanionReservedWord", "escapeKotlinReservedWordInEnum", "escapeKotlinReservedWordInSealedClass", "", "JAVA_RESERVED_WORDS", "[Ljava/lang/String;", "apollo-compiler"})
public final class ReservedKeywordsKt {
    private static final String[] JAVA_RESERVED_WORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "true", "void", "volatile", "while"};
    private static final Regex TYPE_REGEX;
    private static final Regex COMPANION_REGEX;
    private static final Regex KOTLIN_ENUM_RESERVED_WORDS_REGEX;

    public static final String escapeJavaReservedWord(String string) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        if (ArraysKt___ArraysKt.contains(JAVA_RESERVED_WORDS, string)) {
            string = string.concat("_");
        }
        return string;
    }

    public static final String escapeKotlinReservedWord(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "<this>");
        return string2;
    }

    public static final String escapeTypeReservedWord(String string) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Regex regex = TYPE_REGEX;
        regex.getClass();
        return regex.nativePattern.matcher(string).matches() ? string.concat("_") : null;
    }

    private static final String escapeCompanionReservedWord(String string) {
        return COMPANION_REGEX.matches(string) ? string + '_' : null;
    }

    public static final String escapeKotlinReservedWordInEnum(String string) {
        String string2;
        Intrinsics.checkNotNullParameter(string, "<this>");
        Regex regex = KOTLIN_ENUM_RESERVED_WORDS_REGEX;
        regex.getClass();
        string = regex.nativePattern.matcher(string).matches() ? string.concat("_") : ((string2 = ReservedKeywordsKt.escapeTypeReservedWord(string)) == null && (string2 = ReservedKeywordsKt.escapeCompanionReservedWord(string)) == null ? ReservedKeywordsKt.escapeKotlinReservedWord(string) : string2);
        return string;
    }

    public static final String escapeKotlinReservedWordInSealedClass(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "<this>");
        String string3 = ReservedKeywordsKt.escapeTypeReservedWord(string2);
        if (string3 == null && (string3 = ReservedKeywordsKt.escapeCompanionReservedWord(string)) == null) {
            string3 = ReservedKeywordsKt.escapeKotlinReservedWord(string);
        }
        return string3;
    }

    static {
        Pattern pattern = Pattern.compile("(?:type)_*");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        TYPE_REGEX = new Regex(pattern);
        Pattern pattern2 = Pattern.compile("(?:Companion)_*");
        Intrinsics.checkNotNullExpressionValue(pattern2, "compile(...)");
        COMPANION_REGEX = new Regex(pattern2);
        Pattern pattern3 = Pattern.compile("(?:name|ordinal)_*");
        Intrinsics.checkNotNullExpressionValue(pattern3, "compile(...)");
        KOTLIN_ENUM_RESERVED_WORDS_REGEX = new Regex(pattern3);
    }
}

