/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.http2;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Header;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Hpack;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Reader$ContinuationSource;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Huffman;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Huffman$Node;
import com.apollographql.apollo3.relocated.okio.Buffer;
import com.apollographql.apollo3.relocated.okio.ByteString;
import com.apollographql.apollo3.relocated.okio.Okio;
import com.apollographql.apollo3.relocated.okio.RealBufferedSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Hpack$Reader {
    public final List headerList;
    public final RealBufferedSource source;
    public Header[] dynamicTable;
    public int nextHeaderIndex;
    public int headerCount;
    public int dynamicTableByteCount;
    public final int headerTableSizeSetting;
    public int maxDynamicTableByteCount;

    public Hpack$Reader(Http2Reader$ContinuationSource http2Reader$ContinuationSource, int n) {
        Hpack$Reader hpack$Reader = this;
        Hpack$Reader hpack$Reader2 = this;
        this.headerTableSizeSetting = 4096;
        hpack$Reader2.maxDynamicTableByteCount = n;
        hpack$Reader2.headerList = new ArrayList();
        hpack$Reader.source = Okio.buffer(http2Reader$ContinuationSource);
        hpack$Reader.dynamicTable = new Header[8];
        hpack$Reader.nextHeaderIndex = 7;
    }

    public /* synthetic */ Hpack$Reader(Http2Reader$ContinuationSource continuationSource) {
        this(continuationSource, 4096);
    }

    public final int readInt(int n, int n2) {
        int n3;
        if ((n &= n2) < n2) {
            return n;
        }
        n = 0;
        while (true) {
            n3 = this.source.readByte() & 0xFF;
            if ((n3 & 0x80) == 0) break;
            n2 += (n3 & 0x7F) << n;
            n += 7;
        }
        return n2 + (n3 << n);
    }

    public final ByteString readByteString() {
        ByteString byteString;
        int n = ((Hpack$Reader)((Object)buffer2)).source.readByte() & 0xFF;
        boolean bl = (n & 0x80) == 128;
        long l = ((Hpack$Reader)((Object)buffer2)).readInt(n, 127);
        if (bl) {
            Buffer buffer;
            Hpack$Reader hpack$Reader = buffer2;
            Buffer buffer2 = buffer;
            buffer = new Buffer();
            RealBufferedSource realBufferedSource = hpack$Reader.source;
            Intrinsics.checkNotNullParameter(realBufferedSource, "source");
            Huffman$Node huffman$Node = Huffman.root;
            int n2 = 0;
            int n3 = 0;
            for (long i = 0L; i < l; ++i) {
                int n4 = n2;
                n2 = realBufferedSource.readByte() & 0xFF;
                n2 = n4 << 8 | n2;
                n3 += 8;
                while (n3 >= 8) {
                    int n5 = n3 - 8;
                    int n6 = n2 >>> n5 & 0xFF;
                    Intrinsics.checkNotNull(huffman$Node.children);
                    Huffman$Node huffman$Node2 = huffman$Node.children[n6];
                    Intrinsics.checkNotNull(huffman$Node2);
                    if (huffman$Node2.children == null) {
                        buffer2.writeByte(huffman$Node2.symbol);
                        n5 = n3 - huffman$Node2.terminalBitCount;
                        huffman$Node2 = Huffman.root;
                    }
                    huffman$Node = huffman$Node2;
                    n3 = n5;
                }
            }
            while (n3 > 0) {
                int n7 = n2 << 8 - n3 & 0xFF;
                Intrinsics.checkNotNull(huffman$Node.children);
                Huffman$Node huffman$Node3 = huffman$Node.children[n7];
                Intrinsics.checkNotNull(huffman$Node3);
                if (huffman$Node3.children != null || huffman$Node3.terminalBitCount > n3) break;
                buffer2.writeByte(huffman$Node3.symbol);
                n3 -= huffman$Node3.terminalBitCount;
                huffman$Node = Huffman.root;
            }
            Object object = buffer2;
            byteString = ((Buffer)object).readByteString(((Buffer)object).size);
        } else {
            byteString = ((Hpack$Reader)((Object)buffer2)).source.readByteString(l);
        }
        return byteString;
    }

    public final int evictToRecoverBytes(int n) {
        int n2 = 0;
        if (n > 0) {
            int n3;
            int n4;
            for (n4 = this.dynamicTable.length - 1; n4 >= (n3 = this.nextHeaderIndex) && n > 0; --n4) {
                Hpack$Reader hpack$Reader = this;
                int n5 = n;
                Header header = this.dynamicTable[n4];
                Intrinsics.checkNotNull(header);
                n = header.hpackSize;
                n3 = n5 - n;
                hpack$Reader.dynamicTableByteCount -= n;
                hpack$Reader.headerCount += -1;
                n = n2 + 1;
                n2 = n;
                n = n3;
            }
            Hpack$Reader hpack$Reader = this;
            int n6 = n3;
            int n7 = n6 + 1;
            n = n6 + 1 + n2;
            n4 = this.headerCount;
            System.arraycopy(hpack$Reader.dynamicTable, n7, hpack$Reader.dynamicTable, n, n4);
            hpack$Reader.nextHeaderIndex += n2;
        }
        return n2;
    }

    public final ByteString getName(int n) {
        block4: {
            ByteString byteString;
            block3: {
                int n2;
                block2: {
                    n2 = n >= 0 && n <= Hpack.STATIC_HEADER_TABLE.length - 1 ? 1 : 0;
                    if (n2 == 0) break block2;
                    byteString = Hpack.STATIC_HEADER_TABLE[n].name;
                    break block3;
                }
                n2 = n - Hpack.STATIC_HEADER_TABLE.length;
                if ((n2 = headerArray.nextHeaderIndex + 1 + n2) < 0) break block4;
                Header[] headerArray = headerArray.dynamicTable;
                if (n2 >= headerArray.dynamicTable.length) break block4;
                Header header = headerArray[n2];
                Intrinsics.checkNotNull(header);
                byteString = header.name;
            }
            return byteString;
        }
        throw new IOException("Header index too large " + (n + 1));
    }

    public final void insertIntoDynamicTable(Header header) {
        ((ArrayList)this.headerList).add(header);
        int n = header.hpackSize;
        int n2 = this.maxDynamicTableByteCount;
        if (n > n2) {
            Hpack$Reader hpack$Reader = this;
            Arrays.fill(hpack$Reader.dynamicTable, 0, hpack$Reader.dynamicTable.length, null);
            hpack$Reader.nextHeaderIndex = hpack$Reader.dynamicTable.length - 1;
            hpack$Reader.headerCount = 0;
            hpack$Reader.dynamicTableByteCount = 0;
            return;
        }
        Hpack$Reader hpack$Reader = this;
        hpack$Reader.evictToRecoverBytes(hpack$Reader.dynamicTableByteCount + n - n2);
        Header[] headerArray = this.dynamicTable;
        if (hpack$Reader.headerCount + 1 > this.dynamicTable.length) {
            Header[] headerArray2 = headerArray;
            headerArray = new Header[headerArray.length * 2];
            int n3 = headerArray2.length;
            int n4 = headerArray.length;
            System.arraycopy(headerArray2, 0, headerArray, n3, n4);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.dynamicTable = headerArray;
        }
        Hpack$Reader hpack$Reader2 = this;
        int n5 = hpack$Reader2.nextHeaderIndex;
        hpack$Reader2.nextHeaderIndex = n5 + -1;
        hpack$Reader2.dynamicTable[n5] = header;
        ++hpack$Reader2.headerCount;
        hpack$Reader2.dynamicTableByteCount += n;
    }
}

