/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler.unified.ir;

import com.apollographql.apollo3.api.BooleanExpression;
import com.apollographql.apollo3.compiler.frontend.GQLArgument;
import com.apollographql.apollo3.compiler.frontend.GQLArguments;
import com.apollographql.apollo3.compiler.frontend.GQLBooleanValue;
import com.apollographql.apollo3.compiler.frontend.GQLDirective;
import com.apollographql.apollo3.compiler.frontend.GQLEnumValue;
import com.apollographql.apollo3.compiler.frontend.GQLFloatValue;
import com.apollographql.apollo3.compiler.frontend.GQLIntValue;
import com.apollographql.apollo3.compiler.frontend.GQLListValue;
import com.apollographql.apollo3.compiler.frontend.GQLNullValue;
import com.apollographql.apollo3.compiler.frontend.GQLObjectField;
import com.apollographql.apollo3.compiler.frontend.GQLObjectValue;
import com.apollographql.apollo3.compiler.frontend.GQLStringValue;
import com.apollographql.apollo3.compiler.frontend.GQLValue;
import com.apollographql.apollo3.compiler.frontend.GQLVariableValue;
import com.apollographql.apollo3.compiler.frontend.GqldocumentKt;
import com.apollographql.apollo3.compiler.unified.ir.IrBooleanValue;
import com.apollographql.apollo3.compiler.unified.ir.IrEnumValue;
import com.apollographql.apollo3.compiler.unified.ir.IrFloatValue;
import com.apollographql.apollo3.compiler.unified.ir.IrIntValue;
import com.apollographql.apollo3.compiler.unified.ir.IrListValue;
import com.apollographql.apollo3.compiler.unified.ir.IrNullValue;
import com.apollographql.apollo3.compiler.unified.ir.IrObjectValue;
import com.apollographql.apollo3.compiler.unified.ir.IrStringValue;
import com.apollographql.apollo3.compiler.unified.ir.IrValue;
import com.apollographql.apollo3.compiler.unified.ir.IrVariableValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0000\u00a8\u0006\u0007"}, d2={"toBooleanExpression", "Lcom/apollographql/apollo3/api/BooleanExpression;", "Lcom/apollographql/apollo3/compiler/frontend/GQLDirective;", "", "toIr", "Lcom/apollographql/apollo3/compiler/unified/ir/IrValue;", "Lcom/apollographql/apollo3/compiler/frontend/GQLValue;", "apollo-compiler"})
public final class IrBuilderKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrValue toIr(@NotNull GQLValue $this$toIr) {
        IrValue irValue;
        Intrinsics.checkParameterIsNotNull((Object)$this$toIr, (String)"$this$toIr");
        GQLValue gQLValue = $this$toIr;
        if (gQLValue instanceof GQLIntValue) {
            irValue = new IrIntValue(((GQLIntValue)$this$toIr).getValue());
        } else if (gQLValue instanceof GQLStringValue) {
            irValue = new IrStringValue(((GQLStringValue)$this$toIr).getValue());
        } else if (gQLValue instanceof GQLFloatValue) {
            irValue = new IrFloatValue(((GQLFloatValue)$this$toIr).getValue());
        } else if (gQLValue instanceof GQLBooleanValue) {
            irValue = new IrBooleanValue(((GQLBooleanValue)$this$toIr).getValue());
        } else if (gQLValue instanceof GQLEnumValue) {
            irValue = new IrEnumValue(((GQLEnumValue)$this$toIr).getValue());
        } else if (gQLValue instanceof GQLNullValue) {
            irValue = IrNullValue.INSTANCE;
        } else if (gQLValue instanceof GQLVariableValue) {
            irValue = new IrVariableValue(((GQLVariableValue)$this$toIr).getName());
        } else if (gQLValue instanceof GQLListValue) {
            Collection<IrValue> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((GQLListValue)$this$toIr).getValues();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GQLValue gQLValue2 = (GQLValue)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                IrValue irValue2 = IrBuilderKt.toIr((GQLValue)it);
                collection.add(irValue2);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            irValue = new IrListValue(list);
        } else if (gQLValue instanceof GQLObjectValue) {
            Collection<IrObjectValue.Field> collection;
            Iterable $this$map$iv = ((GQLObjectValue)$this$toIr).getFields();
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                GQLObjectField it = (GQLObjectField)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                IrObjectValue.Field field = new IrObjectValue.Field(it.getName(), IrBuilderKt.toIr(it.getValue()));
                collection.add(field);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            irValue = new IrObjectValue(list);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irValue;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BooleanExpression toBooleanExpression(@NotNull List<GQLDirective> $this$toBooleanExpression) {
        BooleanExpression booleanExpression;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$toBooleanExpression, (String)"$this$toBooleanExpression");
        Iterable $this$mapNotNull$iv = $this$toBooleanExpression;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BooleanExpression booleanExpression2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GQLDirective it = (GQLDirective)element$iv$iv;
            boolean bl2 = false;
            if (IrBuilderKt.toBooleanExpression(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            BooleanExpression it$iv$iv = booleanExpression2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List conditions = (List)destination$iv$iv;
        if (conditions.isEmpty()) {
            booleanExpression = BooleanExpression.True.INSTANCE;
        } else {
            boolean bl = CollectionsKt.toSet((Iterable)conditions).size() == conditions.size();
            boolean bl6 = false;
            boolean bl7 = false;
            if (!bl) {
                boolean bl8 = false;
                String string = "ApolloGraphQL: duplicate @skip/@include directives are not allowed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            booleanExpression = new BooleanExpression.And(CollectionsKt.toSet((Iterable)conditions)).simplify();
        }
        return booleanExpression;
    }

    @Nullable
    public static final BooleanExpression toBooleanExpression(@NotNull GQLDirective $this$toBooleanExpression) {
        BooleanExpression booleanExpression;
        Intrinsics.checkParameterIsNotNull((Object)$this$toBooleanExpression, (String)"$this$toBooleanExpression");
        if (!SetsKt.setOf((Object[])new String[]{"skip", "include"}).contains($this$toBooleanExpression.getName())) {
            return null;
        }
        Object object = $this$toBooleanExpression.getArguments();
        if (object == null || (object = ((GQLArguments)object).getArguments()) == null || object.size() != 1) {
            Object object2;
            throw (Throwable)new IllegalStateException("ApolloGraphQL: wrong number of arguments for '" + $this$toBooleanExpression.getName() + "' directive: " + ((object2 = $this$toBooleanExpression.getArguments()) != null && (object2 = ((GQLArguments)object2).getArguments()) != null ? Integer.valueOf(object2.size()) : null));
        }
        GQLArgument argument = (GQLArgument)CollectionsKt.first($this$toBooleanExpression.getArguments().getArguments());
        GQLValue value = argument.getValue();
        if (value instanceof GQLBooleanValue) {
            booleanExpression = ((GQLBooleanValue)value).getValue() ? (BooleanExpression)BooleanExpression.True.INSTANCE : (BooleanExpression)BooleanExpression.False.INSTANCE;
        } else if (value instanceof GQLVariableValue) {
            BooleanExpression.Variable variable = new BooleanExpression.Variable(((GQLVariableValue)value).getName());
            boolean bl = false;
            boolean bl2 = false;
            BooleanExpression.Variable it = variable;
            boolean bl3 = false;
            booleanExpression = Intrinsics.areEqual((Object)$this$toBooleanExpression.getName(), (Object)"skip") ? (BooleanExpression)it.not() : (BooleanExpression)it;
        } else {
            throw (Throwable)new IllegalStateException("ApolloGraphQL: cannot pass " + GqldocumentKt.toUtf8(value) + " to '" + $this$toBooleanExpression.getName() + "' directive");
        }
        return booleanExpression;
    }
}

