/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.LinkedHashTreeMap;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class MapJsonAdapter<K, V>
extends JsonAdapter<Map<K, V>> {
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        @Override
        @Nullable
        public JsonAdapter<?> create(Type type2, Set<? extends Annotation> annotations2, Moshi moshi) {
            if (!annotations2.isEmpty()) {
                return null;
            }
            Class<?> rawType = Types.getRawType(type2);
            if (rawType != Map.class) {
                return null;
            }
            Type[] keyAndValue = Types.mapKeyAndValueTypes(type2, rawType);
            return new MapJsonAdapter(moshi, keyAndValue[0], keyAndValue[1]).nullSafe();
        }
    };
    private final JsonAdapter<K> keyAdapter;
    private final JsonAdapter<V> valueAdapter;

    MapJsonAdapter(Moshi moshi, Type keyType, Type valueType) {
        this.keyAdapter = moshi.adapter(keyType);
        this.valueAdapter = moshi.adapter(valueType);
    }

    @Override
    public void toJson(JsonWriter writer, Map<K, V> map2) throws IOException {
        writer.beginObject();
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            if (entry.getKey() == null) {
                throw new JsonDataException("Map key is null at " + writer.getPath());
            }
            writer.promoteValueToName();
            this.keyAdapter.toJson(writer, entry.getKey());
            this.valueAdapter.toJson(writer, entry.getValue());
        }
        writer.endObject();
    }

    @Override
    public Map<K, V> fromJson(JsonReader reader) throws IOException {
        LinkedHashTreeMap<K, V> result2 = new LinkedHashTreeMap<K, V>();
        reader.beginObject();
        while (reader.hasNext()) {
            V value;
            reader.promoteNameToValue();
            K name = this.keyAdapter.fromJson(reader);
            Object replaced = result2.put(name, value = this.valueAdapter.fromJson(reader));
            if (replaced == null) continue;
            throw new JsonDataException("Map key '" + name + "' has multiple values at path " + reader.getPath() + ": " + replaced + " and " + value);
        }
        reader.endObject();
        return result2;
    }

    public String toString() {
        return "JsonAdapter(" + this.keyAdapter + "=" + this.valueAdapter + ")";
    }
}

