/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler.frontend;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/apollographql/apollo3/compiler/frontend/GraphQLString;", "", "()V", "decodeSingleQuoted", "", "string", "decodeTripleQuoted", "encodeSingleQuoted", "encodeTripleQuoted", "apollo-compiler"})
public final class GraphQLString {
    @NotNull
    public static final GraphQLString INSTANCE;

    @NotNull
    public final String decodeSingleQuoted(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "string");
        StringBuilder writer = new StringBuilder(string.length());
        int i = 0;
        block11: while (i < string.length()) {
            char c = string.charAt(i);
            ++i;
            if (c != '\\') {
                writer.append(c);
                continue;
            }
            char escaped = string.charAt(i);
            switch (escaped) {
                case '\"': {
                    writer.append('\"');
                    ++i;
                    continue block11;
                }
                case '/': {
                    writer.append('/');
                    ++i;
                    continue block11;
                }
                case '\\': {
                    writer.append('\\');
                    ++i;
                    continue block11;
                }
                case 'b': {
                    writer.append('\b');
                    ++i;
                    continue block11;
                }
                case 'f': {
                    writer.append(12);
                    ++i;
                    continue block11;
                }
                case 'n': {
                    writer.append(10);
                    ++i;
                    continue block11;
                }
                case 'r': {
                    writer.append('\r');
                    ++i;
                    continue block11;
                }
                case 't': {
                    writer.append('\t');
                    ++i;
                    continue block11;
                }
                case 'u': {
                    String string2 = string;
                    int n = i + 1;
                    int n2 = i + 5;
                    boolean bl = false;
                    String string3 = string2.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string2 = string3;
                    n = 16;
                    n2 = 0;
                    int codepoint = Integer.parseInt(string2, CharsKt.checkRadix(n));
                    writer.appendCodePoint(codepoint);
                    i += 5;
                    continue block11;
                }
            }
            throw (Throwable)new IllegalStateException("Bad escaped character: " + c);
        }
        String string4 = writer.toString();
        Intrinsics.checkExpressionValueIsNotNull(string4, "writer.toString()");
        return string4;
    }

    @NotNull
    public final String decodeTripleQuoted(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "string");
        return StringsKt.trimIndent(StringsKt.replace$default(string, "\\\"\"\"", "\"\"\"", false, 4, null));
    }

    @NotNull
    public final String encodeSingleQuoted(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "string");
        return StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(string, "\\", "\\\\", false, 4, null), "\"", "\\\"", false, 4, null), "\n", "\\n", false, 4, null);
    }

    @NotNull
    public final String encodeTripleQuoted(@NotNull String string) {
        String string2;
        Intrinsics.checkParameterIsNotNull(string, "string");
        String string3 = StringsKt.replace$default(string, "\"\"\"", "\\\"\"\"", false, 4, null);
        boolean bl = false;
        boolean bl2 = false;
        String it = string3;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        if (charSequence.length() == 0) {
            string2 = it;
        } else {
            String leading = it.charAt(0) != '\n' ? "\n" : "";
            String trailing = it.charAt(it.length() - 1) != '\n' ? "\n" : "";
            string2 = leading + it + trailing;
        }
        return string2;
    }

    private GraphQLString() {
    }

    static {
        GraphQLString graphQLString;
        INSTANCE = graphQLString = new GraphQLString();
    }
}

