/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler.ir;

import com.apollographql.apollo3.api.BVariable;
import com.apollographql.apollo3.api.BooleanExpression;
import com.apollographql.apollo3.api.BooleanExpressions;
import com.apollographql.apollo3.ast.GQLArgument;
import com.apollographql.apollo3.ast.GQLArguments;
import com.apollographql.apollo3.ast.GQLBooleanValue;
import com.apollographql.apollo3.ast.GQLDirective;
import com.apollographql.apollo3.ast.GQLEnumValue;
import com.apollographql.apollo3.ast.GQLFloatValue;
import com.apollographql.apollo3.ast.GQLIntValue;
import com.apollographql.apollo3.ast.GQLListValue;
import com.apollographql.apollo3.ast.GQLNullValue;
import com.apollographql.apollo3.ast.GQLObjectField;
import com.apollographql.apollo3.ast.GQLObjectValue;
import com.apollographql.apollo3.ast.GQLStringValue;
import com.apollographql.apollo3.ast.GQLValue;
import com.apollographql.apollo3.ast.GQLVariableValue;
import com.apollographql.apollo3.ast.GqlnodeKt;
import com.apollographql.apollo3.compiler.ir.IrBooleanValue;
import com.apollographql.apollo3.compiler.ir.IrEnumValue;
import com.apollographql.apollo3.compiler.ir.IrFieldInfo;
import com.apollographql.apollo3.compiler.ir.IrFloatValue;
import com.apollographql.apollo3.compiler.ir.IrIntValue;
import com.apollographql.apollo3.compiler.ir.IrKt;
import com.apollographql.apollo3.compiler.ir.IrListType;
import com.apollographql.apollo3.compiler.ir.IrListValue;
import com.apollographql.apollo3.compiler.ir.IrModelType;
import com.apollographql.apollo3.compiler.ir.IrNonNullType;
import com.apollographql.apollo3.compiler.ir.IrNullValue;
import com.apollographql.apollo3.compiler.ir.IrObjectValue;
import com.apollographql.apollo3.compiler.ir.IrStringValue;
import com.apollographql.apollo3.compiler.ir.IrType;
import com.apollographql.apollo3.compiler.ir.IrValue;
import com.apollographql.apollo3.compiler.ir.IrVariableValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t*\u00020\u000bH\u0000\u001a\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\b\u0012\u0004\u0012\u00020\u000b0\fH\u0000\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0000\u00a8\u0006\u0010"}, d2={"maybeNullable", "Lcom/apollographql/apollo3/compiler/ir/IrFieldInfo;", "makeNullable", "", "replacePlaceholder", "Lcom/apollographql/apollo3/compiler/ir/IrType;", "newPath", "", "toBooleanExpression", "Lcom/apollographql/apollo3/api/BooleanExpression;", "Lcom/apollographql/apollo3/api/BVariable;", "Lcom/apollographql/apollo3/ast/GQLDirective;", "", "toIrValue", "Lcom/apollographql/apollo3/compiler/ir/IrValue;", "Lcom/apollographql/apollo3/ast/GQLValue;", "apollo-compiler"})
public final class IrBuilderKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrValue toIrValue(@NotNull GQLValue $this$toIrValue) {
        IrValue irValue;
        Intrinsics.checkParameterIsNotNull((Object)$this$toIrValue, (String)"<this>");
        GQLValue gQLValue = $this$toIrValue;
        if (gQLValue instanceof GQLIntValue) {
            irValue = new IrIntValue(((GQLIntValue)$this$toIrValue).getValue());
        } else if (gQLValue instanceof GQLStringValue) {
            irValue = new IrStringValue(((GQLStringValue)$this$toIrValue).getValue());
        } else if (gQLValue instanceof GQLFloatValue) {
            irValue = new IrFloatValue(((GQLFloatValue)$this$toIrValue).getValue());
        } else if (gQLValue instanceof GQLBooleanValue) {
            irValue = new IrBooleanValue(((GQLBooleanValue)$this$toIrValue).getValue());
        } else if (gQLValue instanceof GQLEnumValue) {
            irValue = new IrEnumValue(((GQLEnumValue)$this$toIrValue).getValue());
        } else if (gQLValue instanceof GQLNullValue) {
            irValue = IrNullValue.INSTANCE;
        } else if (gQLValue instanceof GQLVariableValue) {
            irValue = new IrVariableValue(((GQLVariableValue)$this$toIrValue).getName());
        } else if (gQLValue instanceof GQLListValue) {
            Collection<IrValue> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((GQLListValue)$this$toIrValue).getValues();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GQLValue gQLValue2 = (GQLValue)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                IrValue irValue2 = IrBuilderKt.toIrValue((GQLValue)it);
                collection.add(irValue2);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            irValue = new IrListValue(list);
        } else if (gQLValue instanceof GQLObjectValue) {
            Collection<IrObjectValue.Field> collection;
            Iterable $this$map$iv = ((GQLObjectValue)$this$toIrValue).getFields();
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                GQLObjectField it = (GQLObjectField)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                IrObjectValue.Field field = new IrObjectValue.Field(it.getName(), IrBuilderKt.toIrValue(it.getValue()));
                collection.add(field);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            irValue = new IrObjectValue(list);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irValue;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BooleanExpression<BVariable> toBooleanExpression(@NotNull List<GQLDirective> $this$toBooleanExpression) {
        BooleanExpression booleanExpression;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$toBooleanExpression, (String)"<this>");
        Iterable $this$mapNotNull$iv = $this$toBooleanExpression;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BooleanExpression<BVariable> booleanExpression2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GQLDirective it = (GQLDirective)element$iv$iv;
            boolean bl2 = false;
            if (IrBuilderKt.toBooleanExpression(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            BooleanExpression<BVariable> it$iv$iv = booleanExpression2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List conditions = (List)destination$iv$iv;
        if (conditions.isEmpty()) {
            booleanExpression = BooleanExpression.True.INSTANCE;
        } else {
            boolean bl = CollectionsKt.toSet((Iterable)conditions).size() == conditions.size();
            boolean bl6 = false;
            boolean bl7 = false;
            if (!bl) {
                boolean bl8 = false;
                String string = "ApolloGraphQL: duplicate @skip/@include directives are not allowed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            booleanExpression = new BooleanExpression.And(CollectionsKt.toSet((Iterable)conditions)).simplify();
        }
        return booleanExpression;
    }

    @Nullable
    public static final BooleanExpression<BVariable> toBooleanExpression(@NotNull GQLDirective $this$toBooleanExpression) {
        BooleanExpression booleanExpression;
        GQLArgument argument;
        GQLValue value;
        List<GQLArgument> list;
        Intrinsics.checkParameterIsNotNull((Object)$this$toBooleanExpression, (String)"<this>");
        Object object = new String[]{"skip", "include"};
        if (!SetsKt.setOf((Object[])object).contains($this$toBooleanExpression.getName())) {
            return null;
        }
        object = $this$toBooleanExpression.getArguments();
        if (!(object == null ? false : ((list = ((GQLArguments)object).getArguments()) == null ? false : list.size() == 1))) {
            throw new IllegalStateException("ApolloGraphQL: wrong number of arguments for '" + $this$toBooleanExpression.getName() + "' directive: " + ((object = $this$toBooleanExpression.getArguments()) == null ? null : ((list = ((GQLArguments)object).getArguments()) == null ? null : Integer.valueOf(list.size()))));
        }
        GQLArguments gQLArguments = $this$toBooleanExpression.getArguments();
        if (gQLArguments == null) {
            Intrinsics.throwNpe();
        }
        if ((value = (argument = (GQLArgument)CollectionsKt.first(gQLArguments.getArguments())).getValue()) instanceof GQLBooleanValue) {
            booleanExpression = ((GQLBooleanValue)value).getValue() ? (BooleanExpression)BooleanExpression.True.INSTANCE : (BooleanExpression)BooleanExpression.False.INSTANCE;
        } else if (value instanceof GQLVariableValue) {
            BooleanExpression.Element<BVariable> element = new BooleanExpression.Element<BVariable>(new BVariable(((GQLVariableValue)value).getName()));
            boolean bl = false;
            boolean bl2 = false;
            BooleanExpression.Element<BVariable> it = element;
            boolean bl3 = false;
            booleanExpression = Intrinsics.areEqual((Object)$this$toBooleanExpression.getName(), (Object)"skip") ? BooleanExpressions.not((BooleanExpression)it) : (BooleanExpression)it;
        } else {
            throw new IllegalStateException("ApolloGraphQL: cannot pass " + GqlnodeKt.toUtf8$default(value, null, 1, null) + " to '" + $this$toBooleanExpression.getName() + "' directive");
        }
        return booleanExpression;
    }

    @NotNull
    public static final IrFieldInfo maybeNullable(@NotNull IrFieldInfo $this$maybeNullable, boolean makeNullable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$maybeNullable, (String)"<this>");
        if (!makeNullable) {
            return $this$maybeNullable;
        }
        return IrFieldInfo.copy$default($this$maybeNullable, null, null, IrKt.makeNullable($this$maybeNullable.getType()), null, null, 27, null);
    }

    @NotNull
    public static final IrType replacePlaceholder(@NotNull IrType $this$replacePlaceholder, @NotNull String newPath) {
        IrType irType;
        Intrinsics.checkParameterIsNotNull((Object)$this$replacePlaceholder, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)newPath, (String)"newPath");
        IrType irType2 = $this$replacePlaceholder;
        if (irType2 instanceof IrNonNullType) {
            irType = new IrNonNullType(IrBuilderKt.replacePlaceholder(((IrNonNullType)$this$replacePlaceholder).getOfType(), newPath));
        } else if (irType2 instanceof IrListType) {
            irType = new IrListType(IrBuilderKt.replacePlaceholder(((IrListType)$this$replacePlaceholder).getOfType(), newPath));
        } else if (irType2 instanceof IrModelType) {
            irType = ((IrModelType)$this$replacePlaceholder).copy(newPath);
        } else {
            String string = "Not a compound type?";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return irType;
    }
}

