/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.gradle.internal;

import com.apollographql.apollo3.ast.ApolloParser;
import com.apollographql.apollo3.ast.GQLNode;
import com.apollographql.apollo3.ast.GqlnodeKt;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.compiler.IncomingOptions;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo3/gradle/internal/ApolloGenerateSchemaTask;", "Lorg/gradle/api/DefaultTask;", "()V", "incomingSchemaFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getIncomingSchemaFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "rootFolders", "Lorg/gradle/api/provider/ListProperty;", "", "getRootFolders", "()Lorg/gradle/api/provider/ListProperty;", "schemaFiles", "getSchemaFiles", "taskAction", "", "apollo-gradle-plugin-external"})
public abstract class ApolloGenerateSchemaTask
extends DefaultTask {
    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getSchemaFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getIncomingSchemaFiles();

    @Input
    @NotNull
    public abstract ListProperty<String> getRootFolders();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void taskAction() {
        String string;
        Set schemas = this.getIncomingSchemaFiles().getFiles();
        if (!(schemas.size() <= 1)) {
            boolean $i$a$-check-ApolloGenerateSchemaTask$taskAction$22 = false;
            String $i$a$-check-ApolloGenerateSchemaTask$taskAction$22 = "Apollo: multiple upstream schemas found";
            throw new IllegalStateException($i$a$-check-ApolloGenerateSchemaTask$taskAction$22.toString());
        }
        try {
            Schema schema;
            Intrinsics.checkNotNullExpressionValue((Object)schemas, (String)"schemas");
            File incomingSchema = (File)CollectionsKt.singleOrNull((Iterable)schemas);
            if (incomingSchema != null) {
                Closeable closeable = (Closeable)Okio.buffer((Source)Okio.source((File)incomingSchema));
                Throwable throwable = null;
                try {
                    BufferedSource it = (BufferedSource)closeable;
                    boolean bl = false;
                    Schema schema2 = ApolloParser.toSchema((BufferedSource)it, (String)incomingSchema.getAbsolutePath());
                    schema = schema2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                Set set = this.getSchemaFiles().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"schemaFiles.files");
                Collection collection = set;
                Object object = this.getRootFolders().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rootFolders.get()");
                schema = (Schema)IncomingOptions.Companion.resolveSchema(collection, (List)object).getFirst();
            }
            Schema schema3 = schema;
            string = GqlnodeKt.toUtf8$default((GQLNode)((GQLNode)schema3.toGQLDocument()), null, (int)1, null);
        }
        catch (Throwable e) {
            string = "Could not find a schema, make sure to add dependencies to the `apolloSchema` configuration";
        }
        String schemaText = string;
        File file = ((RegularFile)this.getOutputFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputFile.get().asFile");
        FilesKt.writeText$default((File)file, (String)schemaText, null, (int)2, null);
    }
}

