/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler.internal;

import com.apollographql.apollo3.ast.ConditionalFragment;
import com.apollographql.apollo3.ast.GQLDefinition;
import com.apollographql.apollo3.ast.GQLField;
import com.apollographql.apollo3.ast.GQLFragmentDefinition;
import com.apollographql.apollo3.ast.GQLFragmentSpread;
import com.apollographql.apollo3.ast.GQLInlineFragment;
import com.apollographql.apollo3.ast.GQLOperationDefinition;
import com.apollographql.apollo3.ast.GQLSelection;
import com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.compiler.ir.BooleanExpression;
import com.apollographql.apollo3.compiler.ir.IrOperationsBuilderKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001H\u0000\u001a$\u0010\u0000\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001H\u0002\u00a8\u0006\n"}, d2={"checkConditionalFragments", "", "Lcom/apollographql/apollo3/ast/Issue;", "definitions", "Lcom/apollographql/apollo3/ast/GQLDefinition;", "", "issues", "", "selections", "Lcom/apollographql/apollo3/ast/GQLSelection;", "apollo-compiler"})
@SourceDebugExtension(value={"SMAP\ncheckConditionalFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 checkConditionalFragment.kt\ncom/apollographql/apollo3/compiler/internal/CheckConditionalFragmentKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1863#2,2:64\n1863#2,2:66\n*S KotlinDebug\n*F\n+ 1 checkConditionalFragment.kt\ncom/apollographql/apollo3/compiler/internal/CheckConditionalFragmentKt\n*L\n18#1:64,2\n34#1:66,2\n*E\n"})
public final class CheckConditionalFragmentKt {
    @NotNull
    public static final List<Issue> checkConditionalFragments(@NotNull List<? extends GQLDefinition> definitions) {
        Intrinsics.checkNotNullParameter(definitions, (String)"definitions");
        List issues = new ArrayList();
        Iterable $this$forEach$iv = definitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLDefinition it = (GQLDefinition)element$iv;
            boolean bl = false;
            GQLDefinition gQLDefinition = it;
            if (gQLDefinition instanceof GQLOperationDefinition) {
                CheckConditionalFragmentKt.checkConditionalFragments(issues, ((GQLOperationDefinition)it).getSelections());
                continue;
            }
            if (!(gQLDefinition instanceof GQLFragmentDefinition)) continue;
            CheckConditionalFragmentKt.checkConditionalFragments(issues, ((GQLFragmentDefinition)it).getSelections());
        }
        return issues;
    }

    private static final void checkConditionalFragments(List<Issue> issues, List<? extends GQLSelection> selections) {
        Iterable $this$forEach$iv = selections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLSelection it = (GQLSelection)element$iv;
            boolean bl = false;
            GQLSelection gQLSelection = it;
            if (gQLSelection instanceof GQLField) {
                CheckConditionalFragmentKt.checkConditionalFragments(issues, ((GQLField)it).getSelections());
                continue;
            }
            if (gQLSelection instanceof GQLInlineFragment) {
                if (!Intrinsics.areEqual(IrOperationsBuilderKt.toBooleanExpression(((GQLInlineFragment)it).getDirectives()), (Object)BooleanExpression.True.INSTANCE)) {
                    issues.add((Issue)new ConditionalFragment("'responseBased' and 'experimental_operationBasedWithInterfaces' models do not support @include/@skip and @defer directives on fragments", it.getSourceLocation()));
                }
                CheckConditionalFragmentKt.checkConditionalFragments(issues, ((GQLInlineFragment)it).getSelections());
                continue;
            }
            if (!(gQLSelection instanceof GQLFragmentSpread) || Intrinsics.areEqual(IrOperationsBuilderKt.toBooleanExpression(((GQLFragmentSpread)it).getDirectives()), (Object)BooleanExpression.True.INSTANCE)) continue;
            issues.add((Issue)new ConditionalFragment("'responseBased' and 'experimental_operationBasedWithInterfaces' models do not support @include/@skip and @defer directives on fragments", it.getSourceLocation()));
        }
    }
}

