/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler.backend.codegen;

import com.apollographql.apollo3.compiler.ReservedKeywordsKt;
import com.apollographql.apollo3.compiler.backend.ast.CodeGenerationAst;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0018\u001a\u00020\u0001*\u00020\u0014H\u0000\u00a8\u0006\u0019"}, d2={"capitalizedIdentifier", "", "name", "decapitalizedIdentifier", "kotlinNameForAdapterField", "type", "Lcom/apollographql/apollo3/compiler/backend/ast/CodeGenerationAst$FieldType;", "kotlinNameForAdapterFieldRecursive", "kotlinNameForEnum", "graphqlEnum", "kotlinNameForEnumValue", "graphqlEnumValue", "kotlinNameForField", "responseName", "kotlinNameForInputObjectAdapter", "operationName", "kotlinNameForInputObjectType", "kotlinNameForOperation", "kotlinNameForTypeCaseAdapterField", "typeRef", "Lcom/apollographql/apollo3/compiler/backend/ast/CodeGenerationAst$TypeRef;", "kotlinNameForVariable", "variableName", "kotlinNameForVariablesAdapter", "fragmentPropertyName", "apollo-compiler"})
public final class KotlinNamesKt {
    @NotNull
    public static final String kotlinNameForEnumValue(@NotNull String graphqlEnumValue) {
        Intrinsics.checkParameterIsNotNull((Object)graphqlEnumValue, (String)"graphqlEnumValue");
        String string = graphqlEnumValue;
        boolean bl = false;
        String string2 = string.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
        return string2;
    }

    @NotNull
    public static final String kotlinNameForEnum(@NotNull String graphqlEnum) {
        Intrinsics.checkParameterIsNotNull((Object)graphqlEnum, (String)"graphqlEnum");
        return ReservedKeywordsKt.escapeKotlinReservedWord(graphqlEnum);
    }

    @NotNull
    public static final String kotlinNameForField(@NotNull String responseName) {
        Intrinsics.checkParameterIsNotNull((Object)responseName, (String)"responseName");
        return ReservedKeywordsKt.escapeKotlinReservedWord(responseName);
    }

    @NotNull
    public static final String kotlinNameForOperation(@NotNull String operationName) {
        Intrinsics.checkParameterIsNotNull((Object)operationName, (String)"operationName");
        return ReservedKeywordsKt.escapeKotlinReservedWord(operationName);
    }

    @NotNull
    public static final String kotlinNameForAdapterField(@NotNull CodeGenerationAst.FieldType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return StringsKt.decapitalize((String)KotlinNamesKt.kotlinNameForAdapterFieldRecursive(type)) + "Adapter";
    }

    @NotNull
    public static final String kotlinNameForTypeCaseAdapterField(@NotNull CodeGenerationAst.TypeRef typeRef) {
        Intrinsics.checkParameterIsNotNull((Object)typeRef, (String)"typeRef");
        return ReservedKeywordsKt.escapeKotlinReservedWord(typeRef.getName()) + "Adapter";
    }

    @NotNull
    public static final String kotlinNameForInputObjectType(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return KotlinNamesKt.capitalizedIdentifier(name);
    }

    @NotNull
    public static final String kotlinNameForInputObjectAdapter(@NotNull String operationName) {
        Intrinsics.checkParameterIsNotNull((Object)operationName, (String)"operationName");
        return KotlinNamesKt.kotlinNameForOperation(operationName) + "_InputAdapter";
    }

    @NotNull
    public static final String kotlinNameForVariablesAdapter(@NotNull String operationName) {
        Intrinsics.checkParameterIsNotNull((Object)operationName, (String)"operationName");
        return KotlinNamesKt.kotlinNameForOperation(operationName) + "_VariablesAdapter";
    }

    @NotNull
    public static final String kotlinNameForVariable(@NotNull String variableName) {
        Intrinsics.checkParameterIsNotNull((Object)variableName, (String)"variableName");
        return ReservedKeywordsKt.escapeKotlinReservedWord(variableName);
    }

    private static final String decapitalizedIdentifier(String name) {
        return ReservedKeywordsKt.escapeKotlinReservedWord(StringsKt.decapitalize((String)name));
    }

    private static final String capitalizedIdentifier(String name) {
        return ReservedKeywordsKt.escapeKotlinReservedWord(StringsKt.capitalize((String)name));
    }

    private static final String kotlinNameForAdapterFieldRecursive(CodeGenerationAst.FieldType type) {
        String string;
        if (type.getNullable()) {
            return "Nullable" + KotlinNamesKt.kotlinNameForAdapterFieldRecursive(type.nonNullable());
        }
        CodeGenerationAst.FieldType fieldType = type;
        if (fieldType instanceof CodeGenerationAst.FieldType.Array) {
            string = "ListOf" + KotlinNamesKt.kotlinNameForAdapterFieldRecursive(((CodeGenerationAst.FieldType.Array)type).getRawType());
        } else if (fieldType instanceof CodeGenerationAst.FieldType.Object) {
            string = StringsKt.capitalize((String)((CodeGenerationAst.FieldType.Object)type).getTypeRef().getName());
        } else if (fieldType instanceof CodeGenerationAst.FieldType.InputObject) {
            string = StringsKt.capitalize((String)((CodeGenerationAst.FieldType.InputObject)type).getTypeRef().getName());
        } else if (fieldType instanceof CodeGenerationAst.FieldType.Scalar) {
            string = StringsKt.capitalize((String)((CodeGenerationAst.FieldType.Scalar)type).getSchemaTypeName());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public static final String fragmentPropertyName(@NotNull CodeGenerationAst.TypeRef $this$fragmentPropertyName) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$fragmentPropertyName, (String)"$this$fragmentPropertyName");
        if ($this$fragmentPropertyName.isNamedFragmentDataRef()) {
            CodeGenerationAst.TypeRef typeRef = $this$fragmentPropertyName.getEnclosingType();
            if (typeRef == null) {
                Intrinsics.throwNpe();
            }
            string = ReservedKeywordsKt.escapeKotlinReservedWord(StringsKt.decapitalize((String)typeRef.getName()));
        } else {
            string = "as" + ReservedKeywordsKt.escapeKotlinReservedWord(StringsKt.capitalize((String)$this$fragmentPropertyName.getName()));
        }
        return string;
    }
}

