/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.json;

import com.apollographql.apollo3.api.json.-JsonReaders;
import com.apollographql.apollo3.api.json.JsonNumber;
import com.apollographql.apollo3.api.json.JsonReader;
import com.apollographql.apollo3.api.json.internal.UtilsKt;
import com.apollographql.apollo3.exception.JsonDataException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 =2\u00020\u0001:\u0001=B!\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010\u001e\u001a\u00020\u0000H\u0016J\b\u0010\u001f\u001a\u00020\u0000H\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\u0000H\u0016J\b\u0010\"\u001a\u00020\u0000H\u0016J\u001e\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\n2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u0002J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0016J\b\u0010'\u001a\u00020\nH\u0002J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u001bH\u0002J\b\u0010+\u001a\u00020)H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0019H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\nH\u0016J\n\u00102\u001a\u0004\u0018\u000103H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\nH\u0016J\u0006\u00107\u001a\u00020\u0003J\b\u00108\u001a\u00020\u0015H\u0016J\b\u00109\u001a\u00020\u001bH\u0016J\u0016\u0010:\u001a\u00020\u00192\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u0016J\b\u0010<\u001a\u00020\u001bH\u0016R&\u0010\u0007\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\t0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\r0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/apollographql/apollo3/api/json/MapJsonReader;", "Lcom/apollographql/apollo3/api/json/JsonReader;", "root", "", "pathRoot", "", "(Ljava/lang/Object;Ljava/util/List;)V", "containerStack", "", "", "", "[Ljava/util/Map;", "iteratorStack", "", "[Ljava/util/Iterator;", "nameIndexStack", "", "path", "[Ljava/lang/Object;", "peekedData", "peekedToken", "Lcom/apollographql/apollo3/api/json/JsonReader$Token;", "getRoot", "()Ljava/lang/Object;", "stackSize", "", "advanceIterator", "", "anyToToken", "any", "beginArray", "beginObject", "close", "endArray", "endObject", "findName", "needle", "haystack", "getPath", "getPathAsString", "hasNext", "", "increaseStack", "nextBoolean", "nextDouble", "", "nextInt", "nextLong", "", "nextName", "nextNull", "", "nextNumber", "Lcom/apollographql/apollo3/api/json/JsonNumber;", "nextString", "nextValue", "peek", "rewind", "selectName", "names", "skipValue", "Companion", "apollo-api"})
@SourceDebugExtension(value={"SMAP\nMapJsonReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapJsonReader.kt\ncom/apollographql/apollo3/api/json/MapJsonReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,434:1\n1#2:435\n*E\n"})
public final class MapJsonReader
implements JsonReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Object root;
    @NotNull
    private final List<Object> pathRoot;
    @NotNull
    private JsonReader.Token peekedToken;
    @Nullable
    private Object peekedData;
    @NotNull
    private Object[] path;
    @NotNull
    private Map<String, Object>[] containerStack;
    @NotNull
    private Iterator<?>[] iteratorStack;
    @NotNull
    private int[] nameIndexStack;
    private int stackSize;

    @JvmOverloads
    public MapJsonReader(@Nullable Object root, @NotNull List<? extends Object> pathRoot) {
        Intrinsics.checkNotNullParameter(pathRoot, (String)"pathRoot");
        this.root = root;
        this.pathRoot = pathRoot;
        this.path = new Object[64];
        this.containerStack = new Map[64];
        this.iteratorStack = new Iterator[64];
        this.nameIndexStack = new int[64];
        this.peekedToken = this.anyToToken(this.root);
        this.peekedData = this.root;
    }

    public /* synthetic */ MapJsonReader(Object object, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(object, list);
    }

    @Nullable
    public final Object getRoot() {
        return this.root;
    }

    private final JsonReader.Token anyToToken(Object any) {
        Object object = any;
        return object == null ? JsonReader.Token.NULL : (object instanceof List ? JsonReader.Token.BEGIN_ARRAY : (object instanceof Map ? JsonReader.Token.BEGIN_OBJECT : (object instanceof Integer ? JsonReader.Token.NUMBER : (object instanceof Long ? JsonReader.Token.LONG : (object instanceof Double ? JsonReader.Token.NUMBER : (object instanceof JsonNumber ? JsonReader.Token.NUMBER : (object instanceof String ? JsonReader.Token.STRING : (object instanceof Boolean ? JsonReader.Token.BOOLEAN : JsonReader.Token.ANY))))))));
    }

    private final void advanceIterator() {
        if (this.stackSize == 0) {
            this.peekedToken = JsonReader.Token.END_DOCUMENT;
            return;
        }
        Iterator<?> iterator = this.iteratorStack[this.stackSize - 1];
        Intrinsics.checkNotNull(iterator);
        Iterator<?> currentIterator = iterator;
        if (this.path[this.stackSize - 1] instanceof Integer) {
            Object object = this.path[this.stackSize - 1];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            this.path[this.stackSize - 1] = (Integer)object + 1;
        }
        if (currentIterator.hasNext()) {
            Object next = currentIterator.next();
            this.peekedData = next;
            this.peekedToken = next instanceof Map.Entry ? JsonReader.Token.NAME : this.anyToToken(next);
        } else {
            this.peekedToken = this.path[this.stackSize - 1] instanceof Integer ? JsonReader.Token.END_ARRAY : JsonReader.Token.END_OBJECT;
        }
    }

    private final void increaseStack() {
        if (this.stackSize == this.path.length) {
            Object[] objectArray = Arrays.copyOf(this.path, this.path.length * 2);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            this.path = objectArray;
            Map<String, Object>[] mapArray = Arrays.copyOf(this.containerStack, this.containerStack.length * 2);
            Intrinsics.checkNotNullExpressionValue(mapArray, (String)"copyOf(...)");
            this.containerStack = mapArray;
            int[] nArray = Arrays.copyOf(this.nameIndexStack, this.nameIndexStack.length * 2);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.nameIndexStack = nArray;
            Iterator<?>[] iteratorArray = Arrays.copyOf(this.iteratorStack, this.iteratorStack.length * 2);
            Intrinsics.checkNotNullExpressionValue(iteratorArray, (String)"copyOf(...)");
            this.iteratorStack = iteratorArray;
        }
        int n = this.stackSize;
        this.stackSize = n + 1;
    }

    @Override
    @NotNull
    public MapJsonReader beginArray() {
        MapJsonReader mapJsonReader;
        MapJsonReader $this$beginArray_u24lambda_u240 = mapJsonReader = this;
        boolean bl = false;
        if ($this$beginArray_u24lambda_u240.peek() != JsonReader.Token.BEGIN_ARRAY) {
            throw new JsonDataException("Expected BEGIN_ARRAY but was " + (Object)((Object)$this$beginArray_u24lambda_u240.peek()) + " at path " + $this$beginArray_u24lambda_u240.getPathAsString());
        }
        Object object = $this$beginArray_u24lambda_u240.peekedData;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
        List currentValue = (List)object;
        $this$beginArray_u24lambda_u240.increaseStack();
        $this$beginArray_u24lambda_u240.path[$this$beginArray_u24lambda_u240.stackSize - 1] = -1;
        $this$beginArray_u24lambda_u240.iteratorStack[$this$beginArray_u24lambda_u240.stackSize - 1] = currentValue.iterator();
        $this$beginArray_u24lambda_u240.advanceIterator();
        return mapJsonReader;
    }

    @Override
    @NotNull
    public MapJsonReader endArray() {
        MapJsonReader mapJsonReader;
        MapJsonReader $this$endArray_u24lambda_u241 = mapJsonReader = this;
        boolean bl = false;
        if ($this$endArray_u24lambda_u241.peek() != JsonReader.Token.END_ARRAY) {
            throw new JsonDataException("Expected END_ARRAY but was " + (Object)((Object)$this$endArray_u24lambda_u241.peek()) + " at path " + $this$endArray_u24lambda_u241.getPathAsString());
        }
        int n = $this$endArray_u24lambda_u241.stackSize;
        $this$endArray_u24lambda_u241.stackSize = n + -1;
        $this$endArray_u24lambda_u241.iteratorStack[$this$endArray_u24lambda_u241.stackSize] = null;
        $this$endArray_u24lambda_u241.path[$this$endArray_u24lambda_u241.stackSize] = null;
        $this$endArray_u24lambda_u241.advanceIterator();
        return mapJsonReader;
    }

    @Override
    @NotNull
    public MapJsonReader beginObject() {
        MapJsonReader mapJsonReader;
        MapJsonReader $this$beginObject_u24lambda_u242 = mapJsonReader = this;
        boolean bl = false;
        if ($this$beginObject_u24lambda_u242.peek() != JsonReader.Token.BEGIN_OBJECT) {
            throw new JsonDataException("Expected BEGIN_OBJECT but was " + (Object)((Object)$this$beginObject_u24lambda_u242.peek()) + " at path " + $this$beginObject_u24lambda_u242.getPathAsString());
        }
        $this$beginObject_u24lambda_u242.increaseStack();
        Map<String, Object>[] mapArray = $this$beginObject_u24lambda_u242.containerStack;
        int n = $this$beginObject_u24lambda_u242.stackSize - 1;
        Object object = $this$beginObject_u24lambda_u242.peekedData;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
        mapArray[n] = object;
        $this$beginObject_u24lambda_u242.rewind();
        return mapJsonReader;
    }

    @Override
    @NotNull
    public MapJsonReader endObject() {
        MapJsonReader mapJsonReader;
        MapJsonReader $this$endObject_u24lambda_u243 = mapJsonReader = this;
        boolean bl = false;
        int n = $this$endObject_u24lambda_u243.stackSize;
        $this$endObject_u24lambda_u243.stackSize = n + -1;
        $this$endObject_u24lambda_u243.iteratorStack[$this$endObject_u24lambda_u243.stackSize] = null;
        $this$endObject_u24lambda_u243.path[$this$endObject_u24lambda_u243.stackSize] = null;
        $this$endObject_u24lambda_u243.containerStack[$this$endObject_u24lambda_u243.stackSize] = null;
        $this$endObject_u24lambda_u243.advanceIterator();
        return mapJsonReader;
    }

    @Override
    public boolean hasNext() {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public JsonReader.Token peek() {
        return this.peekedToken;
    }

    @Override
    @NotNull
    public String nextName() {
        if (this.peek() != JsonReader.Token.NAME) {
            throw new JsonDataException("Expected NAME but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        Object object = this.peekedData;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map.Entry<kotlin.String, kotlin.Any?>");
        Map.Entry data = (Map.Entry)object;
        this.path[this.stackSize - 1] = data.getKey();
        this.peekedData = data.getValue();
        this.peekedToken = this.anyToToken(data.getValue());
        return (String)data.getKey();
    }

    @Override
    @NotNull
    public String nextString() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()]) {
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new JsonDataException("Expected a String but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        Object object = this.peekedData;
        Intrinsics.checkNotNull((Object)object);
        String it = string = object.toString();
        boolean bl = false;
        this.advanceIterator();
        return string;
    }

    @Override
    public boolean nextBoolean() {
        if (this.peek() != JsonReader.Token.BOOLEAN) {
            throw new JsonDataException("Expected BOOLEAN but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        Object object = this.peekedData;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        Boolean bl = (Boolean)object;
        boolean it = bl;
        boolean bl2 = false;
        this.advanceIterator();
        return bl;
    }

    @Override
    @Nullable
    public Void nextNull() {
        if (this.peek() != JsonReader.Token.NULL) {
            throw new JsonDataException("Expected NULL but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        this.advanceIterator();
        return null;
    }

    @Override
    public double nextDouble() {
        double d;
        double d2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()]) {
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new JsonDataException("Expected a Double but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        Object value = this.peekedData;
        if (value instanceof Integer) {
            d2 = ((Number)value).intValue();
        } else if (value instanceof Long) {
            d2 = UtilsKt.-LongToDoubleExact(((Number)value).longValue());
        } else if (value instanceof Double) {
            d2 = ((Number)value).doubleValue();
        } else if (value instanceof String) {
            d2 = Double.parseDouble((String)value);
        } else if (value instanceof JsonNumber) {
            d2 = Double.parseDouble(((JsonNumber)value).getValue());
        } else {
            throw new IllegalStateException(("Expected a Double but got " + value + " instead").toString());
        }
        double it = d = d2;
        boolean bl = false;
        this.advanceIterator();
        return d;
    }

    @Override
    public int nextInt() {
        int n;
        int n2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()]) {
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new JsonDataException("Expected an Int but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        Object value = this.peekedData;
        if (value instanceof Integer) {
            n2 = ((Number)value).intValue();
        } else if (value instanceof Long) {
            n2 = UtilsKt.-LongToIntExact(((Number)value).longValue());
        } else if (value instanceof Double) {
            n2 = UtilsKt.-DoubleToIntExact(((Number)value).doubleValue());
        } else if (value instanceof String) {
            n2 = Integer.parseInt((String)value);
        } else if (value instanceof JsonNumber) {
            n2 = Integer.parseInt(((JsonNumber)value).getValue());
        } else {
            throw new IllegalStateException(("Expected an Int but got " + value + " instead").toString());
        }
        int it = n = n2;
        boolean bl = false;
        this.advanceIterator();
        return n;
    }

    @Override
    public long nextLong() {
        long l;
        long l2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()]) {
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new JsonDataException("Expected a Long but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        Object value = this.peekedData;
        if (value instanceof Integer) {
            l2 = ((Number)value).intValue();
        } else if (value instanceof Long) {
            l2 = ((Number)value).longValue();
        } else if (value instanceof Double) {
            l2 = UtilsKt.-DoubleToLongExact(((Number)value).doubleValue());
        } else if (value instanceof String) {
            l2 = Long.parseLong((String)value);
        } else if (value instanceof JsonNumber) {
            l2 = Long.parseLong(((JsonNumber)value).getValue());
        } else {
            throw new IllegalStateException(("Expected Int but got " + value + " instead").toString());
        }
        long it = l = l2;
        boolean bl = false;
        this.advanceIterator();
        return l;
    }

    @Override
    @NotNull
    public JsonNumber nextNumber() {
        JsonNumber jsonNumber;
        JsonNumber jsonNumber2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()]) {
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new JsonDataException("Expected a Number but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        Object value = this.peekedData;
        if ((value instanceof Integer ? true : value instanceof Long) ? true : value instanceof Double) {
            jsonNumber2 = new JsonNumber(value.toString());
        } else if (value instanceof String) {
            jsonNumber2 = new JsonNumber((String)value);
        } else if (value instanceof JsonNumber) {
            jsonNumber2 = (JsonNumber)value;
        } else {
            throw new IllegalStateException(("Expected JsonNumber but got " + value + " instead").toString());
        }
        JsonNumber it = jsonNumber = jsonNumber2;
        boolean bl = false;
        this.advanceIterator();
        return jsonNumber;
    }

    @NotNull
    public final Object nextValue() {
        Object data;
        Object object;
        Object object2 = this.peekedData;
        if (object2 == null) {
            throw new JsonDataException("Expected a non-null value at path " + this.getPathAsString());
        }
        Object it = object = (data = object2);
        boolean bl = false;
        this.advanceIterator();
        return object;
    }

    @Override
    public void skipValue() {
        this.advanceIterator();
    }

    @Override
    public void close() {
    }

    private final int findName(String needle, List<String> haystack) {
        int expectedIndex = this.nameIndexStack[this.stackSize - 1];
        if (expectedIndex < haystack.size() && Intrinsics.areEqual((Object)haystack.get(expectedIndex), (Object)needle)) {
            this.nameIndexStack[this.stackSize - 1] = this.nameIndexStack[this.stackSize - 1] + 1;
            return expectedIndex;
        }
        int index = haystack.indexOf(needle);
        if (index != -1) {
            this.nameIndexStack[this.stackSize - 1] = index + 1;
        }
        return index;
    }

    @Override
    public int selectName(@NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        while (this.hasNext()) {
            String name = this.nextName();
            int index = this.findName(name, names);
            if (index != -1) {
                return index;
            }
            this.skipValue();
        }
        return -1;
    }

    @Override
    public void rewind() {
        Map<String, Object> container = this.containerStack[this.stackSize - 1];
        this.path[this.stackSize - 1] = null;
        Map<String, Object> map = container;
        Intrinsics.checkNotNull(map);
        this.iteratorStack[this.stackSize - 1] = map.entrySet().iterator();
        this.nameIndexStack[this.stackSize - 1] = 0;
        this.advanceIterator();
    }

    @Override
    @NotNull
    public List<Object> getPath() {
        List result = new ArrayList();
        result.addAll((Collection)this.pathRoot);
        int n = this.stackSize;
        for (int index = 0; index < n; ++index) {
            Object it;
            if (this.path[index] == null) continue;
            boolean bl = false;
            ((Collection)result).add(it);
        }
        return result;
    }

    private final String getPathAsString() {
        return CollectionsKt.joinToString$default((Iterable)this.getPath(), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    @JvmOverloads
    public MapJsonReader(@Nullable Object root) {
        this(root, null, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/apollographql/apollo3/api/json/MapJsonReader$Companion;", "", "()V", "buffer", "Lcom/apollographql/apollo3/api/json/MapJsonReader;", "Lcom/apollographql/apollo3/api/json/JsonReader;", "apollo-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapJsonReader buffer(@NotNull JsonReader $this$buffer) {
            Intrinsics.checkNotNullParameter((Object)$this$buffer, (String)"<this>");
            if ($this$buffer instanceof MapJsonReader) {
                return (MapJsonReader)$this$buffer;
            }
            JsonReader.Token token = $this$buffer.peek();
            if (!(token == JsonReader.Token.BEGIN_OBJECT)) {
                boolean $i$a$-check-MapJsonReader$Companion$buffer$22 = false;
                String $i$a$-check-MapJsonReader$Companion$buffer$22 = "Failed to buffer json reader, expected `BEGIN_OBJECT` but found `" + (Object)((Object)token) + "` json token";
                throw new IllegalStateException($i$a$-check-MapJsonReader$Companion$buffer$22.toString());
            }
            List<Object> pathRoot = $this$buffer.getPath();
            Object object = -JsonReaders.readAny($this$buffer);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Map data = (Map)object;
            return new MapJsonReader(data, pathRoot);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonReader.Token.values().length];
            try {
                nArray[JsonReader.Token.END_OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonReader.Token.END_ARRAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonReader.Token.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonReader.Token.NUMBER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonReader.Token.LONG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

