/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.json.internal;

import com.apollographql.apollo3.annotations.ApolloInternal;
import com.apollographql.apollo3.api.json.JsonNumber;
import com.apollographql.apollo3.api.json.JsonReader;
import com.apollographql.apollo3.api.json.JsonWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\u00020\u0001*\u00020\tH\u0002J\f\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\tJ\f\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u00020\t\u00a8\u0006\f"}, d2={"Lcom/apollographql/apollo3/api/json/internal/Utils;", "", "()V", "writeToJson", "", "value", "jsonWriter", "Lcom/apollographql/apollo3/api/json/JsonWriter;", "guessNumber", "Lcom/apollographql/apollo3/api/json/JsonReader;", "readRecursively", "readRecursivelyFast", "apollo-api"})
@ApolloInternal
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    public final void writeToJson(@Nullable Object value, @NotNull JsonWriter jsonWriter) {
        Intrinsics.checkNotNullParameter((Object)jsonWriter, (String)"jsonWriter");
        Object object = value;
        if (object == null) {
            jsonWriter.nullValue();
        } else if (object instanceof Map) {
            JsonWriter $this$writeObject$iv = jsonWriter;
            boolean $i$f$writeObject = false;
            $this$writeObject$iv.beginObject();
            JsonWriter $this$writeToJson_u24lambda_u2d1 = $this$writeObject$iv;
            boolean bl = false;
            Map $this$forEach$iv = (Map)value;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$key$value = element$iv = iterator.next();
                boolean bl2 = false;
                Object key = $dstr$key$value.getKey();
                Object value2 = $dstr$key$value.getValue();
                jsonWriter.name(String.valueOf(key));
                INSTANCE.writeToJson(value2, $this$writeToJson_u24lambda_u2d1);
            }
            $this$writeObject$iv.endObject();
        } else if (object instanceof List) {
            JsonWriter $this$writeArray$iv = jsonWriter;
            boolean $i$f$writeArray = false;
            $this$writeArray$iv.beginArray();
            JsonWriter $this$writeToJson_u24lambda_u2d3 = $this$writeArray$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = (Iterable)value;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl3 = false;
                INSTANCE.writeToJson(it, $this$writeToJson_u24lambda_u2d3);
            }
            $this$writeArray$iv.endArray();
        } else if (object instanceof Boolean) {
            jsonWriter.value((Boolean)value);
        } else if (object instanceof Integer) {
            jsonWriter.value(((Number)value).intValue());
        } else if (object instanceof Long) {
            jsonWriter.value(((Number)value).longValue());
        } else if (object instanceof Double) {
            jsonWriter.value(((Number)value).doubleValue());
        } else if (object instanceof JsonNumber) {
            jsonWriter.value((JsonNumber)value);
        } else if (object instanceof String) {
            jsonWriter.value((String)value);
        } else {
            throw new IllegalStateException(("Cannot write " + value + " to Json").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object readRecursivelyFast(@NotNull JsonReader $this$readRecursivelyFast) {
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)$this$readRecursivelyFast, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$readRecursivelyFast.peek().ordinal()]) {
            case 1: {
                serializable = (Serializable)((Object)$this$readRecursivelyFast.nextNull());
                break;
            }
            case 2: {
                $this$readRecursivelyFast.beginObject();
                LinkedHashMap result = new LinkedHashMap();
                while ($this$readRecursivelyFast.hasNext()) {
                    ((Map)result).put($this$readRecursivelyFast.nextName(), this.readRecursivelyFast($this$readRecursivelyFast));
                }
                $this$readRecursivelyFast.endObject();
                serializable = result;
                break;
            }
            case 3: {
                void var2_3;
                $this$readRecursivelyFast.beginArray();
                ArrayList<Object> result = new ArrayList<Object>();
                while ($this$readRecursivelyFast.hasNext()) {
                    result.add(this.readRecursivelyFast($this$readRecursivelyFast));
                }
                $this$readRecursivelyFast.endArray();
                serializable = (Serializable)var2_3;
                break;
            }
            case 4: {
                serializable = Boolean.valueOf($this$readRecursivelyFast.nextBoolean());
                break;
            }
            case 5: {
                serializable = (Serializable)((Object)$this$readRecursivelyFast.nextString());
                break;
            }
            case 6: {
                serializable = Long.valueOf($this$readRecursivelyFast.nextLong());
                break;
            }
            default: {
                String string = $this$readRecursivelyFast.nextString();
                Intrinsics.checkNotNull((Object)string);
                serializable = (Serializable)((Object)string);
            }
        }
        return serializable;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object readRecursively(@NotNull JsonReader $this$readRecursively) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$readRecursively, (String)"<this>");
        JsonReader.Token token = $this$readRecursively.peek();
        switch (WhenMappings.$EnumSwitchMapping$0[token.ordinal()]) {
            case 1: {
                object = $this$readRecursively.nextNull();
                break;
            }
            case 4: {
                object = $this$readRecursively.nextBoolean();
                break;
            }
            case 5: 
            case 6: {
                object = this.guessNumber($this$readRecursively);
                break;
            }
            case 7: {
                object = $this$readRecursively.nextString();
                break;
            }
            case 2: {
                $this$readRecursively.beginObject();
                Map result = new LinkedHashMap();
                while ($this$readRecursively.hasNext()) {
                    result.put($this$readRecursively.nextName(), this.readRecursively($this$readRecursively));
                }
                $this$readRecursively.endObject();
                object = result;
                break;
            }
            case 3: {
                void var3_4;
                $this$readRecursively.beginArray();
                List result = new ArrayList();
                while ($this$readRecursively.hasNext()) {
                    result.add(this.readRecursively($this$readRecursively));
                }
                $this$readRecursively.endArray();
                object = var3_4;
                break;
            }
            default: {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"unknown token ", (Object)((Object)token)).toString());
            }
        }
        return object;
    }

    private final Object guessNumber(JsonReader $this$guessNumber) {
        try {
            return $this$guessNumber.nextInt();
        }
        catch (Exception exception) {
            try {
                return $this$guessNumber.nextLong();
            }
            catch (Exception exception2) {
                try {
                    return $this$guessNumber.nextDouble();
                }
                catch (Exception exception3) {
                    return $this$guessNumber.nextNumber();
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonReader.Token.values().length];
            nArray[JsonReader.Token.NULL.ordinal()] = 1;
            nArray[JsonReader.Token.BEGIN_OBJECT.ordinal()] = 2;
            nArray[JsonReader.Token.BEGIN_ARRAY.ordinal()] = 3;
            nArray[JsonReader.Token.BOOLEAN.ordinal()] = 4;
            nArray[JsonReader.Token.NUMBER.ordinal()] = 5;
            nArray[JsonReader.Token.LONG.ordinal()] = 6;
            nArray[JsonReader.Token.STRING.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

