/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.internal;

import com.apollographql.apollo3.api.Adapters;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.Error;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.json.BufferedSourceJsonReader;
import com.apollographql.apollo3.api.json.JsonReader;
import com.apollographql.apollo3.api.json.MapJsonReader;
import com.apollographql.apollo3.api.json.internal.Utils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\u0006\u0010\u000b\u001a\u00020\fJB\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\u0006\u0010\u000b\u001a\u00020\fJ4\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0012\u001a\u00020\u00132\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000eJ\f\u0010\u0014\u001a\u00020\u0013*\u00020\bH\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\bH\u0002J\u0014\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0018*\u00020\bH\u0002J\u0012\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018*\u00020\bH\u0002J\u0014\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0018*\u00020\bH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/apollographql/apollo3/api/internal/ResponseBodyParser;", "", "()V", "parse", "Lcom/apollographql/apollo3/api/ApolloResponse;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "jsonReader", "Lcom/apollographql/apollo3/api/json/JsonReader;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "payload", "", "", "source", "Lokio/BufferedSource;", "parseError", "Lcom/apollographql/apollo3/api/Error;", "readError", "readErrorLocation", "Lcom/apollographql/apollo3/api/Error$Location;", "readErrorLocations", "", "readErrors", "readPath", "apollo-api"})
public final class ResponseBodyParser {
    @NotNull
    public static final ResponseBodyParser INSTANCE = new ResponseBodyParser();

    private ResponseBodyParser() {
    }

    @NotNull
    public final <D extends Operation.Data> ApolloResponse<D> parse(@NotNull JsonReader jsonReader, @NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)jsonReader, (String)"jsonReader");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        jsonReader.beginObject();
        Operation.Data data = null;
        List<Error> errors = null;
        Map extensions = null;
        block10: while (jsonReader.hasNext()) {
            switch (jsonReader.nextName()) {
                case "data": {
                    data = (Operation.Data)Adapters.-nullable(operation.adapter()).fromJson(jsonReader, customScalarAdapters);
                    continue block10;
                }
                case "errors": {
                    errors = this.readErrors(jsonReader);
                    continue block10;
                }
                case "extensions": {
                    object = Utils.INSTANCE.readRecursively(jsonReader);
                    extensions = object instanceof Map ? (Map)object : null;
                    continue block10;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        boolean $i$f$uuid4 = false;
        object = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"randomUUID()");
        Map map = extensions;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return new ApolloResponse((UUID)object, operation, data, errors, map, null, 32, null);
    }

    @NotNull
    public final <D extends Operation.Data> ApolloResponse<D> parse(@NotNull BufferedSource source, @NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        Closeable $this$use$iv = new BufferedSourceJsonReader(source);
        boolean $i$f$use = false;
        ApolloResponse<D> result$iv = null;
        Throwable thrown$iv = null;
        try {
            BufferedSourceJsonReader jsonReader = (BufferedSourceJsonReader)$this$use$iv;
            boolean bl = false;
            result$iv = INSTANCE.parse(jsonReader, operation, customScalarAdapters);
        }
        catch (Throwable t$iv) {
            thrown$iv = t$iv;
        }
        try {
            Closeable t$iv = $this$use$iv;
            t$iv.close();
        }
        catch (Throwable t$iv) {
            if (thrown$iv == null) {
                thrown$iv = t$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
        }
        if (thrown$iv != null) {
            throw thrown$iv;
        }
        ApolloResponse<D> apolloResponse = result$iv;
        Intrinsics.checkNotNull(apolloResponse);
        return apolloResponse;
    }

    @NotNull
    public final <D extends Operation.Data> ApolloResponse<D> parse(@NotNull Map<String, ? extends Object> payload, @NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        return this.parse(new MapJsonReader(payload), operation, customScalarAdapters);
    }

    @NotNull
    public final Error parseError(@NotNull Map<String, ? extends Object> payload) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        return this.readError(new MapJsonReader(payload));
    }

    private final List<Error> readErrors(JsonReader $this$readErrors) {
        if ($this$readErrors.peek() == JsonReader.Token.NULL) {
            $this$readErrors.nextNull();
            return CollectionsKt.emptyList();
        }
        $this$readErrors.beginArray();
        List list = new ArrayList();
        while ($this$readErrors.hasNext()) {
            list.add(this.readError($this$readErrors));
        }
        $this$readErrors.endArray();
        return list;
    }

    private final Error readError(JsonReader $this$readError) {
        String message = "";
        List<Error.Location> locations = null;
        List<Object> path = null;
        Map extensions = null;
        Map nonStandardFields = null;
        $this$readError.beginObject();
        block12: while ($this$readError.hasNext()) {
            String name;
            Object object;
            switch ($this$readError.nextName()) {
                case "message": {
                    String string = $this$readError.nextString();
                    if (string == null) {
                        string = "";
                    }
                    message = string;
                    continue block12;
                }
                case "locations": {
                    locations = this.readErrorLocations($this$readError);
                    continue block12;
                }
                case "path": {
                    path = this.readPath($this$readError);
                    continue block12;
                }
                case "extensions": {
                    object = Utils.INSTANCE.readRecursively($this$readError);
                    extensions = object instanceof Map ? (Map)object : null;
                    continue block12;
                }
            }
            if (nonStandardFields == null) {
                nonStandardFields = new LinkedHashMap();
            }
            object = nonStandardFields;
            Object object2 = Utils.INSTANCE.readRecursively($this$readError);
            object.put(name, object2);
        }
        $this$readError.endObject();
        return new Error(message, locations, path, extensions, nonStandardFields);
    }

    private final List<Object> readPath(JsonReader $this$readPath) {
        if ($this$readPath.peek() == JsonReader.Token.NULL) {
            return (List)((Object)$this$readPath.nextNull());
        }
        List list = new ArrayList();
        $this$readPath.beginArray();
        block3: while ($this$readPath.hasNext()) {
            switch (WhenMappings.$EnumSwitchMapping$0[$this$readPath.peek().ordinal()]) {
                case 1: 
                case 2: {
                    list.add($this$readPath.nextInt());
                    continue block3;
                }
            }
            String string = $this$readPath.nextString();
            Intrinsics.checkNotNull((Object)string);
            list.add(string);
        }
        $this$readPath.endArray();
        return list;
    }

    private final List<Error.Location> readErrorLocations(JsonReader $this$readErrorLocations) {
        if ($this$readErrorLocations.peek() == JsonReader.Token.NULL) {
            return (List)((Object)$this$readErrorLocations.nextNull());
        }
        List list = new ArrayList();
        $this$readErrorLocations.beginArray();
        while ($this$readErrorLocations.hasNext()) {
            list.add(this.readErrorLocation($this$readErrorLocations));
        }
        $this$readErrorLocations.endArray();
        return list;
    }

    private final Error.Location readErrorLocation(JsonReader $this$readErrorLocation) {
        int line = -1;
        int column = -1;
        $this$readErrorLocation.beginObject();
        while ($this$readErrorLocation.hasNext()) {
            String string = $this$readErrorLocation.nextName();
            if (Intrinsics.areEqual((Object)string, (Object)"line")) {
                line = $this$readErrorLocation.nextInt();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"column")) {
                column = $this$readErrorLocation.nextInt();
                continue;
            }
            $this$readErrorLocation.skipValue();
        }
        $this$readErrorLocation.endObject();
        return new Error.Location(line, column);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonReader.Token.values().length];
            nArray[JsonReader.Token.NUMBER.ordinal()] = 1;
            nArray[JsonReader.Token.LONG.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

