/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.internal;

import com.apollographql.apollo3.api.Adapters;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.Error;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.internal.json.BufferedSourceJsonReader;
import com.apollographql.apollo3.api.internal.json.MapJsonReader;
import com.apollographql.apollo3.api.internal.json.Utils;
import com.apollographql.apollo3.api.json.JsonReader;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\u0006\u0010\u000b\u001a\u00020\fJB\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\u0006\u0010\u000b\u001a\u00020\fJ4\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0012\u001a\u00020\u00132\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000eJ\u001a\u0010\u0014\u001a\u00020\u0013*\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000eH\u0002J\u001c\u0010\u0015\u001a\u00020\u0016*\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u000eH\u0002J\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018*\u00020\bH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/apollographql/apollo3/api/internal/ResponseBodyParser;", "", "()V", "parse", "Lcom/apollographql/apollo3/api/ApolloResponse;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "jsonReader", "Lcom/apollographql/apollo3/api/json/JsonReader;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "payload", "", "", "source", "Lokio/BufferedSource;", "parseError", "Lcom/apollographql/apollo3/api/Error;", "readError", "readErrorLocation", "Lcom/apollographql/apollo3/api/Error$Location;", "readErrors", "", "apollo-api"})
public final class ResponseBodyParser {
    @NotNull
    public static final ResponseBodyParser INSTANCE = new ResponseBodyParser();

    private ResponseBodyParser() {
    }

    @NotNull
    public final <D extends Operation.Data> ApolloResponse<D> parse(@NotNull JsonReader jsonReader, @NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)jsonReader, (String)"jsonReader");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        jsonReader.beginObject();
        Operation.Data data = null;
        List<Error> errors = null;
        Map extensions = null;
        block10: while (jsonReader.hasNext()) {
            switch (jsonReader.nextName()) {
                case "data": {
                    data = (Operation.Data)Adapters.nullable(operation.adapter()).fromJson(jsonReader, customScalarAdapters);
                    continue block10;
                }
                case "errors": {
                    errors = this.readErrors(jsonReader);
                    continue block10;
                }
                case "extensions": {
                    object = Utils.INSTANCE.readRecursively(jsonReader);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    extensions = (Map)object;
                    continue block10;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        boolean $i$f$uuid4 = false;
        object = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"randomUUID()");
        Map map = extensions;
        boolean bl = false;
        Map map2 = map;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        return new ApolloResponse((UUID)object, operation, data, errors, map2, null, 32, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <D extends Operation.Data> ApolloResponse<D> parse(@NotNull BufferedSource source, @NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters) {
        ApolloResponse<D> apolloResponse;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        Closeable $this$use$iv = new BufferedSourceJsonReader(source);
        boolean $i$f$use = false;
        Throwable exception$iv = null;
        try {
            BufferedSourceJsonReader jsonReader = (BufferedSourceJsonReader)$this$use$iv;
            boolean bl = false;
            apolloResponse = INSTANCE.parse(jsonReader, operation, customScalarAdapters);
        }
        catch (Throwable e$iv) {
            try {
                exception$iv = e$iv;
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (exception$iv == null) {
                    $this$use$iv.close();
                } else {
                    try {
                        $this$use$iv.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
        return apolloResponse;
    }

    @NotNull
    public final <D extends Operation.Data> ApolloResponse<D> parse(@NotNull Map<String, ? extends Object> payload, @NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        return this.parse(new MapJsonReader(payload), operation, customScalarAdapters);
    }

    @NotNull
    public final Error parseError(@NotNull Map<String, ? extends Object> payload) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        return this.readError(payload);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Error> readErrors(JsonReader $this$readErrors) {
        List list;
        Object object = Utils.INSTANCE.readRecursively($this$readErrors);
        List responseErrors = object instanceof List ? (List)object : null;
        object = responseErrors;
        if (object == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)it;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void errorPayload;
                Map map = (Map)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Error error = INSTANCE.readError((Map<String, ? extends Object>)errorPayload);
                collection.add(error);
            }
            list = (List)destination$iv$iv;
        }
        object = list;
        boolean bl = false;
        Object object3 = object;
        if (object3 == null) {
            object3 = CollectionsKt.emptyList();
        }
        return object3;
    }

    /*
     * WARNING - void declaration
     */
    private final Error readError(Map<String, ? extends Object> $this$readError) {
        String message = "";
        List locations = null;
        List path = null;
        Map extensions = null;
        Object object = $this$readError;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String key = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            Object value = object3.getValue();
            switch (key) {
                case "message": {
                    Object object4;
                    Object v = value;
                    message = v == null ? "" : ((object4 = v.toString()) == null ? "" : object4);
                    break;
                }
                case "locations": {
                    List list;
                    List locationItems = value instanceof List ? (List)value : null;
                    Object object4 = locationItems;
                    if (object4 == null) {
                        list = null;
                    } else {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = (Iterable)object4;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Map map = (Map)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl4 = false;
                            Error.Location location = INSTANCE.readErrorLocation((Map<String, ? extends Object>)it);
                            collection.add(location);
                        }
                        list = (List)destination$iv$iv;
                    }
                    locations = list;
                    break;
                }
                case "path": {
                    path = value instanceof List ? (List)value : null;
                    break;
                }
                case "extensions": {
                    extensions = value instanceof Map ? (Map)value : null;
                }
            }
        }
        return new Error(message, locations, path, extensions);
    }

    private final Error.Location readErrorLocation(Map<String, ? extends Object> $this$readErrorLocation) {
        int line = -1;
        int column = -1;
        if ($this$readErrorLocation != null) {
            Object object = $this$readErrorLocation;
            boolean bl = false;
            Iterator<Map.Entry<String, ? extends Object>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl2 = false;
                String key = (String)object2.getKey();
                Object object3 = object;
                boolean bl3 = false;
                Object value = object3.getValue();
                object3 = key;
                if (Intrinsics.areEqual((Object)object3, (Object)"line")) {
                    if (value == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    line = (Integer)value;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)object3, (Object)"column")) continue;
                if (value == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                column = (Integer)value;
            }
        }
        return new Error.Location(line, column);
    }
}

