/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.http;

import com.apollographql.apollo3.api.AnyAdapter;
import com.apollographql.apollo3.api.ApolloRequest;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Upload;
import com.apollographql.apollo3.api.http.DefaultHttpRequestComposerKt;
import com.apollographql.apollo3.api.http.HttpBody;
import com.apollographql.apollo3.api.http.HttpMethod;
import com.apollographql.apollo3.api.http.HttpRequest;
import com.apollographql.apollo3.api.http.HttpRequestComposer;
import com.apollographql.apollo3.api.http.HttpRequestComposerParams;
import com.apollographql.apollo3.api.http.UrlEncodeKt;
import com.apollographql.apollo3.api.internal.json.BufferedSinkJsonWriter;
import com.apollographql.apollo3.api.internal.json.FileUploadAwareJsonWriter;
import com.apollographql.apollo3.api.internal.json.MapJsonWriter;
import com.apollographql.apollo3.api.json.JsonWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/apollographql/apollo3/api/http/DefaultHttpRequestComposer;", "Lcom/apollographql/apollo3/api/http/HttpRequestComposer;", "serverUrl", "", "headers", "", "(Ljava/lang/String;Ljava/util/Map;)V", "compose", "Lcom/apollographql/apollo3/api/http/HttpRequest;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "apolloRequest", "Lcom/apollographql/apollo3/api/ApolloRequest;", "Companion", "apollo-api"})
public final class DefaultHttpRequestComposer
implements HttpRequestComposer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String serverUrl;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    public static final String HEADER_APOLLO_OPERATION_ID = "X-APOLLO-OPERATION-ID";
    @NotNull
    public static final String HEADER_APOLLO_OPERATION_NAME = "X-APOLLO-OPERATION-NAME";

    public DefaultHttpRequestComposer(@NotNull String serverUrl, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.serverUrl = serverUrl;
        this.headers = headers;
    }

    public /* synthetic */ DefaultHttpRequestComposer(String string, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string, map);
    }

    @Override
    @NotNull
    public <D extends Operation.Data> HttpRequest compose(@NotNull ApolloRequest<D> apolloRequest) {
        HttpRequest httpRequest;
        Map map;
        Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
        HttpRequestComposerParams httpRequestComposerParams = (HttpRequestComposerParams)apolloRequest.getExecutionContext().get(HttpRequestComposerParams.Key);
        HttpRequestComposerParams params = httpRequestComposerParams == null ? DefaultHttpRequestComposerKt.getDefaultHttpRequestComposerParams() : httpRequestComposerParams;
        Operation<D> operation = apolloRequest.getOperation();
        CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)apolloRequest.getExecutionContext().get(CustomScalarAdapters.Key);
        CustomScalarAdapters customScalarAdapters2 = customScalarAdapters == null ? CustomScalarAdapters.Key.getEmpty() : customScalarAdapters;
        Object object = new Pair[]{TuplesKt.to((Object)HEADER_APOLLO_OPERATION_ID, (Object)operation.id()), TuplesKt.to((Object)HEADER_APOLLO_OPERATION_NAME, (Object)operation.name())};
        Map requestHeaders = MapsKt.mutableMapOf((Pair[])object);
        Object $this$forEach$iv = this.headers;
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = object2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl2 = false;
            map = requestHeaders;
            String string = it.getKey();
            String string2 = it.getValue();
            boolean bl3 = false;
            map.put(string, string2);
        }
        $this$forEach$iv = params.getHeaders().entrySet();
        $i$f$forEach = false;
        object2 = $this$forEach$iv.iterator();
        while (object2.hasNext()) {
            Object element$iv = object2.next();
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl4 = false;
            Map map2 = requestHeaders;
            Object k = it.getKey();
            map = it.getValue();
            boolean bl5 = false;
            map2.put(k, map);
        }
        object = params.getMethod();
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                httpRequest = new HttpRequest(HttpMethod.Get, DefaultHttpRequestComposer.Companion.buildGetUrl(this.serverUrl, operation, customScalarAdapters2, params.getSendApqExtensions(), params.getSendDocument()), requestHeaders, null);
                break;
            }
            case 2: {
                String query = params.getSendDocument() ? operation.document() : null;
                httpRequest = new HttpRequest(HttpMethod.Post, this.serverUrl, requestHeaders, Companion.buildPostBody(operation, customScalarAdapters2, params.getSendApqExtensions(), query));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return httpRequest;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0006\u001a\u00020\u0004\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J6\u0010\u0011\u001a\u00020\u0012\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ8\u0010\u0013\u001a\u00020\u0014\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004J\u001c\u0010\u0016\u001a\u00020\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u0018H\u0002JD\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0018\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J,\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0018\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001dJN\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u0018\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0002J\u001e\u0010!\u001a\u00020\u0004*\u00020\u00042\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/apollographql/apollo3/api/http/DefaultHttpRequestComposer$Companion;", "", "()V", "HEADER_APOLLO_OPERATION_ID", "", "HEADER_APOLLO_OPERATION_NAME", "buildGetUrl", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "serverUrl", "operation", "Lcom/apollographql/apollo3/api/Operation;", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "autoPersistQueries", "", "sendDocument", "buildParamsMap", "Lokio/ByteString;", "buildPostBody", "Lcom/apollographql/apollo3/api/http/HttpBody;", "query", "buildUploadMap", "uploads", "", "Lcom/apollographql/apollo3/api/Upload;", "composeGetParams", "composePayload", "apolloRequest", "Lcom/apollographql/apollo3/api/ApolloRequest;", "composePostParams", "writer", "Lcom/apollographql/apollo3/api/json/JsonWriter;", "appendQueryParameters", "parameters", "apollo-api"})
    public static final class Companion {
        private Companion() {
        }

        private final <D extends Operation.Data> String buildGetUrl(String serverUrl, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument) {
            return this.appendQueryParameters(serverUrl, this.composeGetParams(operation, customScalarAdapters, autoPersistQueries, sendDocument));
        }

        private final <D extends Operation.Data> Map<String, Upload> composePostParams(JsonWriter writer, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, String query) {
            Map<String, Upload> uploads = null;
            JsonWriter $this$writeObject$iv = writer;
            boolean $i$f$writeObject = false;
            boolean bl = false;
            $this$writeObject$iv.beginObject();
            JsonWriter $this$composePostParams_u24lambda_u2d3 = $this$writeObject$iv;
            boolean bl2 = false;
            $this$composePostParams_u24lambda_u2d3.name("operationName");
            $this$composePostParams_u24lambda_u2d3.value(operation.name());
            $this$composePostParams_u24lambda_u2d3.name("variables");
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$composePostParams_u24lambda_u2d3);
            JsonWriter $this$writeObject$iv2 = uploadAwareWriter;
            boolean $i$f$writeObject2 = false;
            boolean bl3 = false;
            $this$writeObject$iv2.beginObject();
            JsonWriter $this$composePostParams_u24lambda_u2d3_u24lambda_u2d0 = $this$writeObject$iv2;
            boolean bl4 = false;
            operation.serializeVariables($this$composePostParams_u24lambda_u2d3_u24lambda_u2d0, customScalarAdapters);
            $this$writeObject$iv2.endObject();
            uploads = uploadAwareWriter.collectedUploads();
            if (query != null) {
                $this$composePostParams_u24lambda_u2d3.name("query");
                $this$composePostParams_u24lambda_u2d3.value(query);
            }
            if (autoPersistQueries) {
                $this$composePostParams_u24lambda_u2d3.name("extensions");
                $this$writeObject$iv2 = $this$composePostParams_u24lambda_u2d3;
                $i$f$writeObject2 = false;
                bl3 = false;
                $this$writeObject$iv2.beginObject();
                JsonWriter $this$composePostParams_u24lambda_u2d3_u24lambda_u2d2 = $this$writeObject$iv2;
                boolean bl5 = false;
                $this$composePostParams_u24lambda_u2d3_u24lambda_u2d2.name("persistedQuery");
                JsonWriter $this$writeObject$iv3 = $this$composePostParams_u24lambda_u2d3_u24lambda_u2d2;
                boolean $i$f$writeObject3 = false;
                boolean bl6 = false;
                $this$writeObject$iv3.beginObject();
                JsonWriter $this$composePostParams_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1 = $this$writeObject$iv3;
                boolean bl7 = false;
                $this$composePostParams_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.name("version").value(1);
                $this$composePostParams_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.name("sha256Hash").value(operation.id());
                $this$writeObject$iv3.endObject();
                $this$writeObject$iv2.endObject();
            }
            $this$writeObject$iv.endObject();
            return uploads;
        }

        private final <D extends Operation.Data> Map<String, String> composeGetParams(Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument) {
            boolean bl = false;
            Map queryParams = new LinkedHashMap();
            queryParams.put("operationName", operation.name());
            boolean $i$f$buildJsonString = false;
            boolean bl2 = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$composeGetParams_u24lambda_u2d62 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv);
            boolean bl3 = false;
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$composeGetParams_u24lambda_u2d62);
            JsonWriter $this$writeObject$iv22 = uploadAwareWriter;
            boolean $i$f$writeObject = false;
            boolean bl4 = false;
            $this$writeObject$iv22.beginObject();
            JsonWriter $this$composeGetParams_u24lambda_u2d6_u24lambda_u2d4 = $this$writeObject$iv22;
            boolean bl5 = false;
            operation.serializeVariables($this$composeGetParams_u24lambda_u2d6_u24lambda_u2d4, customScalarAdapters);
            $this$writeObject$iv22.endObject();
            boolean $this$writeObject$iv22 = uploadAwareWriter.collectedUploads().isEmpty();
            $i$f$writeObject = false;
            bl4 = false;
            if (!$this$writeObject$iv22) {
                boolean bl6 = false;
                String string = "FileUpload and Http GET are not supported at the same time";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            String variables = buffer$iv.readUtf8();
            queryParams.put("variables", variables);
            if (sendDocument) {
                queryParams.put("query", operation.document());
            }
            if (autoPersistQueries) {
                boolean $i$f$buildJsonString2 = false;
                boolean $this$composeGetParams_u24lambda_u2d62 = false;
                Buffer buffer$iv2 = new Buffer();
                JsonWriter $this$composeGetParams_u24lambda_u2d9 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv2);
                boolean bl7 = false;
                JsonWriter $this$writeObject$iv = $this$composeGetParams_u24lambda_u2d9;
                $i$f$writeObject = false;
                bl4 = false;
                $this$writeObject$iv.beginObject();
                JsonWriter $this$composeGetParams_u24lambda_u2d9_u24lambda_u2d8 = $this$writeObject$iv;
                boolean bl8 = false;
                $this$composeGetParams_u24lambda_u2d9_u24lambda_u2d8.name("persistedQuery");
                JsonWriter $this$writeObject$iv3 = $this$composeGetParams_u24lambda_u2d9_u24lambda_u2d8;
                boolean $i$f$writeObject2 = false;
                boolean bl9 = false;
                $this$writeObject$iv3.beginObject();
                JsonWriter $this$composeGetParams_u24lambda_u2d9_u24lambda_u2d8_u24lambda_u2d7 = $this$writeObject$iv3;
                boolean bl10 = false;
                $this$composeGetParams_u24lambda_u2d9_u24lambda_u2d8_u24lambda_u2d7.name("version").value(1);
                $this$composeGetParams_u24lambda_u2d9_u24lambda_u2d8_u24lambda_u2d7.name("sha256Hash").value(operation.id());
                $this$writeObject$iv3.endObject();
                $this$writeObject$iv.endObject();
                String extensions = buffer$iv2.readUtf8();
                queryParams.put("extensions", extensions);
            }
            return queryParams;
        }

        @NotNull
        public final String appendQueryParameters(@NotNull String $this$appendQueryParameters, @NotNull Map<String, String> parameters) {
            Intrinsics.checkNotNullParameter((Object)$this$appendQueryParameters, (String)"<this>");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$appendQueryParameters_u24lambda_u2d11 = stringBuilder;
            boolean bl5 = false;
            $this$appendQueryParameters_u24lambda_u2d11.append($this$appendQueryParameters);
            boolean hasQuestionMark = false;
            hasQuestionMark = StringsKt.contains$default((CharSequence)$this$appendQueryParameters, (CharSequence)"?", (boolean)false, (int)2, null);
            Iterable $this$forEach$iv = parameters.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl6 = false;
                if (hasQuestionMark) {
                    $this$appendQueryParameters_u24lambda_u2d11.append('&');
                } else {
                    hasQuestionMark = true;
                    $this$appendQueryParameters_u24lambda_u2d11.append('?');
                }
                $this$appendQueryParameters_u24lambda_u2d11.append(UrlEncodeKt.urlEncode$default((String)it.getKey(), false, 1, null));
                $this$appendQueryParameters_u24lambda_u2d11.append('=');
                $this$appendQueryParameters_u24lambda_u2d11.append(UrlEncodeKt.urlEncode$default((String)it.getValue(), false, 1, null));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public final <D extends Operation.Data> HttpBody buildPostBody(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, @Nullable String query) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            Ref.ObjectRef uploads = new Ref.ObjectRef();
            boolean $i$f$buildJsonByteString = false;
            boolean bl = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildPostBody_u24lambda_u2d12 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv);
            boolean bl2 = false;
            uploads.element = Companion.composePostParams($this$buildPostBody_u24lambda_u2d12, operation, customScalarAdapters, autoPersistQueries, query);
            ByteString operationByteString = buffer$iv.readByteString();
            if (((Map)uploads.element).isEmpty()) {
                return new HttpBody(operationByteString){
                    @NotNull
                    private final String contentType;
                    private final long contentLength;
                    final /* synthetic */ ByteString $operationByteString;
                    {
                        this.$operationByteString = $operationByteString;
                        this.contentType = "application/json";
                        this.contentLength = this.$operationByteString.size();
                    }

                    @NotNull
                    public String getContentType() {
                        return this.contentType;
                    }

                    public long getContentLength() {
                        return this.contentLength;
                    }

                    public void writeTo(@NotNull BufferedSink bufferedSink) {
                        Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"bufferedSink");
                        bufferedSink.write(this.$operationByteString);
                    }
                };
            }
            return new HttpBody(operationByteString, (Ref.ObjectRef<Map<String, Upload>>)uploads){
                @NotNull
                private final String boundary;
                @NotNull
                private final String contentType;
                private final long contentLength;
                final /* synthetic */ ByteString $operationByteString;
                final /* synthetic */ Ref.ObjectRef<Map<String, Upload>> $uploads;
                {
                    this.$operationByteString = $operationByteString;
                    this.$uploads = $uploads;
                    boolean $i$f$uuid4 = false;
                    UUID uUID = UUID.randomUUID();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
                    String string = uUID.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uuid4().toString()");
                    this.boundary = string;
                    this.contentType = Intrinsics.stringPlus((String)"multipart/form-data; boundary=", (Object)this.boundary);
                    this.contentLength = -1L;
                }

                @NotNull
                public String getContentType() {
                    return this.contentType;
                }

                public long getContentLength() {
                    return this.contentLength;
                }

                /*
                 * WARNING - void declaration
                 */
                public void writeTo(@NotNull BufferedSink bufferedSink) {
                    Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"bufferedSink");
                    bufferedSink.writeUtf8("--" + this.boundary + "\r\n");
                    bufferedSink.writeUtf8("Content-Disposition: form-data; name=\"operations\"\r\n");
                    bufferedSink.writeUtf8("Content-Type: application/json\r\n");
                    bufferedSink.writeUtf8("Content-Length: " + this.$operationByteString.size() + "\r\n");
                    bufferedSink.writeUtf8("\r\n");
                    bufferedSink.write(this.$operationByteString);
                    ByteString uploadsMap = com.apollographql.apollo3.api.http.DefaultHttpRequestComposer$Companion.access$buildUploadMap(DefaultHttpRequestComposer.Companion, (Map)this.$uploads.element);
                    bufferedSink.writeUtf8("\r\n--" + this.boundary + "\r\n");
                    bufferedSink.writeUtf8("Content-Disposition: form-data; name=\"map\"\r\n");
                    bufferedSink.writeUtf8("Content-Type: application/json\r\n");
                    bufferedSink.writeUtf8("Content-Length: " + uploadsMap.size() + "\r\n");
                    bufferedSink.writeUtf8("\r\n");
                    bufferedSink.write(uploadsMap);
                    Iterable $this$forEachIndexed$iv = ((Map)this.$uploads.element).values();
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (T item$iv : $this$forEachIndexed$iv) {
                        void upload;
                        int n = index$iv++;
                        boolean bl = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        Upload upload2 = (Upload)item$iv;
                        int index = n;
                        boolean bl2 = false;
                        bufferedSink.writeUtf8("\r\n--" + this.boundary + "\r\n");
                        bufferedSink.writeUtf8("Content-Disposition: form-data; name=\"" + index + '\"');
                        if (upload.getFileName() != null) {
                            bufferedSink.writeUtf8("; filename=\"" + upload.getFileName() + '\"');
                        }
                        bufferedSink.writeUtf8("\r\n");
                        bufferedSink.writeUtf8("Content-Type: " + upload.getContentType() + "\r\n");
                        long contentLength = upload.getContentLength();
                        if (contentLength != -1L) {
                            bufferedSink.writeUtf8("Content-Length: " + contentLength + "\r\n");
                        }
                        bufferedSink.writeUtf8("\r\n");
                        upload.writeTo(bufferedSink);
                    }
                    bufferedSink.writeUtf8("\r\n--" + this.boundary + "--\r\n");
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        private final ByteString buildUploadMap(Map<String, ? extends Upload> uploads) {
            Collection<Pair> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            boolean $i$f$buildJsonByteString = false;
            boolean bl = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildUploadMap_u24lambda_u2d14 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv);
            boolean bl2 = false;
            Iterable iterable = uploads.entrySet();
            CustomScalarAdapters customScalarAdapters = CustomScalarAdapters.Key.getEmpty();
            JsonWriter jsonWriter = $this$buildUploadMap_u24lambda_u2d14;
            AnyAdapter anyAdapter = AnyAdapter.INSTANCE;
            boolean $i$f$mapIndexed = false;
            void var11_12 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void entry;
                void index;
                int n = index$iv$iv++;
                boolean bl3 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Map.Entry entry2 = (Map.Entry)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                boolean bl4 = false;
                Pair pair = TuplesKt.to((Object)String.valueOf((int)index), (Object)CollectionsKt.listOf(entry.getKey()));
                collection.add(pair);
            }
            collection = (List)destination$iv$iv;
            anyAdapter.toJson(jsonWriter, customScalarAdapters, MapsKt.toMap((Iterable)collection));
            return buffer$iv.readByteString();
        }

        @NotNull
        public final <D extends Operation.Data> ByteString buildParamsMap(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            boolean $i$f$buildJsonByteString = false;
            boolean bl = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildParamsMap_u24lambda_u2d15 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv);
            boolean bl2 = false;
            String query = sendDocument ? operation.document() : null;
            Companion.composePostParams($this$buildParamsMap_u24lambda_u2d15, operation, customScalarAdapters, autoPersistQueries, query);
            return buffer$iv.readByteString();
        }

        @NotNull
        public final <D extends Operation.Data> Map<String, Object> composePayload(@NotNull ApolloRequest<D> apolloRequest) {
            Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
            HttpRequestComposerParams params = (HttpRequestComposerParams)apolloRequest.getExecutionContext().get(HttpRequestComposerParams.Key);
            Operation<D> operation = apolloRequest.getOperation();
            HttpRequestComposerParams httpRequestComposerParams = params;
            boolean autoPersistQueries = httpRequestComposerParams == null ? false : httpRequestComposerParams.getSendApqExtensions();
            HttpRequestComposerParams httpRequestComposerParams2 = params;
            boolean sendDocument = httpRequestComposerParams2 == null ? true : httpRequestComposerParams2.getSendDocument();
            CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)apolloRequest.getExecutionContext().get(CustomScalarAdapters.Key);
            if (customScalarAdapters == null) {
                String string = "Cannot find a ResponseAdapterCache";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            CustomScalarAdapters customScalarAdapters2 = customScalarAdapters;
            String query = sendDocument ? operation.document() : null;
            boolean $i$f$buildJsonMap = false;
            boolean bl = false;
            MapJsonWriter writer$iv = new MapJsonWriter();
            JsonWriter $this$composePayload_u24lambda_u2d16 = writer$iv;
            boolean bl2 = false;
            Companion.composePostParams($this$composePayload_u24lambda_u2d16, operation, customScalarAdapters2, autoPersistQueries, query);
            Object object = writer$iv.root();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            return (Map)object;
        }

        public static final /* synthetic */ ByteString access$buildUploadMap(Companion $this, Map uploads) {
            return $this.buildUploadMap(uploads);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpMethod.values().length];
            nArray[HttpMethod.Get.ordinal()] = 1;
            nArray[HttpMethod.Post.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

