/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.tooling;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.annotations.ApolloExperimental;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.tooling.ExceptionsKt;
import com.apollographql.apollo.tooling.GraphosKt;
import com.apollographql.apollo.tooling.platformapi.public.PublishMonolithSchemaMutation;
import com.apollographql.apollo.tooling.platformapi.public.PublishSubgraphSchemaMutation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JX\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\n\u001a\u00020\u00072\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00072\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eJ<\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eH\u0002JN\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo/tooling/SchemaUploader;", "", "<init>", "()V", "uploadSchema", "", "sdl", "", "apolloKey", "graph", "variant", "subgraph", "revision", "headers", "", "publishMonolithSchema", "apolloClient", "Lcom/apollographql/apollo/ApolloClient;", "graphID", "publishSubgraphSchema", "apollo-tooling"})
@ApolloExperimental
@SourceDebugExtension(value={"SMAP\nSchemaUploader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaUploader.kt\ncom/apollographql/apollo/tooling/SchemaUploader\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,117:1\n126#2:118\n153#2,3:119\n126#2:122\n153#2,3:123\n*S KotlinDebug\n*F\n+ 1 SchemaUploader.kt\ncom/apollographql/apollo/tooling/SchemaUploader\n*L\n65#1:118\n65#1:119,3\n102#1:122\n102#1:123,3\n*E\n"})
public final class SchemaUploader {
    @NotNull
    public static final SchemaUploader INSTANCE = new SchemaUploader();

    private SchemaUploader() {
    }

    public final void uploadSchema(@NotNull String sdl, @NotNull String apolloKey, @Nullable String graph, @NotNull String variant, @Nullable String subgraph, @Nullable String revision, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)sdl, (String)"sdl");
        Intrinsics.checkNotNullParameter((Object)apolloKey, (String)"apolloKey");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        if (!(subgraph == null && revision == null || subgraph != null && revision != null)) {
            boolean $i$a$-check-SchemaUploader$uploadSchema$22 = false;
            String $i$a$-check-SchemaUploader$uploadSchema$22 = "subgraph and revision must be both null or both not null";
            throw new IllegalStateException($i$a$-check-SchemaUploader$uploadSchema$22.toString());
        }
        String string = graph;
        if (string == null && (string = GraphosKt.getGraph(apolloKey)) == null) {
            throw new IllegalStateException("graph not found".toString());
        }
        String graphID = string;
        Map allHeaders = MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-api-key", (Object)apolloKey)), headers);
        if (subgraph == null) {
            this.publishMonolithSchema(GraphosKt.getApolloClient(), graphID, variant, sdl, allHeaders);
        } else {
            this.publishSubgraphSchema(GraphosKt.getApolloClient(), graphID, variant, sdl, subgraph, revision, allHeaders);
        }
    }

    public static /* synthetic */ void uploadSchema$default(SchemaUploader schemaUploader, String string, String string2, String string3, String string4, String string5, String string6, Map map, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = "current";
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        if ((n & 0x20) != 0) {
            string6 = null;
        }
        if ((n & 0x40) != 0) {
            map = MapsKt.emptyMap();
        }
        schemaUploader.uploadSchema(string, string2, string3, string4, string5, string6, map);
    }

    /*
     * WARNING - void declaration
     */
    private final void publishMonolithSchema(ApolloClient apolloClient2, String graphID, String variant, String sdl, Map<String, String> headers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map<String, String> map = headers;
        ApolloCall apolloCall = apolloClient2.mutation((Mutation)new PublishMonolithSchemaMutation(graphID, variant, sdl));
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new HttpHeader((String)it.getKey(), (String)it.getValue()));
        }
        ApolloCall call = apolloCall.httpHeaders((List)destination$iv$iv);
        ApolloResponse response2 = (ApolloResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ApolloResponse<PublishMonolithSchemaMutation.Data>>, Object>((ApolloCall<PublishMonolithSchemaMutation.Data>)call, null){
            int label;
            final /* synthetic */ ApolloCall<PublishMonolithSchemaMutation.Data> $call;
            {
                this.$call = $call;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$call.execute((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ApolloResponse<PublishMonolithSchemaMutation.Data>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        PublishMonolithSchemaMutation.Data data = (PublishMonolithSchemaMutation.Data)response2.data;
        if (data == null) {
            throw ExceptionsKt.toException(response2, "Cannot upload schema");
        }
        if (data.getGraph() == null) {
            List list = response2.errors;
            throw new Exception("Cannot retrieve graph '" + graphID + "': " + (list != null ? CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, SchemaUploader::publishMonolithSchema$lambda$1, (int)31, null) : null));
        }
        String code = data.getGraph().getUploadSchema().getCode();
        String message = data.getGraph().getUploadSchema().getMessage();
        boolean success = data.getGraph().getUploadSchema().getSuccess();
        if (!success) {
            throw new Exception("Cannot upload schema (code: " + code + "): " + message);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void publishSubgraphSchema(ApolloClient apolloClient2, String graphID, String variant, String sdl, String subgraph, String revision, Map<String, String> headers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = revision;
        Intrinsics.checkNotNull((Object)string);
        Object object = string;
        PublishSubgraphSchemaMutation publishSubgraphSchemaMutation = new PublishSubgraphSchemaMutation(graphID, variant, subgraph, sdl, (String)object);
        object = headers;
        ApolloCall apolloCall = apolloClient2.mutation((Mutation)publishSubgraphSchemaMutation);
        boolean $i$f$map = false;
        void var11_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new HttpHeader((String)it.getKey(), (String)it.getValue()));
        }
        ApolloCall call = apolloCall.httpHeaders((List)destination$iv$iv);
        ApolloResponse response2 = (ApolloResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ApolloResponse<PublishSubgraphSchemaMutation.Data>>, Object>((ApolloCall<PublishSubgraphSchemaMutation.Data>)call, null){
            int label;
            final /* synthetic */ ApolloCall<PublishSubgraphSchemaMutation.Data> $call;
            {
                this.$call = $call;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$call.execute((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ApolloResponse<PublishSubgraphSchemaMutation.Data>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        PublishSubgraphSchemaMutation.Data data = (PublishSubgraphSchemaMutation.Data)response2.data;
        if (data == null) {
            throw ExceptionsKt.toException(response2, "Cannot upload schema");
        }
        if (data.getGraph() == null) {
            List list = response2.errors;
            throw new Exception("Cannot find graph '" + graphID + "': " + (list != null ? CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, SchemaUploader::publishSubgraphSchema$lambda$1, (int)31, null) : null));
        }
        String errors = CollectionsKt.joinToString$default((Iterable)CollectionsKt.filterNotNull((Iterable)data.getGraph().getPublishSubgraph().getErrors()), (CharSequence)"\n", null, null, (int)0, null, SchemaUploader::publishSubgraphSchema$lambda$2, (int)30, null);
        if (((CharSequence)errors).length() > 0) {
            throw new Exception("Cannot upload schema: " + errors);
        }
    }

    private static final CharSequence publishMonolithSchema$lambda$1(Error it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMessage();
    }

    private static final CharSequence publishSubgraphSchema$lambda$1(Error it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMessage();
    }

    private static final CharSequence publishSubgraphSchema$lambda$2(PublishSubgraphSchemaMutation.Error it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCode() + ": " + it.getMessage();
    }
}

