/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized.lru;

import com.apollographql.apollo.api.internal.Optional;
import java.util.concurrent.TimeUnit;

public final class EvictionPolicy {
    public static final EvictionPolicy NO_EVICTION = EvictionPolicy.builder().build();
    private final Optional<Long> maxSizeBytes;
    private final Optional<Long> maxEntries;
    private final Optional<Long> expireAfterAccess;
    private final Optional<TimeUnit> expireAfterAccessTimeUnit;
    private final Optional<Long> expireAfterWrite;
    private final Optional<TimeUnit> expireAfterWriteTimeUnit;

    Optional<Long> maxSizeBytes() {
        return this.maxSizeBytes;
    }

    Optional<Long> maxEntries() {
        return this.maxEntries;
    }

    Optional<Long> expireAfterAccess() {
        return this.expireAfterAccess;
    }

    Optional<TimeUnit> expireAfterAccessTimeUnit() {
        return this.expireAfterAccessTimeUnit;
    }

    Optional<Long> expireAfterWrite() {
        return this.expireAfterWrite;
    }

    Optional<TimeUnit> expireAfterWriteTimeUnit() {
        return this.expireAfterWriteTimeUnit;
    }

    public static Builder builder() {
        return new Builder();
    }

    EvictionPolicy(Optional<Long> maxSizeBytes, Optional<Long> maxEntries, Optional<Long> expireAfterAccess, Optional<TimeUnit> expireAfterAccessTimeUnit, Optional<Long> expireAfterWrite, Optional<TimeUnit> expireAfterWriteTimeUnit) {
        this.maxSizeBytes = maxSizeBytes;
        this.maxEntries = maxEntries;
        this.expireAfterAccess = expireAfterAccess;
        this.expireAfterAccessTimeUnit = expireAfterAccessTimeUnit;
        this.expireAfterWrite = expireAfterWrite;
        this.expireAfterWriteTimeUnit = expireAfterWriteTimeUnit;
    }

    public static class Builder {
        private Optional<Long> maxSizeBytes = Optional.absent();
        private Optional<Long> maxEntries = Optional.absent();
        private Optional<Long> expireAfterAccess = Optional.absent();
        private Optional<TimeUnit> expireAfterAccessTimeUnit = Optional.absent();
        private Optional<Long> expireAfterWrite = Optional.absent();
        private Optional<TimeUnit> expireAfterWriteTimeUnit = Optional.absent();

        Builder() {
        }

        public Builder maxSizeBytes(long maxSizeBytes) {
            this.maxSizeBytes = Optional.of((Object)maxSizeBytes);
            return this;
        }

        public Builder maxEntries(long maxEntries) {
            this.maxEntries = Optional.of((Object)maxEntries);
            return this;
        }

        public Builder expireAfterAccess(long time, TimeUnit timeUnit) {
            this.expireAfterAccess = Optional.of((Object)time);
            this.expireAfterAccessTimeUnit = Optional.of((Object)((Object)timeUnit));
            return this;
        }

        public Builder expireAfterWrite(long time, TimeUnit timeUnit) {
            this.expireAfterWrite = Optional.of((Object)time);
            this.expireAfterWriteTimeUnit = Optional.of((Object)((Object)timeUnit));
            return this;
        }

        public EvictionPolicy build() {
            return new EvictionPolicy(this.maxSizeBytes, this.maxEntries, this.expireAfterAccess, this.expireAfterAccessTimeUnit, this.expireAfterWrite, this.expireAfterWriteTimeUnit);
        }
    }
}

