/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo;

import com.apollographql.apollo.ApolloMutationCall;
import com.apollographql.apollo.ApolloPrefetch;
import com.apollographql.apollo.ApolloQueryCall;
import com.apollographql.apollo.ApolloSubscriptionCall;
import com.apollographql.apollo.IdleResourceCallback;
import com.apollographql.apollo.Logger;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.cache.http.HttpCache;
import com.apollographql.apollo.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.ApolloStoreOperation;
import com.apollographql.apollo.cache.normalized.CacheKeyResolver;
import com.apollographql.apollo.cache.normalized.NormalizedCache;
import com.apollographql.apollo.cache.normalized.NormalizedCacheFactory;
import com.apollographql.apollo.cache.normalized.RecordFieldJsonAdapter;
import com.apollographql.apollo.fetcher.ApolloResponseFetchers;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.internal.ApolloCallTracker;
import com.apollographql.apollo.internal.ApolloLogger;
import com.apollographql.apollo.internal.RealApolloCall;
import com.apollographql.apollo.internal.RealApolloPrefetch;
import com.apollographql.apollo.internal.RealApolloSubscriptionCall;
import com.apollographql.apollo.internal.ResponseFieldMapperFactory;
import com.apollographql.apollo.internal.cache.normalized.RealApolloStore;
import com.apollographql.apollo.internal.subscription.NoOpSubscriptionManager;
import com.apollographql.apollo.internal.subscription.RealSubscriptionManager;
import com.apollographql.apollo.internal.subscription.SubscriptionManager;
import com.apollographql.apollo.response.CustomTypeAdapter;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import com.apollographql.apollo.subscription.SubscriptionTransport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApolloClient
implements ApolloQueryCall.Factory,
ApolloMutationCall.Factory,
ApolloPrefetch.Factory,
ApolloSubscriptionCall.Factory {
    private final HttpUrl serverUrl;
    private final Call.Factory httpCallFactory;
    private final HttpCache httpCache;
    private final ApolloStore apolloStore;
    private final ScalarTypeAdapters scalarTypeAdapters;
    private final ResponseFieldMapperFactory responseFieldMapperFactory = new ResponseFieldMapperFactory();
    private final Executor dispatcher;
    private final HttpCachePolicy.Policy defaultHttpCachePolicy;
    private final ResponseFetcher defaultResponseFetcher;
    private final CacheHeaders defaultCacheHeaders;
    private final ApolloLogger logger;
    private final ApolloCallTracker tracker = new ApolloCallTracker();
    private final List<ApolloInterceptor> applicationInterceptors;
    private final boolean enableAutoPersistedQueries;
    private final SubscriptionManager subscriptionManager;

    public static Builder builder() {
        return new Builder();
    }

    ApolloClient(HttpUrl serverUrl, Call.Factory httpCallFactory, HttpCache httpCache, ApolloStore apolloStore, ScalarTypeAdapters scalarTypeAdapters, Executor dispatcher, HttpCachePolicy.Policy defaultHttpCachePolicy, ResponseFetcher defaultResponseFetcher, CacheHeaders defaultCacheHeaders, ApolloLogger logger, List<ApolloInterceptor> applicationInterceptors, boolean enableAutoPersistedQueries, SubscriptionManager subscriptionManager) {
        this.serverUrl = serverUrl;
        this.httpCallFactory = httpCallFactory;
        this.httpCache = httpCache;
        this.apolloStore = apolloStore;
        this.scalarTypeAdapters = scalarTypeAdapters;
        this.dispatcher = dispatcher;
        this.defaultHttpCachePolicy = defaultHttpCachePolicy;
        this.defaultResponseFetcher = defaultResponseFetcher;
        this.defaultCacheHeaders = defaultCacheHeaders;
        this.logger = logger;
        this.applicationInterceptors = applicationInterceptors;
        this.enableAutoPersistedQueries = enableAutoPersistedQueries;
        this.subscriptionManager = subscriptionManager;
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloMutationCall<T> mutate(@NotNull Mutation<D, T, V> mutation) {
        return this.newCall((Operation<D, T, V>)mutation).responseFetcher(ApolloResponseFetchers.NETWORK_ONLY);
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloMutationCall<T> mutate(@NotNull Mutation<D, T, V> mutation, @NotNull D withOptimisticUpdates) {
        Utils.checkNotNull(withOptimisticUpdates, (Object)"withOptimisticUpdate == null");
        return this.newCall((Operation<D, T, V>)mutation).toBuilder().responseFetcher(ApolloResponseFetchers.NETWORK_ONLY).optimisticUpdates((Optional<Operation.Data>)Optional.fromNullable(withOptimisticUpdates)).build();
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloQueryCall<T> query(@NotNull Query<D, T, V> query) {
        return this.newCall((Operation<D, T, V>)query);
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloPrefetch prefetch(@NotNull Operation<D, T, V> operation) {
        return new RealApolloPrefetch(operation, this.serverUrl, this.httpCallFactory, this.scalarTypeAdapters, this.dispatcher, this.logger, this.tracker);
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloSubscriptionCall<T> subscribe(@NotNull Subscription<D, T, V> subscription) {
        return new RealApolloSubscriptionCall<T>(subscription, this.subscriptionManager);
    }

    public CacheHeaders defaultCacheHeaders() {
        return this.defaultCacheHeaders;
    }

    public void clearHttpCache() {
        if (this.httpCache != null) {
            this.httpCache.clear();
        }
    }

    public void clearNormalizedCache(@NotNull ApolloStoreOperation.Callback<Boolean> callback) {
        Utils.checkNotNull(callback, (Object)"callback == null");
        this.apolloStore.clearAll().enqueue(callback);
    }

    public boolean clearNormalizedCache() {
        return this.apolloStore.clearAll().execute();
    }

    public ApolloStore apolloStore() {
        return this.apolloStore;
    }

    public void idleCallback(IdleResourceCallback idleResourceCallback) {
        this.tracker.setIdleResourceCallback(idleResourceCallback);
    }

    public int activeCallsCount() {
        return this.tracker.activeCallsCount();
    }

    Response cachedHttpResponse(String cacheKey) throws IOException {
        if (this.httpCache != null) {
            return this.httpCache.read(cacheKey);
        }
        return null;
    }

    private <D extends Operation.Data, T, V extends Operation.Variables> RealApolloCall<T> newCall(@NotNull Operation<D, T, V> operation) {
        return RealApolloCall.builder().operation(operation).serverUrl(this.serverUrl).httpCallFactory(this.httpCallFactory).httpCache(this.httpCache).httpCachePolicy(this.defaultHttpCachePolicy).responseFieldMapperFactory(this.responseFieldMapperFactory).scalarTypeAdapters(this.scalarTypeAdapters).apolloStore(this.apolloStore).responseFetcher(this.defaultResponseFetcher).cacheHeaders(this.defaultCacheHeaders).dispatcher(this.dispatcher).logger(this.logger).applicationInterceptors(this.applicationInterceptors).tracker(this.tracker).refetchQueries(Collections.emptyList()).refetchQueryNames(Collections.emptyList()).enableAutoPersistedQueries(this.enableAutoPersistedQueries).build();
    }

    public static class Builder {
        Call.Factory callFactory;
        HttpUrl serverUrl;
        HttpCache httpCache;
        ApolloStore apolloStore = ApolloStore.NO_APOLLO_STORE;
        Optional<NormalizedCacheFactory> cacheFactory = Optional.absent();
        Optional<CacheKeyResolver> cacheKeyResolver = Optional.absent();
        HttpCachePolicy.Policy defaultHttpCachePolicy = HttpCachePolicy.NETWORK_ONLY;
        ResponseFetcher defaultResponseFetcher = ApolloResponseFetchers.CACHE_FIRST;
        CacheHeaders defaultCacheHeaders = CacheHeaders.NONE;
        final Map<ScalarType, CustomTypeAdapter> customTypeAdapters = new LinkedHashMap<ScalarType, CustomTypeAdapter>();
        Executor dispatcher;
        Optional<Logger> logger = Optional.absent();
        final List<ApolloInterceptor> applicationInterceptors = new ArrayList<ApolloInterceptor>();
        boolean enableAutoPersistedQueries;
        Optional<SubscriptionTransport.Factory> subscriptionTransportFactory = Optional.absent();
        Optional<Map<String, Object>> subscriptionConnectionParams = Optional.absent();
        long subscriptionHeartbeatTimeout = -1L;

        Builder() {
        }

        public Builder okHttpClient(@NotNull OkHttpClient okHttpClient) {
            return this.callFactory((Call.Factory)Utils.checkNotNull((Object)okHttpClient, (Object)"okHttpClient is null"));
        }

        public Builder callFactory(@NotNull Call.Factory factory) {
            this.callFactory = (Call.Factory)Utils.checkNotNull((Object)factory, (Object)"factory == null");
            return this;
        }

        public Builder serverUrl(@NotNull HttpUrl serverUrl) {
            this.serverUrl = (HttpUrl)Utils.checkNotNull((Object)serverUrl, (Object)"serverUrl is null");
            return this;
        }

        public Builder serverUrl(@NotNull String serverUrl) {
            this.serverUrl = HttpUrl.parse((String)((String)Utils.checkNotNull((Object)serverUrl, (Object)"serverUrl == null")));
            return this;
        }

        public Builder httpCache(@NotNull HttpCache httpCache) {
            this.httpCache = (HttpCache)Utils.checkNotNull((Object)httpCache, (Object)"httpCache == null");
            return this;
        }

        public Builder normalizedCache(@NotNull NormalizedCacheFactory normalizedCacheFactory) {
            return this.normalizedCache(normalizedCacheFactory, CacheKeyResolver.DEFAULT);
        }

        public Builder normalizedCache(@NotNull NormalizedCacheFactory normalizedCacheFactory, @NotNull CacheKeyResolver keyResolver) {
            this.cacheFactory = Optional.fromNullable((Object)Utils.checkNotNull((Object)normalizedCacheFactory, (Object)"normalizedCacheFactory == null"));
            this.cacheKeyResolver = Optional.fromNullable((Object)Utils.checkNotNull((Object)keyResolver, (Object)"cacheKeyResolver == null"));
            return this;
        }

        public <T> Builder addCustomTypeAdapter(@NotNull ScalarType scalarType, @NotNull CustomTypeAdapter<T> customTypeAdapter) {
            this.customTypeAdapters.put(scalarType, customTypeAdapter);
            return this;
        }

        public Builder dispatcher(@NotNull Executor dispatcher) {
            this.dispatcher = (Executor)Utils.checkNotNull((Object)dispatcher, (Object)"dispatcher == null");
            return this;
        }

        public Builder defaultHttpCachePolicy(@NotNull HttpCachePolicy.Policy cachePolicy) {
            this.defaultHttpCachePolicy = (HttpCachePolicy.Policy)Utils.checkNotNull((Object)cachePolicy, (Object)"cachePolicy == null");
            return this;
        }

        public Builder defaultCacheHeaders(@NotNull CacheHeaders cacheHeaders) {
            this.defaultCacheHeaders = (CacheHeaders)Utils.checkNotNull((Object)cacheHeaders, (Object)"cacheHeaders == null");
            return this;
        }

        public Builder defaultResponseFetcher(@NotNull ResponseFetcher defaultResponseFetcher) {
            this.defaultResponseFetcher = (ResponseFetcher)Utils.checkNotNull((Object)defaultResponseFetcher, (Object)"defaultResponseFetcher == null");
            return this;
        }

        public Builder logger(@Nullable Logger logger) {
            this.logger = Optional.fromNullable((Object)logger);
            return this;
        }

        public Builder addApplicationInterceptor(@NotNull ApolloInterceptor interceptor) {
            this.applicationInterceptors.add(interceptor);
            return this;
        }

        public Builder enableAutoPersistedQueries(boolean enableAutoPersistedQueries) {
            this.enableAutoPersistedQueries = enableAutoPersistedQueries;
            return this;
        }

        public Builder subscriptionTransportFactory(@NotNull SubscriptionTransport.Factory subscriptionTransportFactory) {
            this.subscriptionTransportFactory = Optional.of((Object)Utils.checkNotNull((Object)subscriptionTransportFactory, (Object)"subscriptionTransportFactory is null"));
            return this;
        }

        public Builder subscriptionConnectionParams(@NotNull Map<String, Object> subscriptionConnectionParams) {
            this.subscriptionConnectionParams = Optional.of((Object)Utils.checkNotNull(subscriptionConnectionParams, (Object)"subscriptionConnectionParams is null"));
            return this;
        }

        public Builder subscriptionHeartbeatTimeout(long timeout, @NotNull TimeUnit timeUnit) {
            Utils.checkNotNull((Object)((Object)timeUnit), (Object)"timeUnit is null");
            this.subscriptionHeartbeatTimeout = Math.max(timeUnit.toMillis(timeout), TimeUnit.SECONDS.toMillis(10L));
            return this;
        }

        public ApolloClient build() {
            Executor dispatcher;
            HttpCache httpCache;
            Utils.checkNotNull((Object)this.serverUrl, (Object)"serverUrl is null");
            ApolloLogger apolloLogger = new ApolloLogger(this.logger);
            Call.Factory callFactory = this.callFactory;
            if (callFactory == null) {
                callFactory = new OkHttpClient();
            }
            if ((httpCache = this.httpCache) != null) {
                callFactory = Builder.addHttpCacheInterceptorIfNeeded(callFactory, httpCache.interceptor());
            }
            if ((dispatcher = this.dispatcher) == null) {
                dispatcher = this.defaultDispatcher();
            }
            ScalarTypeAdapters scalarTypeAdapters = new ScalarTypeAdapters(this.customTypeAdapters);
            ApolloStore apolloStore = this.apolloStore;
            Optional<NormalizedCacheFactory> cacheFactory = this.cacheFactory;
            Optional<CacheKeyResolver> cacheKeyResolver = this.cacheKeyResolver;
            if (cacheFactory.isPresent() && cacheKeyResolver.isPresent()) {
                NormalizedCache normalizedCache = ((NormalizedCacheFactory)cacheFactory.get()).createChain(RecordFieldJsonAdapter.create());
                apolloStore = new RealApolloStore(normalizedCache, (CacheKeyResolver)cacheKeyResolver.get(), scalarTypeAdapters, dispatcher, apolloLogger);
            }
            SubscriptionManager subscriptionManager = new NoOpSubscriptionManager();
            Optional<SubscriptionTransport.Factory> subscriptionTransportFactory = this.subscriptionTransportFactory;
            if (subscriptionTransportFactory.isPresent()) {
                subscriptionManager = new RealSubscriptionManager(scalarTypeAdapters, (SubscriptionTransport.Factory)subscriptionTransportFactory.get(), (Map)this.subscriptionConnectionParams.or(Collections.emptyMap()), dispatcher, this.subscriptionHeartbeatTimeout);
            }
            return new ApolloClient(this.serverUrl, callFactory, httpCache, apolloStore, scalarTypeAdapters, dispatcher, this.defaultHttpCachePolicy, this.defaultResponseFetcher, this.defaultCacheHeaders, apolloLogger, this.applicationInterceptors, this.enableAutoPersistedQueries, subscriptionManager);
        }

        private Executor defaultDispatcher() {
            return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

                @Override
                public Thread newThread(@NotNull Runnable runnable) {
                    return new Thread(runnable, "Apollo Dispatcher");
                }
            });
        }

        private static Call.Factory addHttpCacheInterceptorIfNeeded(Call.Factory callFactory, Interceptor httpCacheInterceptor) {
            if (callFactory instanceof OkHttpClient) {
                OkHttpClient client = (OkHttpClient)callFactory;
                for (Interceptor interceptor : client.interceptors()) {
                    if (!interceptor.getClass().equals(httpCacheInterceptor.getClass())) continue;
                    return callFactory;
                }
                return client.newBuilder().addInterceptor(httpCacheInterceptor).build();
            }
            return callFactory;
        }
    }
}

