/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.fetcher;

import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;

public final class NetworkFirstFetcher
implements ResponseFetcher {
    @Override
    public ApolloInterceptor provideInterceptor(ApolloLogger logger) {
        return new NetworkFirstInterceptor(logger);
    }

    private static final class NetworkFirstInterceptor
    implements ApolloInterceptor {
        private volatile boolean disposed;
        private final ApolloLogger logger;

        NetworkFirstInterceptor(ApolloLogger logger) {
            this.logger = logger;
        }

        @Override
        @Nonnull
        public ApolloInterceptor.InterceptorResponse intercept(@Nonnull ApolloInterceptor.InterceptorRequest request, @Nonnull ApolloInterceptorChain chain) throws ApolloException {
            if (this.disposed) {
                throw new ApolloCanceledException("Canceled");
            }
            ApolloInterceptor.InterceptorRequest networkRequest = request.withFetchOptions(request.fetchOptions.toNetworkFetchOptions());
            try {
                return chain.proceed(networkRequest);
            }
            catch (ApolloException e) {
                ApolloInterceptor.InterceptorRequest cacheRequest = request.withFetchOptions(request.fetchOptions.toCacheFetchOptions());
                ApolloInterceptor.InterceptorResponse networkFirstCacheResponse = chain.proceed(cacheRequest);
                if (networkFirstCacheResponse.parsedResponse.isPresent()) {
                    this.logger.d(e, "Failed to fetch network response for operation %s, return cached one", request.operation);
                    return networkFirstCacheResponse;
                }
                throw e;
            }
        }

        @Override
        public void interceptAsync(final @Nonnull ApolloInterceptor.InterceptorRequest request, final @Nonnull ApolloInterceptorChain chain, final @Nonnull ExecutorService dispatcher, final @Nonnull ApolloInterceptor.CallBack callBack) {
            ApolloInterceptor.InterceptorRequest networkRequest = request.withFetchOptions(request.fetchOptions.toNetworkFetchOptions());
            chain.proceedAsync(networkRequest, dispatcher, new ApolloInterceptor.CallBack(){

                @Override
                public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                    callBack.onResponse(response);
                }

                @Override
                public void onFailure(@Nonnull ApolloException e) {
                    NetworkFirstInterceptor.this.logger.d(e, "Failed to fetch network response for operation %s, trying to return cached one", request.operation);
                    if (!NetworkFirstInterceptor.this.disposed) {
                        ApolloInterceptor.InterceptorRequest cacheRequest = request.withFetchOptions(request.fetchOptions.toCacheFetchOptions());
                        chain.proceedAsync(cacheRequest, dispatcher, callBack);
                    }
                }

                @Override
                public void onCompleted() {
                    callBack.onCompleted();
                }
            });
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }
    }
}

