/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.cache.normalized;

import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMarshaller;
import com.apollographql.apollo.api.ResponseWriter;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class CacheResponseWriter
implements ResponseWriter {
    private final Operation.Variables operationVariables;
    private final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
    final Map<String, FieldDescriptor> fieldDescriptors = new LinkedHashMap<String, FieldDescriptor>();
    final Map<String, Object> fieldValues = new LinkedHashMap<String, Object>();

    CacheResponseWriter(Operation.Variables operationVariables, Map<ScalarType, CustomTypeAdapter> customTypeAdapters) {
        this.operationVariables = operationVariables;
        this.customTypeAdapters = customTypeAdapters;
    }

    public void writeString(ResponseField field, String value) {
        this.writeScalarFieldValue(field, value);
    }

    public void writeInt(ResponseField field, Integer value) {
        this.writeScalarFieldValue(field, value != null ? BigDecimal.valueOf(value.intValue()) : null);
    }

    public void writeLong(ResponseField field, Long value) {
        this.writeScalarFieldValue(field, value != null ? BigDecimal.valueOf(value) : null);
    }

    public void writeDouble(ResponseField field, Double value) {
        this.writeScalarFieldValue(field, value != null ? BigDecimal.valueOf(value) : null);
    }

    public void writeBoolean(ResponseField field, Boolean value) {
        this.writeScalarFieldValue(field, value);
    }

    public void writeCustom(ResponseField.CustomTypeField field, Object value) {
        CustomTypeAdapter typeAdapter = this.customTypeAdapters.get(field.scalarType());
        if (typeAdapter == null) {
            this.writeScalarFieldValue((ResponseField)field, value);
        } else {
            this.writeScalarFieldValue((ResponseField)field, value != null ? typeAdapter.encode(value) : null);
        }
    }

    public void writeObject(ResponseField field, ResponseFieldMarshaller marshaller) {
        CacheResponseWriter.checkFieldValue(field, marshaller);
        if (marshaller == null) {
            this.fieldDescriptors.put(field.responseName(), new ObjectFieldDescriptor(field, Collections.emptyMap()));
            return;
        }
        CacheResponseWriter nestedResponseWriter = new CacheResponseWriter(this.operationVariables, this.customTypeAdapters);
        marshaller.marshal((ResponseWriter)nestedResponseWriter);
        this.fieldDescriptors.put(field.responseName(), new ObjectFieldDescriptor(field, nestedResponseWriter.fieldDescriptors));
        this.fieldValues.put(field.responseName(), nestedResponseWriter.fieldValues);
    }

    public void writeList(ResponseField field, ResponseWriter.ListWriter listWriter) {
        CacheResponseWriter.checkFieldValue(field, listWriter);
        if (listWriter == null) {
            this.fieldDescriptors.put(field.responseName(), new ListFieldDescriptor(field, Collections.emptyList()));
            return;
        }
        ListItemWriter listItemWriter = new ListItemWriter(this.operationVariables, this.customTypeAdapters);
        listWriter.write((ResponseWriter.ListItemWriter)listItemWriter);
        this.fieldDescriptors.put(field.responseName(), new ListFieldDescriptor(field, listItemWriter.fieldDescriptors));
        this.fieldValues.put(field.responseName(), listItemWriter.fieldValues);
    }

    public Collection<Record> normalize(ResponseNormalizer<Map<String, Object>> responseNormalizer) {
        this.normalize(this.operationVariables, responseNormalizer, this.fieldDescriptors, this.fieldValues);
        return responseNormalizer.records();
    }

    private void writeScalarFieldValue(ResponseField field, Object value) {
        CacheResponseWriter.checkFieldValue(field, value);
        this.fieldDescriptors.put(field.responseName(), new FieldDescriptor(field));
        if (value != null) {
            this.fieldValues.put(field.responseName(), value);
        }
    }

    private void normalize(Operation.Variables operationVariables, ResponseNormalizer<Map<String, Object>> responseNormalizer, Map<String, FieldDescriptor> fieldDescriptors, Map<String, Object> fieldValues) {
        for (String fieldResponseName : fieldDescriptors.keySet()) {
            FieldDescriptor fieldDescriptor = fieldDescriptors.get(fieldResponseName);
            Object fieldValue = fieldValues.get(fieldResponseName);
            responseNormalizer.willResolve(fieldDescriptor.field, operationVariables);
            switch (fieldDescriptor.field.type()) {
                case OBJECT: {
                    ObjectFieldDescriptor objectFieldDescriptor = (ObjectFieldDescriptor)fieldDescriptor;
                    Map objectFieldValues = (Map)fieldValue;
                    this.normalizeObjectField(objectFieldDescriptor, objectFieldValues, responseNormalizer);
                    break;
                }
                case OBJECT_LIST: {
                    ListFieldDescriptor listFieldDescriptor = (ListFieldDescriptor)fieldDescriptor;
                    List listFieldValues = (List)fieldValue;
                    this.normalizeObjectListField(listFieldDescriptor, listFieldValues, responseNormalizer);
                    break;
                }
                case CUSTOM_LIST: 
                case SCALAR_LIST: {
                    this.normalizeScalarList((List)fieldValue, responseNormalizer);
                    break;
                }
                default: {
                    if (fieldValue == null) {
                        responseNormalizer.didResolveNull();
                        break;
                    }
                    responseNormalizer.didResolveScalar(fieldValue);
                }
            }
            responseNormalizer.didResolve(fieldDescriptor.field, operationVariables);
        }
    }

    private void normalizeObjectField(ObjectFieldDescriptor objectFieldDescriptor, Map<String, Object> objectFieldValues, ResponseNormalizer<Map<String, Object>> responseNormalizer) {
        responseNormalizer.willResolveObject(objectFieldDescriptor.field, (Optional<Map<String, Object>>)Optional.fromNullable(objectFieldValues));
        if (objectFieldValues == null) {
            responseNormalizer.didResolveNull();
        } else {
            this.normalize(this.operationVariables, responseNormalizer, objectFieldDescriptor.childFields, objectFieldValues);
        }
        responseNormalizer.didResolveObject(objectFieldDescriptor.field, (Optional<Map<String, Object>>)Optional.fromNullable(objectFieldValues));
    }

    private void normalizeObjectListField(ListFieldDescriptor listFieldDescriptor, List<Map<String, Object>> listFieldValues, ResponseNormalizer<Map<String, Object>> responseNormalizer) {
        if (listFieldValues == null) {
            responseNormalizer.didResolveNull();
        } else {
            for (int i = 0; i < listFieldDescriptor.items.size(); ++i) {
                responseNormalizer.willResolveElement(i);
                responseNormalizer.willResolveObject(listFieldDescriptor.field, (Optional<Map<String, Object>>)Optional.fromNullable(listFieldValues.get(i)));
                this.normalize(this.operationVariables, responseNormalizer, listFieldDescriptor.items.get(i), listFieldValues.get(i));
                responseNormalizer.didResolveObject(listFieldDescriptor.field, (Optional<Map<String, Object>>)Optional.fromNullable(listFieldValues.get(i)));
                responseNormalizer.didResolveElement(i);
            }
            responseNormalizer.didResolveList(listFieldValues);
        }
    }

    private void normalizeScalarList(List listFieldValues, ResponseNormalizer<Map<String, Object>> responseNormalizer) {
        if (listFieldValues == null) {
            responseNormalizer.didResolveNull();
        } else {
            for (int i = 0; i < listFieldValues.size(); ++i) {
                responseNormalizer.willResolveElement(i);
                responseNormalizer.didResolveScalar(listFieldValues.get(i));
                responseNormalizer.didResolveElement(i);
            }
            responseNormalizer.didResolveList(listFieldValues);
        }
    }

    private static void checkFieldValue(ResponseField field, Object value) {
        if (!field.optional() && value == null) {
            throw new NullPointerException(String.format("Mandatory response field `%s` resolved with null value", field.responseName()));
        }
    }

    private static final class ListFieldDescriptor
    extends FieldDescriptor {
        final List<Map<String, FieldDescriptor>> items;

        ListFieldDescriptor(ResponseField field, List<Map<String, FieldDescriptor>> items) {
            super(field);
            this.items = items;
        }
    }

    private static final class ObjectFieldDescriptor
    extends FieldDescriptor {
        final Map<String, FieldDescriptor> childFields;

        ObjectFieldDescriptor(ResponseField field, Map<String, FieldDescriptor> childFields) {
            super(field);
            this.childFields = childFields;
        }
    }

    private static class FieldDescriptor {
        final ResponseField field;

        FieldDescriptor(ResponseField field) {
            this.field = field;
        }
    }

    private static final class ListItemWriter
    implements ResponseWriter.ListItemWriter {
        final Operation.Variables operationVariables;
        final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
        final List<Map<String, FieldDescriptor>> fieldDescriptors = new ArrayList<Map<String, FieldDescriptor>>();
        final List fieldValues = new ArrayList();

        ListItemWriter(Operation.Variables operationVariables, Map<ScalarType, CustomTypeAdapter> customTypeAdapters) {
            this.operationVariables = operationVariables;
            this.customTypeAdapters = customTypeAdapters;
        }

        public void writeString(String value) {
            this.fieldValues.add(value);
        }

        public void writeInt(Integer value) {
            this.fieldValues.add(value);
        }

        public void writeLong(Long value) {
            this.fieldValues.add(value);
        }

        public void writeDouble(Double value) {
            this.fieldValues.add(value);
        }

        public void writeBoolean(Boolean value) {
            this.fieldValues.add(value);
        }

        public void writeCustom(ScalarType scalarType, Object value) {
            CustomTypeAdapter typeAdapter = this.customTypeAdapters.get(scalarType);
            if (typeAdapter == null) {
                this.fieldValues.add(value);
            } else {
                this.fieldValues.add(typeAdapter.encode(value));
            }
        }

        public void writeObject(ResponseFieldMarshaller marshaller) {
            CacheResponseWriter nestedResponseWriter = new CacheResponseWriter(this.operationVariables, this.customTypeAdapters);
            marshaller.marshal((ResponseWriter)nestedResponseWriter);
            this.fieldDescriptors.add(nestedResponseWriter.fieldDescriptors);
            this.fieldValues.add(nestedResponseWriter.fieldValues);
        }
    }
}

