/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.fetcher;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.interceptor.FetchOptions;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;

public final class NetworkOnlyFetcher
implements ResponseFetcher {
    @Override
    public ApolloInterceptor provideInterceptor(ApolloLogger apolloLogger) {
        return new NetworkOnlyInterceptor();
    }

    private static final class NetworkOnlyInterceptor
    implements ApolloInterceptor {
        private volatile boolean disposed;

        private NetworkOnlyInterceptor() {
        }

        @Override
        @Nonnull
        public ApolloInterceptor.InterceptorResponse intercept(@Nonnull Operation operation, @Nonnull ApolloInterceptorChain chain, @Nonnull FetchOptions options) throws ApolloException {
            if (this.disposed) {
                throw new ApolloCanceledException("Canceled");
            }
            return chain.proceed(options.toNetworkFetchOptions());
        }

        @Override
        public void interceptAsync(@Nonnull Operation operation, @Nonnull ApolloInterceptorChain chain, @Nonnull ExecutorService dispatcher, @Nonnull FetchOptions options, @Nonnull ApolloInterceptor.CallBack callBack) {
            chain.proceedAsync(dispatcher, options.toNetworkFetchOptions(), callBack);
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }
    }
}

