/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloMutationCall;
import com.apollographql.apollo.ApolloQueryCall;
import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.http.HttpCache;
import com.apollographql.apollo.cache.http.HttpCachePolicy;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.ApolloParseException;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.interceptor.FetchOptions;
import com.apollographql.apollo.internal.ApolloCallTracker;
import com.apollographql.apollo.internal.CallState;
import com.apollographql.apollo.internal.QueryReFetcher;
import com.apollographql.apollo.internal.RealApolloQueryWatcher;
import com.apollographql.apollo.internal.ResponseFieldMapperFactory;
import com.apollographql.apollo.internal.interceptor.ApolloCacheInterceptor;
import com.apollographql.apollo.internal.interceptor.ApolloParseInterceptor;
import com.apollographql.apollo.internal.interceptor.ApolloServerInterceptor;
import com.apollographql.apollo.internal.interceptor.RealApolloInterceptorChain;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.HttpUrl;

public final class RealApolloCall<T>
implements ApolloQueryCall<T>,
ApolloMutationCall<T> {
    final Operation operation;
    final HttpUrl serverUrl;
    final Call.Factory httpCallFactory;
    final HttpCache httpCache;
    final HttpCachePolicy.Policy httpCachePolicy;
    final ResponseFieldMapperFactory responseFieldMapperFactory;
    final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
    final ApolloStore apolloStore;
    final CacheHeaders cacheHeaders;
    final FetchOptions fetchOptions;
    final ResponseFetcher responseFetcher;
    final ApolloInterceptorChain interceptorChain;
    final ExecutorService dispatcher;
    final ApolloLogger logger;
    final ApolloCallTracker tracker;
    final List<ApolloInterceptor> applicationInterceptors;
    final List<OperationName> refetchQueryNames;
    final List<Query> refetchQueries;
    final Optional<QueryReFetcher> queryReFetcher;
    final boolean sendOperationdIdentifiers;
    final AtomicReference<CallState> state = new AtomicReference<CallState>(CallState.IDLE);
    final AtomicReference<ApolloCall.Callback<T>> originalCallback = new AtomicReference();

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private RealApolloCall(Builder<T> builder) {
        this.operation = builder.operation;
        this.serverUrl = builder.serverUrl;
        this.httpCallFactory = builder.httpCallFactory;
        this.httpCache = builder.httpCache;
        this.httpCachePolicy = builder.httpCachePolicy;
        this.responseFieldMapperFactory = builder.responseFieldMapperFactory;
        this.customTypeAdapters = builder.customTypeAdapters;
        this.apolloStore = builder.apolloStore;
        this.responseFetcher = builder.responseFetcher;
        this.cacheHeaders = builder.cacheHeaders;
        this.fetchOptions = FetchOptions.NETWORK_ONLY.edit().cacheHeaders(this.cacheHeaders).build();
        this.dispatcher = builder.dispatcher;
        this.logger = builder.logger;
        this.applicationInterceptors = builder.applicationInterceptors;
        this.refetchQueryNames = builder.refetchQueryNames;
        this.refetchQueries = builder.refetchQueries;
        this.tracker = builder.tracker;
        this.queryReFetcher = this.refetchQueries.isEmpty() && this.refetchQueryNames.isEmpty() || builder.apolloStore == null ? Optional.absent() : Optional.of((Object)QueryReFetcher.builder().queries(builder.refetchQueries).queryWatchers(this.refetchQueryNames).serverUrl(builder.serverUrl).httpCallFactory(builder.httpCallFactory).responseFieldMapperFactory(builder.responseFieldMapperFactory).customTypeAdapters(builder.customTypeAdapters).apolloStore(builder.apolloStore).dispatcher(builder.dispatcher).logger(builder.logger).applicationInterceptors(builder.applicationInterceptors).callTracker(builder.tracker).build());
        this.sendOperationdIdentifiers = builder.sendOperationIdentifiers;
        this.interceptorChain = this.prepareInterceptorChain(this.operation);
    }

    @Override
    @Nonnull
    public Response<T> execute() throws ApolloException {
        Response response;
        this.activate(Optional.absent());
        try {
            response = (Response)this.interceptorChain.proceed((FetchOptions)this.fetchOptions).parsedResponse.or((Object)Response.builder((Operation)this.operation).build());
        }
        catch (Exception e) {
            if (this.state.get() == CallState.CANCELED) {
                throw new ApolloCanceledException("Call canceled", e);
            }
            throw e;
        }
        finally {
            this.terminate();
        }
        if (this.queryReFetcher.isPresent()) {
            ((QueryReFetcher)this.queryReFetcher.get()).refetch();
        }
        return response;
    }

    @Override
    public void enqueue(@Nullable ApolloCall.Callback<T> responseCallback) {
        try {
            this.activate(Optional.fromNullable(responseCallback));
        }
        catch (ApolloCanceledException e) {
            if (responseCallback != null) {
                responseCallback.onCanceledError(e);
            } else {
                this.logger.e(e, "Operation: %s was canceled", this.operation().name().name());
            }
            return;
        }
        this.interceptorChain.proceedAsync(this.dispatcher, this.fetchOptions, this.interceptorCallbackProxy());
    }

    @Override
    @Nonnull
    public RealApolloQueryWatcher<T> watcher() {
        return new RealApolloQueryWatcher(this.clone(), this.apolloStore, this.logger, this.tracker);
    }

    @Override
    @Nonnull
    public RealApolloCall<T> httpCachePolicy(@Nonnull HttpCachePolicy.Policy httpCachePolicy) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return this.toBuilder().httpCachePolicy((HttpCachePolicy.Policy)Utils.checkNotNull((Object)httpCachePolicy, (Object)"httpCachePolicy == null")).build();
    }

    @Override
    @Nonnull
    public RealApolloCall<T> responseFetcher(@Nonnull ResponseFetcher fetcher) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return this.toBuilder().responseFetcher((ResponseFetcher)Utils.checkNotNull((Object)fetcher, (Object)"responseFetcher == null")).build();
    }

    @Override
    @Nonnull
    public RealApolloCall<T> cacheHeaders(@Nonnull CacheHeaders cacheHeaders) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return this.toBuilder().cacheHeaders((CacheHeaders)Utils.checkNotNull((Object)cacheHeaders, (Object)"cacheHeaders == null")).build();
    }

    @Override
    public synchronized void cancel() {
        switch (this.state.get()) {
            case ACTIVE: {
                try {
                    this.interceptorChain.dispose();
                    if (!this.queryReFetcher.isPresent()) break;
                    ((QueryReFetcher)this.queryReFetcher.get()).cancel();
                    break;
                }
                finally {
                    this.tracker.unregisterCall(this);
                    this.originalCallback.set(null);
                    this.state.set(CallState.CANCELED);
                }
            }
            case IDLE: {
                this.state.set(CallState.CANCELED);
                break;
            }
            case CANCELED: 
            case TERMINATED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    @Override
    @Nonnull
    public RealApolloCall<T> clone() {
        return this.toBuilder().build();
    }

    @Override
    @Nonnull
    public ApolloMutationCall<T> refetchQueries(OperationName ... operationNames) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return this.toBuilder().refetchQueryNames(Arrays.asList((Object[])Utils.checkNotNull((Object)operationNames, (Object)"operationNames == null"))).build();
    }

    @Override
    @Nonnull
    public ApolloMutationCall<T> refetchQueries(Query ... queries) {
        if (this.state.get() != CallState.IDLE) {
            throw new IllegalStateException("Already Executed");
        }
        return this.toBuilder().refetchQueries(Arrays.asList((Object[])Utils.checkNotNull((Object)queries, (Object)"queries == null"))).build();
    }

    @Override
    @Nonnull
    public Operation operation() {
        return this.operation;
    }

    private ApolloInterceptor.CallBack interceptorCallbackProxy() {
        return new ApolloInterceptor.CallBack(){

            @Override
            public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                Optional callback = RealApolloCall.this.responseCallback();
                if (!callback.isPresent()) {
                    RealApolloCall.this.logger.d("onResponse for operation: %s. No callback present.", RealApolloCall.this.operation().name().name());
                    return;
                }
                ((ApolloCall.Callback)callback.get()).onResponse((Response)response.parsedResponse.get());
            }

            @Override
            public void onFailure(@Nonnull ApolloException e) {
                Optional callback = RealApolloCall.this.terminate();
                if (!callback.isPresent()) {
                    RealApolloCall.this.logger.d(e, "onFailure for operation: %s. No callback present.", RealApolloCall.this.operation().name().name());
                    return;
                }
                if (e instanceof ApolloHttpException) {
                    ((ApolloCall.Callback)callback.get()).onHttpError((ApolloHttpException)e);
                } else if (e instanceof ApolloParseException) {
                    ((ApolloCall.Callback)callback.get()).onParseError((ApolloParseException)e);
                } else if (e instanceof ApolloNetworkException) {
                    ((ApolloCall.Callback)callback.get()).onNetworkError((ApolloNetworkException)e);
                } else {
                    ((ApolloCall.Callback)callback.get()).onFailure(e);
                }
            }

            @Override
            public void onCompleted() {
                Optional callback = RealApolloCall.this.terminate();
                if (RealApolloCall.this.queryReFetcher.isPresent()) {
                    ((QueryReFetcher)RealApolloCall.this.queryReFetcher.get()).refetch();
                }
                if (!callback.isPresent()) {
                    RealApolloCall.this.logger.d("onCompleted for operation: %s. No callback present.", RealApolloCall.this.operation().name().name());
                    return;
                }
                ((ApolloCall.Callback)callback.get()).onCompleted();
            }
        };
    }

    public Builder<T> toBuilder() {
        return RealApolloCall.builder().operation(this.operation).serverUrl(this.serverUrl).httpCallFactory(this.httpCallFactory).httpCache(this.httpCache).httpCachePolicy(this.httpCachePolicy).responseFieldMapperFactory(this.responseFieldMapperFactory).customTypeAdapters(this.customTypeAdapters).apolloStore(this.apolloStore).cacheHeaders(this.cacheHeaders).responseFetcher(this.responseFetcher).dispatcher(this.dispatcher).logger(this.logger).applicationInterceptors(this.applicationInterceptors).tracker(this.tracker).refetchQueryNames(this.refetchQueryNames).refetchQueries(this.refetchQueries).sendOperationIdentifiers(this.sendOperationdIdentifiers);
    }

    private synchronized void activate(Optional<ApolloCall.Callback<T>> callback) throws ApolloCanceledException {
        switch (this.state.get()) {
            case IDLE: {
                this.originalCallback.set((ApolloCall.Callback<T>)callback.orNull());
                this.tracker.registerCall(this);
                break;
            }
            case CANCELED: {
                throw new ApolloCanceledException("Call is cancelled.");
            }
            case ACTIVE: 
            case TERMINATED: {
                throw new IllegalStateException("Already Executed");
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
        this.state.set(CallState.ACTIVE);
    }

    private synchronized Optional<ApolloCall.Callback<T>> responseCallback() {
        switch (this.state.get()) {
            case ACTIVE: 
            case CANCELED: {
                return Optional.fromNullable(this.originalCallback.get());
            }
            case IDLE: 
            case TERMINATED: {
                throw new IllegalStateException(CallState.IllegalStateMessage.forCurrentState(this.state.get()).expected(CallState.ACTIVE, CallState.CANCELED));
            }
        }
        throw new IllegalStateException("Unknown state");
    }

    private synchronized Optional<ApolloCall.Callback<T>> terminate() {
        switch (this.state.get()) {
            case ACTIVE: {
                this.tracker.unregisterCall(this);
                this.state.set(CallState.TERMINATED);
                return Optional.fromNullable(this.originalCallback.getAndSet(null));
            }
            case CANCELED: {
                return Optional.fromNullable(this.originalCallback.getAndSet(null));
            }
            case IDLE: 
            case TERMINATED: {
                throw new IllegalStateException(CallState.IllegalStateMessage.forCurrentState(this.state.get()).expected(CallState.ACTIVE, CallState.CANCELED));
            }
        }
        throw new IllegalStateException("Unknown state");
    }

    private ApolloInterceptorChain prepareInterceptorChain(Operation operation) {
        ArrayList<ApolloInterceptor> interceptors = new ArrayList<ApolloInterceptor>();
        HttpCachePolicy.Policy httpCachePolicy = operation instanceof Query ? this.httpCachePolicy : null;
        ResponseFieldMapper responseFieldMapper = this.responseFieldMapperFactory.create(operation);
        interceptors.addAll(this.applicationInterceptors);
        interceptors.add(this.responseFetcher.provideInterceptor(this.logger));
        interceptors.add(new ApolloCacheInterceptor(this.apolloStore, responseFieldMapper, this.dispatcher, this.logger));
        interceptors.add(new ApolloParseInterceptor(this.httpCache, this.apolloStore.networkResponseNormalizer(), responseFieldMapper, this.customTypeAdapters, this.logger));
        interceptors.add(new ApolloServerInterceptor(this.serverUrl, this.httpCallFactory, httpCachePolicy, false, this.customTypeAdapters, this.logger, this.sendOperationdIdentifiers));
        return new RealApolloInterceptorChain(operation, interceptors);
    }

    public static final class Builder<T> {
        Operation operation;
        HttpUrl serverUrl;
        Call.Factory httpCallFactory;
        HttpCache httpCache;
        HttpCachePolicy.Policy httpCachePolicy;
        ResponseFieldMapperFactory responseFieldMapperFactory;
        Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
        ApolloStore apolloStore;
        ResponseFetcher responseFetcher;
        CacheHeaders cacheHeaders;
        ApolloInterceptorChain interceptorChain;
        ExecutorService dispatcher;
        ApolloLogger logger;
        List<ApolloInterceptor> applicationInterceptors;
        List<OperationName> refetchQueryNames = Collections.emptyList();
        List<Query> refetchQueries = Collections.emptyList();
        ApolloCallTracker tracker;
        boolean sendOperationIdentifiers;

        public Builder<T> operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public Builder<T> serverUrl(HttpUrl serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder<T> httpCallFactory(Call.Factory httpCallFactory) {
            this.httpCallFactory = httpCallFactory;
            return this;
        }

        public Builder<T> httpCache(HttpCache httpCache) {
            this.httpCache = httpCache;
            return this;
        }

        public Builder<T> httpCachePolicy(HttpCachePolicy.Policy httpCachePolicy) {
            this.httpCachePolicy = httpCachePolicy;
            return this;
        }

        public Builder<T> responseFieldMapperFactory(ResponseFieldMapperFactory responseFieldMapperFactory) {
            this.responseFieldMapperFactory = responseFieldMapperFactory;
            return this;
        }

        public Builder<T> customTypeAdapters(Map<ScalarType, CustomTypeAdapter> customTypeAdapters) {
            this.customTypeAdapters = customTypeAdapters;
            return this;
        }

        public Builder<T> apolloStore(ApolloStore apolloStore) {
            this.apolloStore = apolloStore;
            return this;
        }

        public Builder<T> responseFetcher(ResponseFetcher responseFetcher) {
            this.responseFetcher = responseFetcher;
            return this;
        }

        public Builder<T> cacheHeaders(CacheHeaders cacheHeaders) {
            this.cacheHeaders = cacheHeaders;
            return this;
        }

        public Builder<T> interceptorChain(ApolloInterceptorChain interceptorChain) {
            this.interceptorChain = interceptorChain;
            return this;
        }

        public Builder<T> dispatcher(ExecutorService dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        public Builder<T> logger(ApolloLogger logger) {
            this.logger = logger;
            return this;
        }

        public Builder<T> tracker(ApolloCallTracker tracker) {
            this.tracker = tracker;
            return this;
        }

        public Builder<T> applicationInterceptors(List<ApolloInterceptor> applicationInterceptors) {
            this.applicationInterceptors = applicationInterceptors;
            return this;
        }

        public Builder<T> refetchQueryNames(List<OperationName> refetchQueryNames) {
            this.refetchQueryNames = refetchQueryNames != null ? new ArrayList<OperationName>(refetchQueryNames) : Collections.emptyList();
            return this;
        }

        public Builder<T> refetchQueries(List<Query> refetchQueries) {
            this.refetchQueries = refetchQueries != null ? new ArrayList<Query>(refetchQueries) : Collections.emptyList();
            return this;
        }

        public Builder<T> sendOperationIdentifiers(boolean sendOperationIdentifiers) {
            this.sendOperationIdentifiers = sendOperationIdentifiers;
            return this;
        }

        Builder() {
        }

        public RealApolloCall<T> build() {
            return new RealApolloCall(this);
        }
    }
}

