/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.internal.util.Cancelable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Response;

public interface ApolloPrefetch
extends Cancelable {
    public void execute() throws ApolloException;

    public void enqueue(@Nullable Callback var1);

    public ApolloPrefetch clone();

    @Nonnull
    public Operation operation();

    @Override
    public void cancel();

    public static interface Factory {
        public <D extends Operation.Data, T, V extends Operation.Variables> ApolloPrefetch prefetch(@Nonnull Operation<D, T, V> var1);
    }

    public static abstract class Callback {
        public abstract void onSuccess();

        public abstract void onFailure(@Nonnull ApolloException var1);

        public void onHttpError(@Nonnull ApolloHttpException e) {
            this.onFailure(e);
            Response response = e.rawResponse();
            if (response != null) {
                response.close();
            }
        }

        public void onNetworkError(@Nonnull ApolloNetworkException e) {
            this.onFailure(e);
        }

        public void onCanceledError(@Nonnull ApolloCanceledException e) {
            this.onFailure(e);
        }
    }
}

