/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.reader;

import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.internal.field.FieldValueResolver;
import com.apollographql.apollo.internal.reader.ResponseReaderShadow;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class RealResponseReader<R>
implements ResponseReader {
    private final Operation.Variables operationVariables;
    private final R recordSet;
    private final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
    private final FieldValueResolver<R> fieldValueResolver;
    private final ResponseReaderShadow<R> readerShadow;

    public RealResponseReader(Operation.Variables operationVariables, R recordSet, FieldValueResolver<R> fieldValueResolver, Map<ScalarType, CustomTypeAdapter> customTypeAdapters, ResponseReaderShadow<R> readerShadow) {
        this.operationVariables = operationVariables;
        this.recordSet = recordSet;
        this.fieldValueResolver = fieldValueResolver;
        this.customTypeAdapters = customTypeAdapters;
        this.readerShadow = readerShadow;
    }

    public String readString(ResponseField field) {
        this.willResolve(field);
        String value = (String)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(value, field.optional());
        if (value == null) {
            this.readerShadow.didResolveNull();
        } else {
            this.readerShadow.didResolveScalar(value);
        }
        this.didResolve(field);
        return value;
    }

    public Integer readInt(ResponseField field) {
        this.willResolve(field);
        BigDecimal value = (BigDecimal)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(value, field.optional());
        if (value == null) {
            this.readerShadow.didResolveNull();
        } else {
            this.readerShadow.didResolveScalar(value);
        }
        this.didResolve(field);
        return value != null ? Integer.valueOf(value.intValue()) : null;
    }

    public Long readLong(ResponseField field) {
        this.willResolve(field);
        BigDecimal value = (BigDecimal)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(value, field.optional());
        if (value == null) {
            this.readerShadow.didResolveNull();
        } else {
            this.readerShadow.didResolveScalar(value);
        }
        this.didResolve(field);
        return value != null ? Long.valueOf(value.longValue()) : null;
    }

    public Double readDouble(ResponseField field) {
        this.willResolve(field);
        BigDecimal value = (BigDecimal)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(value, field.optional());
        if (value == null) {
            this.readerShadow.didResolveNull();
        } else {
            this.readerShadow.didResolveScalar(value);
        }
        this.didResolve(field);
        return value != null ? Double.valueOf(value.doubleValue()) : null;
    }

    public Boolean readBoolean(ResponseField field) {
        this.willResolve(field);
        Boolean value = (Boolean)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(value, field.optional());
        if (value == null) {
            this.readerShadow.didResolveNull();
        } else {
            this.readerShadow.didResolveScalar(value);
        }
        this.didResolve(field);
        return value;
    }

    public <T> T readObject(ResponseField field, ResponseReader.ObjectReader<T> objectReader) {
        Object parsedValue;
        this.willResolve(field);
        Object value = this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(value, field.optional());
        this.readerShadow.willResolveObject(field, Optional.fromNullable(value));
        if (value == null) {
            this.readerShadow.didResolveNull();
            parsedValue = null;
        } else {
            parsedValue = objectReader.read(new RealResponseReader(this.operationVariables, value, this.fieldValueResolver, this.customTypeAdapters, this.readerShadow));
            this.readerShadow.didResolveObject(field, Optional.fromNullable(value));
        }
        this.didResolve(field);
        return (T)parsedValue;
    }

    public <T> List<T> readList(ResponseField field, ResponseReader.ListReader listReader) {
        ArrayList<Object> result;
        this.willResolve(field);
        List values = (List)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(values, field.optional());
        if (values == null) {
            this.readerShadow.didResolveNull();
            result = null;
        } else {
            result = new ArrayList<Object>();
            for (int i = 0; i < values.size(); ++i) {
                this.readerShadow.willResolveElement(i);
                Object value = values.get(i);
                Object item = listReader.read((ResponseReader.ListItemReader)new ListItemReader(field, value));
                this.readerShadow.didResolveElement(i);
                result.add(item);
            }
            this.readerShadow.didResolveList(values);
        }
        this.didResolve(field);
        return result != null ? Collections.unmodifiableList(result) : null;
    }

    public <T> T readCustomType(ResponseField.CustomTypeField field) {
        T result;
        this.willResolve((ResponseField)field);
        Object value = this.fieldValueResolver.valueFor(this.recordSet, (ResponseField)field);
        this.checkValue(value, field.optional());
        if (value == null) {
            this.readerShadow.didResolveNull();
            result = null;
        } else {
            CustomTypeAdapter typeAdapter = this.customTypeAdapters.get(field.scalarType());
            if (typeAdapter == null) {
                this.readerShadow.didResolveScalar(value);
                result = value;
            } else {
                this.readerShadow.didResolveScalar(value);
                result = typeAdapter.decode(value.toString());
            }
        }
        this.didResolve((ResponseField)field);
        return result;
    }

    public <T> T readConditional(ResponseField.ConditionalTypeField field, ResponseReader.ConditionalTypeReader<T> conditionalTypeReader) {
        Object result;
        this.willResolve((ResponseField)field);
        String value = (String)this.fieldValueResolver.valueFor(this.recordSet, (ResponseField)field);
        this.checkValue(value, field.optional());
        if (value == null) {
            this.readerShadow.didResolveNull();
            this.didResolve((ResponseField)field);
            result = null;
        } else if (field.type() == ResponseField.Type.INLINE_FRAGMENT && !field.conditionalTypes().contains(value)) {
            this.readerShadow.didResolveScalar(value);
            this.didResolve((ResponseField)field);
            result = null;
        } else {
            this.readerShadow.didResolveScalar(value);
            this.didResolve((ResponseField)field);
            result = conditionalTypeReader.read(value, (ResponseReader)this);
        }
        return (T)result;
    }

    private void willResolve(ResponseField field) {
        this.readerShadow.willResolve(field, this.operationVariables);
    }

    private void didResolve(ResponseField field) {
        this.readerShadow.didResolve(field, this.operationVariables);
    }

    private void checkValue(Object value, boolean optional) {
        if (!optional && value == null) {
            throw new NullPointerException("corrupted response reader, expected non null value");
        }
    }

    private class ListItemReader
    implements ResponseReader.ListItemReader {
        private final ResponseField field;
        private final Object value;

        ListItemReader(ResponseField field, Object value) {
            this.field = field;
            this.value = value;
        }

        public String readString() {
            RealResponseReader.this.readerShadow.didResolveScalar(this.value);
            return (String)this.value;
        }

        public Integer readInt() {
            RealResponseReader.this.readerShadow.didResolveScalar(this.value);
            return ((BigDecimal)this.value).intValue();
        }

        public Long readLong() {
            RealResponseReader.this.readerShadow.didResolveScalar(this.value);
            return ((BigDecimal)this.value).longValue();
        }

        public Double readDouble() {
            RealResponseReader.this.readerShadow.didResolveScalar(this.value);
            return ((BigDecimal)this.value).doubleValue();
        }

        public Boolean readBoolean() {
            RealResponseReader.this.readerShadow.didResolveScalar(this.value);
            return (Boolean)this.value;
        }

        public <T> T readCustomType(ScalarType scalarType) {
            CustomTypeAdapter typeAdapter = (CustomTypeAdapter)RealResponseReader.this.customTypeAdapters.get(scalarType);
            if (typeAdapter == null) {
                throw new RuntimeException("Can't resolve custom type adapter for " + scalarType.typeName());
            }
            RealResponseReader.this.readerShadow.didResolveScalar(this.value);
            return typeAdapter.decode(this.value.toString());
        }

        public <T> T readObject(ResponseReader.ObjectReader<T> objectReader) {
            Object value = this.value;
            RealResponseReader.this.readerShadow.willResolveObject(this.field, Optional.fromNullable((Object)value));
            Object item = objectReader.read(new RealResponseReader<Object>(RealResponseReader.this.operationVariables, value, RealResponseReader.this.fieldValueResolver, RealResponseReader.this.customTypeAdapters, RealResponseReader.this.readerShadow));
            RealResponseReader.this.readerShadow.didResolveObject(this.field, Optional.fromNullable((Object)value));
            return (T)item;
        }
    }
}

