/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.util;

import com.apollographql.apollo.Logger;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ApolloLogger {
    private final Optional<Logger> logger;

    public ApolloLogger(@Nonnull Optional<Logger> logger) {
        this.logger = (Optional)Utils.checkNotNull(logger, (Object)"logger == null");
    }

    public void d(@Nonnull String message, Object ... args) {
        this.log(3, message, null, args);
    }

    public void d(@Nullable Throwable t, @Nonnull String message, Object ... args) {
        this.log(3, message, t, args);
    }

    public void w(@Nonnull String message, Object ... args) {
        this.log(5, message, null, args);
    }

    public void w(@Nullable Throwable t, @Nonnull String message, Object ... args) {
        this.log(5, message, t, args);
    }

    public void e(@Nonnull String message, Object ... args) {
        this.log(6, message, null, args);
    }

    public void e(@Nullable Throwable t, @Nonnull String message, Object ... args) {
        this.log(6, message, t, args);
    }

    private void log(int priority, @Nonnull String message, @Nullable Throwable t, Object ... args) {
        if (this.logger.isPresent()) {
            ((Logger)this.logger.get()).log(priority, message, (Optional<Throwable>)Optional.fromNullable((Object)t), args);
        }
    }
}

