/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.field.MapFieldValueResolver;
import com.apollographql.apollo.internal.json.ApolloJsonReader;
import com.apollographql.apollo.internal.json.BufferedSourceJsonReader;
import com.apollographql.apollo.internal.json.ResponseJsonStreamReader;
import com.apollographql.apollo.internal.reader.RealResponseReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;

final class HttpResponseBodyParser<D extends Operation.Data, W> {
    private final Operation<D, W, ?> operation;
    private final ResponseFieldMapper responseFieldMapper;
    private final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;

    HttpResponseBodyParser(Operation<D, W, ?> operation, ResponseFieldMapper responseFieldMapper, Map<ScalarType, CustomTypeAdapter> customTypeAdapters) {
        this.operation = operation;
        this.responseFieldMapper = responseFieldMapper;
        this.customTypeAdapters = customTypeAdapters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<W> parse(ResponseBody responseBody, final ResponseNormalizer<Map<String, Object>> networkResponseNormalizer) throws IOException {
        networkResponseNormalizer.willResolveRootQuery(this.operation);
        try (BufferedSourceJsonReader jsonReader = null;){
            jsonReader = new BufferedSourceJsonReader(responseBody.source());
            jsonReader.beginObject();
            ResponseJsonStreamReader responseStreamReader = ApolloJsonReader.responseJsonStreamReader(jsonReader);
            Operation.Data data = null;
            List<Error> errors = null;
            while (responseStreamReader.hasNext()) {
                String name = responseStreamReader.nextName();
                if ("data".equals(name)) {
                    data = (Operation.Data)responseStreamReader.nextObject(false, new ResponseJsonStreamReader.ObjectReader<Object>(){

                        @Override
                        public Object read(ResponseJsonStreamReader reader) throws IOException {
                            Map<String, Object> buffer = reader.buffer();
                            RealResponseReader<Map<String, Object>> realResponseReader = new RealResponseReader<Map<String, Object>>(HttpResponseBodyParser.this.operation, buffer, new MapFieldValueResolver(), HttpResponseBodyParser.this.customTypeAdapters, networkResponseNormalizer);
                            return HttpResponseBodyParser.this.responseFieldMapper.map(realResponseReader);
                        }
                    });
                    continue;
                }
                if ("errors".equals(name)) {
                    errors = this.readResponseErrors(responseStreamReader);
                    continue;
                }
                responseStreamReader.skipNext();
            }
            jsonReader.endObject();
            Response response = new Response(this.operation, this.operation.wrapData(data), errors, networkResponseNormalizer.dependentKeys());
            return response;
        }
    }

    private List<Error> readResponseErrors(ResponseJsonStreamReader reader) throws IOException {
        return reader.nextList(true, new ResponseJsonStreamReader.ListReader<Error>(){

            @Override
            public Error read(ResponseJsonStreamReader reader) throws IOException {
                return reader.nextObject(true, new ResponseJsonStreamReader.ObjectReader<Error>(){

                    @Override
                    public Error read(ResponseJsonStreamReader reader) throws IOException {
                        return HttpResponseBodyParser.this.readError(reader);
                    }
                });
            }
        });
    }

    private Error readError(ResponseJsonStreamReader reader) throws IOException {
        String message = null;
        List<Error.Location> locations = null;
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("message".equals(name)) {
                message = reader.nextString(false);
                continue;
            }
            if ("locations".equals(name)) {
                locations = reader.nextList(true, new ResponseJsonStreamReader.ListReader<Error.Location>(){

                    @Override
                    public Error.Location read(ResponseJsonStreamReader reader) throws IOException {
                        return reader.nextObject(false, new ResponseJsonStreamReader.ObjectReader<Error.Location>(){

                            @Override
                            public Error.Location read(ResponseJsonStreamReader reader) throws IOException {
                                return HttpResponseBodyParser.this.readErrorLocation(reader);
                            }
                        });
                    }
                });
                continue;
            }
            reader.skipNext();
        }
        return new Error(message, locations);
    }

    private Error.Location readErrorLocation(ResponseJsonStreamReader reader) throws IOException {
        long line = -1L;
        long column = -1L;
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("line".equals(name)) {
                line = reader.nextLong(false);
                continue;
            }
            if ("column".equals(name)) {
                column = reader.nextLong(false);
                continue;
            }
            reader.skipNext();
        }
        return new Error.Location(line, column);
    }
}

