/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.field;

import com.apollographql.apollo.api.Field;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.cache.normalized.CacheReference;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.internal.cache.normalized.ReadableCache;
import com.apollographql.apollo.internal.field.FieldValueResolver;
import java.util.ArrayList;
import java.util.List;

public final class CacheFieldValueResolver
implements FieldValueResolver<Record> {
    private final ReadableCache readableCache;
    private final Operation.Variables variables;

    public CacheFieldValueResolver(ReadableCache readableCache, Operation.Variables variables) {
        this.readableCache = readableCache;
        this.variables = variables;
    }

    @Override
    public <T> T valueFor(Record record, Field field) {
        if (field instanceof Field.ObjectField) {
            return (T)this.valueFor(record, (Field.ObjectField)field);
        }
        if (field instanceof Field.ScalarListField) {
            return this.fieldValue(record, field);
        }
        if (field instanceof Field.ObjectListField) {
            return (T)this.valueFor(record, (Field.ObjectListField)field);
        }
        return this.fieldValue(record, field);
    }

    private Record valueFor(Record record, Field.ObjectField field) {
        CacheReference cacheReference = (CacheReference)this.fieldValue(record, (Field)field);
        return cacheReference != null ? this.readableCache.read(cacheReference.key()) : null;
    }

    private List<Record> valueFor(Record record, Field.ObjectListField field) {
        List values = (List)this.fieldValue(record, (Field)field);
        ArrayList<Record> result = new ArrayList<Record>();
        for (CacheReference reference : values) {
            result.add(this.readableCache.read(reference.key()));
        }
        return result;
    }

    private <T> T fieldValue(Record record, Field field) {
        return (T)record.field(field.cacheKey(this.variables));
    }
}

