/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized.lru;

import com.apollographql.apollo.api.internal.Function;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.cache.normalized.NormalizedCache;
import com.apollographql.apollo.cache.normalized.NormalizedCacheFactory;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.cache.normalized.RecordFieldAdapter;
import com.apollographql.apollo.cache.normalized.lru.EvictionPolicy;
import com.nytimes.android.external.cache.Cache;
import com.nytimes.android.external.cache.CacheBuilder;
import com.nytimes.android.external.cache.Weigher;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LruNormalizedCache
extends NormalizedCache {
    private final Cache<String, Record> lruCache;
    private final Optional<NormalizedCache> secondaryCache;

    LruNormalizedCache(final RecordFieldAdapter recordFieldAdapter, EvictionPolicy evictionPolicy, Optional<NormalizedCacheFactory> secondaryNormalizedCache) {
        super(recordFieldAdapter);
        this.secondaryCache = secondaryNormalizedCache.transform((Function)new Function<NormalizedCacheFactory, NormalizedCache>(){

            @Nonnull
            public NormalizedCache apply(@Nonnull NormalizedCacheFactory normalizedCacheFactory) {
                return normalizedCacheFactory.createNormalizedCache(recordFieldAdapter);
            }
        });
        CacheBuilder lruCacheBuilder = CacheBuilder.newBuilder();
        if (evictionPolicy.maxSizeBytes().isPresent()) {
            lruCacheBuilder.maximumWeight(((Long)evictionPolicy.maxSizeBytes().get()).longValue()).weigher((Weigher)new Weigher<String, Record>(){

                public int weigh(String key, Record value) {
                    return key.getBytes().length + value.sizeEstimateBytes();
                }
            });
        }
        if (evictionPolicy.maxEntries().isPresent()) {
            lruCacheBuilder.maximumSize(((Long)evictionPolicy.maxEntries().get()).longValue());
        }
        if (evictionPolicy.expireAfterAccess().isPresent()) {
            lruCacheBuilder.expireAfterAccess(((Long)evictionPolicy.expireAfterAccess().get()).longValue(), (TimeUnit)((Object)evictionPolicy.expireAfterAccessTimeUnit().get()));
        }
        if (evictionPolicy.expireAfterWrite().isPresent()) {
            lruCacheBuilder.expireAfterWrite(((Long)evictionPolicy.expireAfterWrite().get()).longValue(), (TimeUnit)((Object)evictionPolicy.expireAfterWriteTimeUnit().get()));
        }
        this.lruCache = lruCacheBuilder.build();
    }

    @Nullable
    public NormalizedCache secondaryCache() {
        return (NormalizedCache)this.secondaryCache.get();
    }

    @Override
    @Nullable
    public Record loadRecord(final String key) {
        if (this.secondaryCache.isPresent()) {
            try {
                return (Record)this.lruCache.get((Object)key, (Callable)new Callable<Record>(){

                    @Override
                    public Record call() throws Exception {
                        Record record = ((NormalizedCache)LruNormalizedCache.this.secondaryCache.get()).loadRecord(key);
                        if (record == null) {
                            throw new Exception(String.format("Record{key=%s} not present in secondary cache", key));
                        }
                        return record;
                    }
                });
            }
            catch (Exception e) {
                return null;
            }
        }
        return (Record)this.lruCache.getIfPresent((Object)key);
    }

    @Override
    @Nonnull
    public Set<String> merge(Record apolloRecord) {
        Record oldRecord;
        if (this.secondaryCache.isPresent()) {
            ((NormalizedCache)this.secondaryCache.get()).merge(apolloRecord);
        }
        if ((oldRecord = (Record)this.lruCache.getIfPresent((Object)apolloRecord.key())) == null) {
            this.lruCache.put((Object)apolloRecord.key(), (Object)apolloRecord);
            return Collections.emptySet();
        }
        Set<String> changedKeys = oldRecord.mergeWith(apolloRecord);
        this.lruCache.put((Object)apolloRecord.key(), (Object)oldRecord);
        return changedKeys;
    }

    @Override
    public void clearAll() {
        this.clearPrimaryCache();
        this.clearSecondaryCache();
    }

    public void clearPrimaryCache() {
        this.lruCache.invalidateAll();
    }

    public void clearSecondaryCache() {
        if (this.secondaryCache.isPresent()) {
            ((NormalizedCache)this.secondaryCache.get()).clearAll();
        }
    }
}

