/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized;

import com.apollographql.apollo.cache.normalized.CacheReference;
import com.apollographql.apollo.internal.json.ApolloJsonReader;
import com.apollographql.apollo.internal.json.CacheJsonStreamReader;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Map;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

public final class RecordFieldAdapter {
    private final JsonAdapter<Map<String, Object>> serializationAdapter;

    private RecordFieldAdapter(Moshi moshi) {
        ParameterizedType type = Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Object.class});
        this.serializationAdapter = moshi.adapter((Type)type);
    }

    public static RecordFieldAdapter create(Moshi baseMoshi) {
        Moshi moshi = baseMoshi.newBuilder().add(CacheReference.class, (JsonAdapter)new CacheReferenceAdapter()).add(BigDecimal.class, (JsonAdapter)new BigDecimalAdapter()).build();
        return new RecordFieldAdapter(moshi);
    }

    public String toJson(Map<String, Object> fields) {
        return this.serializationAdapter.toJson(fields);
    }

    public Map<String, Object> from(BufferedSource bufferedFieldSource) throws IOException {
        CacheJsonStreamReader cacheJsonStreamReader = ApolloJsonReader.cacheJsonStreamReader(ApolloJsonReader.bufferedSourceJsonReader(bufferedFieldSource));
        return cacheJsonStreamReader.buffer();
    }

    public Map<String, Object> from(String jsonFieldSource) throws IOException {
        BufferedSource bufferSource = Okio.buffer((Source)Okio.source((InputStream)new ByteArrayInputStream(jsonFieldSource.getBytes())));
        return this.from(bufferSource);
    }

    private static class BigDecimalAdapter
    extends JsonAdapter<BigDecimal> {
        private BigDecimalAdapter() {
        }

        public BigDecimal fromJson(JsonReader reader) throws IOException {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getName() + " should only be used for serialization.");
        }

        public void toJson(JsonWriter writer, BigDecimal value) throws IOException {
            writer.value((Number)value);
        }
    }

    private static class CacheReferenceAdapter
    extends JsonAdapter<CacheReference> {
        private CacheReferenceAdapter() {
        }

        public CacheReference fromJson(JsonReader reader) throws IOException {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getName() + " should only be used for serialization.");
        }

        public void toJson(JsonWriter writer, CacheReference value) throws IOException {
            writer.value(value.serialize());
        }
    }
}

