/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.runtime.java.network.ws;

import com.apollographql.apollo.api.http.HttpHeader;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSocketConnection {
    private static final boolean DEBUG = false;
    private static final long OPEN_TIMEOUT_MS = 10000L;
    private static final int CLOSE_NORMAL = 1000;
    private static final String MESSAGE_CLOSED = "__closed";
    private WebSocket.Factory webSocketFactory;
    private String serverUrl;
    private List<HttpHeader> headers;
    private WebSocket webSocket;
    private boolean isWebSocketOpen;
    private BlockingQueue<String> messageQueue = new LinkedBlockingQueue<String>();

    public WebSocketConnection(WebSocket.Factory webSocketFactory, String serverUrl, List<HttpHeader> headers) {
        this.webSocketFactory = webSocketFactory;
        this.serverUrl = serverUrl;
        this.headers = headers;
    }

    public void open() throws Throwable {
        final CountDownLatch openLatch = new CountDownLatch(1);
        Request request = new Request.Builder().url(this.serverUrl).headers(WebSocketConnection.toOkHttpHeaders(this.headers)).build();
        final Throwable[] onFailureThrowable = new Throwable[]{null};
        this.webSocket = this.webSocketFactory.newWebSocket(request, new WebSocketListener(){

            public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
                WebSocketConnection.this.isWebSocketOpen = true;
                openLatch.countDown();
            }

            public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
                WebSocketConnection.this.messageQueue.add(text);
            }

            public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
                WebSocketConnection.this.messageQueue.add(bytes.utf8());
            }

            public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
                WebSocketConnection.this.isWebSocketOpen = false;
                WebSocketConnection.this.messageQueue.add(WebSocketConnection.MESSAGE_CLOSED);
                onFailureThrowable[0] = t;
                openLatch.countDown();
            }

            public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                WebSocketConnection.this.isWebSocketOpen = false;
                WebSocketConnection.this.messageQueue.add(WebSocketConnection.MESSAGE_CLOSED);
            }

            public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                WebSocketConnection.this.isWebSocketOpen = false;
                WebSocketConnection.this.messageQueue.add(WebSocketConnection.MESSAGE_CLOSED);
            }
        });
        try {
            openLatch.await(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (onFailureThrowable[0] != null) {
            throw onFailureThrowable[0];
        }
    }

    public boolean isOpen() {
        return this.isWebSocketOpen;
    }

    public void close() {
        this.webSocket.close(1000, null);
    }

    @Nullable
    public String receive(long timeoutMs) {
        if (!this.isWebSocketOpen) {
            return null;
        }
        try {
            String message;
            String string = message = timeoutMs == -1L ? this.messageQueue.take() : this.messageQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
            if (message.equals(MESSAGE_CLOSED)) {
                return null;
            }
            return message;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public void send(String message) {
        if (!this.webSocket.send(message)) {
            this.isWebSocketOpen = false;
        }
    }

    public void send(ByteString message) {
        if (!this.webSocket.send(message)) {
            this.isWebSocketOpen = false;
        }
    }

    private static Headers toOkHttpHeaders(List<HttpHeader> headers) {
        Headers.Builder builder = new Headers.Builder();
        for (HttpHeader header : headers) {
            builder.add(header.getName(), header.getValue());
        }
        return builder.build();
    }
}

