/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.network.websocket.internal;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.ApolloWebSocketClosedException;
import com.apollographql.apollo.exception.DefaultApolloException;
import com.apollographql.apollo.exception.SubscriptionConnectionException;
import com.apollographql.apollo.network.websocket.ClientMessage;
import com.apollographql.apollo.network.websocket.CompleteServerMessage;
import com.apollographql.apollo.network.websocket.ConnectionAckServerMessage;
import com.apollographql.apollo.network.websocket.ConnectionErrorServerMessage;
import com.apollographql.apollo.network.websocket.ConnectionKeepAliveServerMessage;
import com.apollographql.apollo.network.websocket.OperationErrorServerMessage;
import com.apollographql.apollo.network.websocket.ParseErrorServerMessage;
import com.apollographql.apollo.network.websocket.PingServerMessage;
import com.apollographql.apollo.network.websocket.PongServerMessage;
import com.apollographql.apollo.network.websocket.ResponseServerMessage;
import com.apollographql.apollo.network.websocket.ServerMessage;
import com.apollographql.apollo.network.websocket.WebSocket;
import com.apollographql.apollo.network.websocket.WebSocketEngine;
import com.apollographql.apollo.network.websocket.WebSocketListener;
import com.apollographql.apollo.network.websocket.WsProtocol;
import com.apollographql.apollo.network.websocket.internal.OperationListener;
import com.apollographql.apollo.network.websocket.internal.SocketState;
import com.apollographql.apollo.network.websocket.internal.SubscribableWebSocketKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'J\b\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u001dH\u0002J\u001e\u0010-\u001a\u00020*2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0005J\b\u00101\u001a\u00020*H\u0016J\u0010\u00102\u001a\u00020*2\u0006\u00103\u001a\u00020\u0005H\u0016J\u0010\u00102\u001a\u00020*2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020*2\u0006\u0010,\u001a\u00020\u001dH\u0016J!\u00107\u001a\u00020*2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u00108J&\u00109\u001a\u00020*\"\b\b\u0000\u0010:*\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H:0#2\u0006\u0010=\u001a\u00020 J\u001e\u0010>\u001a\u00020*\"\b\b\u0000\u0010:*\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H:0#R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0012\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020 0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/apollographql/apollo/network/websocket/internal/SubscribableWebSocket;", "Lcom/apollographql/apollo/network/websocket/WebSocketListener;", "webSocketEngine", "Lcom/apollographql/apollo/network/websocket/WebSocketEngine;", "serverUrl", "", "httpHeaders", "", "Lcom/apollographql/apollo/api/http/HttpHeader;", "wsProtocol", "Lcom/apollographql/apollo/network/websocket/WsProtocol;", "pingInterval", "Lkotlin/time/Duration;", "connectionAcknowledgeTimeout", "idleTimeout", "<init>", "(Lcom/apollographql/apollo/network/websocket/WebSocketEngine;Ljava/lang/String;Ljava/util/List;Lcom/apollographql/apollo/network/websocket/WsProtocol;Lkotlin/time/Duration;JJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "Lkotlinx/atomicfu/locks/ReentrantLock;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "idleTimeoutJob", "Lkotlinx/coroutines/Job;", "ackTimeoutJob", "state", "Lcom/apollographql/apollo/network/websocket/internal/SocketState;", "shutdownCause", "Lcom/apollographql/apollo/exception/ApolloException;", "activeListeners", "", "Lcom/apollographql/apollo/network/websocket/internal/OperationListener;", "pending", "", "Lcom/apollographql/apollo/api/ApolloRequest;", "webSocket", "Lcom/apollographql/apollo/network/websocket/WebSocket;", "isShutdown", "", "markActive", "restartIdleTimeout", "", "shutdownInternal", "cause", "shutdown", "code", "", "reason", "onOpen", "onMessage", "text", "data", "", "onError", "onClosed", "(Ljava/lang/Integer;Ljava/lang/String;)V", "startOperation", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "request", "listener", "stopOperation", "apollo-runtime_release"})
@SourceDebugExtension(value={"SMAP\nSubscribableWebSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscribableWebSocket.kt\ncom/apollographql/apollo/network/websocket/internal/SubscribableWebSocket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,306:1\n1755#2,3:307\n1863#2,2:310\n1#3:312\n*S KotlinDebug\n*F\n+ 1 SubscribableWebSocket.kt\ncom/apollographql/apollo/network/websocket/internal/SubscribableWebSocket\n*L\n70#1:307,3\n126#1:310,2\n*E\n"})
public final class SubscribableWebSocket
implements WebSocketListener {
    @NotNull
    private final WsProtocol wsProtocol;
    @Nullable
    private final Duration pingInterval;
    private final long connectionAcknowledgeTimeout;
    private final long idleTimeout;
    @NotNull
    private ReentrantLock lock;
    @NotNull
    private final CoroutineScope scope;
    @Nullable
    private Job idleTimeoutJob;
    @Nullable
    private Job ackTimeoutJob;
    @NotNull
    private SocketState state;
    @Nullable
    private ApolloException shutdownCause;
    @NotNull
    private Map<String, OperationListener> activeListeners;
    @NotNull
    private List<ApolloRequest<?>> pending;
    @NotNull
    private WebSocket webSocket;

    private SubscribableWebSocket(WebSocketEngine webSocketEngine, String serverUrl2, List<HttpHeader> httpHeaders, WsProtocol wsProtocol, Duration pingInterval, long connectionAcknowledgeTimeout, long idleTimeout) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)webSocketEngine, (String)"webSocketEngine");
            Intrinsics.checkNotNullParameter((Object)serverUrl2, (String)"serverUrl");
            Intrinsics.checkNotNullParameter(httpHeaders, (String)"httpHeaders");
            Intrinsics.checkNotNullParameter((Object)wsProtocol, (String)"wsProtocol");
            this.wsProtocol = wsProtocol;
            this.pingInterval = pingInterval;
            this.connectionAcknowledgeTimeout = connectionAcknowledgeTimeout;
            this.idleTimeout = idleTimeout;
            this.lock = new ReentrantLock();
            this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
            this.state = SocketState.AwaitOpen;
            this.activeListeners = new LinkedHashMap();
            this.pending = new ArrayList();
            Iterable $this$any$iv = httpHeaders;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    HttpHeader it = (HttpHeader)element$iv;
                    boolean bl2 = false;
                    String string = it.getName().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    if (!Intrinsics.areEqual((Object)string, (Object)"sec-websocket-protocol")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        List headers = bl ? httpHeaders : CollectionsKt.plus((Collection)httpHeaders, (Object)new HttpHeader("Sec-WebSocket-Protocol", this.wsProtocol.getName()));
        this.webSocket = webSocketEngine.newWebSocket(serverUrl2, headers, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isShutdown(boolean markActive) {
        boolean bl;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl2;
            boolean bl3 = false;
            boolean it = bl2 = this.state == SocketState.ShutDown;
            boolean bl4 = false;
            if (!it && markActive) {
                Job job = this.idleTimeoutJob;
                if (job != null) {
                    Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                }
                this.idleTimeoutJob = null;
            }
            bl = bl2;
        }
        finally {
            reentrantLock.unlock();
        }
        return bl;
    }

    private final void restartIdleTimeout() {
        Job job = this.idleTimeoutJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.idleTimeoutJob = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SubscribableWebSocket this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)SubscribableWebSocket.access$getIdleTimeout$p(this.this$0), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.this$0.shutdown((ApolloException)new ApolloNetworkException("WebSocket is idle", null, 2, null), 1001, "Idle");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void shutdownInternal(ApolloException cause) {
        List listeners = new ArrayList();
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            if (this.state == SocketState.ShutDown) {
                return;
            }
            this.state = SocketState.ShutDown;
            CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
            this.shutdownCause = cause;
            listeners.addAll(this.activeListeners.values());
            this.activeListeners.clear();
            Unit $i$a$-withLock-SubscribableWebSocket$shutdownInternal$2 = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
        Iterable $this$forEach$iv = listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationListener it = (OperationListener)element$iv;
            boolean bl = false;
            it.onTransportError(cause);
        }
    }

    public final void shutdown(@NotNull ApolloException cause, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.shutdownInternal(cause);
        this.webSocket.close(code, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOpen() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            if (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()] == 1) {
                BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ SubscribableWebSocket this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                var2_3 = SubscribableWebSocket.access$getWebSocket$p(this.this$0);
                                this.L$0 = var2_3;
                                this.label = 1;
                                v0 = SubscribableWebSocket.access$getWsProtocol$p(this.this$0).connectionInit((Continuation<? super ClientMessage>)((Continuation)this));
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl16
                            }
                            case 1: {
                                var2_3 = (WebSocket)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl16:
                                // 2 sources

                                SubscribableWebSocketKt.access$send(var2_3, (ClientMessage)v0);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                this.ackTimeoutJob = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ SubscribableWebSocket this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = DelayKt.delay-VtjQ1oo((long)SubscribableWebSocket.access$getConnectionAcknowledgeTimeout$p(this.this$0), (Continuation)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                this.this$0.shutdown((ApolloException)new ApolloNetworkException("Timeout while waiting for connection_ack", null, 2, null), 1001, "Timeout while waiting for connection_ack");
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                this.state = SocketState.AwaitAck;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ServerMessage message = this.wsProtocol.parseServerMessage(text);
        if (Intrinsics.areEqual((Object)message, (Object)ConnectionAckServerMessage.INSTANCE)) {
            Job job = this.ackTimeoutJob;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            this.ackTimeoutJob = null;
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                boolean bl = false;
                if (this.state != SocketState.AwaitAck) {
                    return;
                }
                this.state = SocketState.Connected;
                if (this.pingInterval != null) {
                    BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ SubscribableWebSocket this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object var1_1) {
                            var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
lbl6:
                                    // 3 sources

                                    while (true) {
                                        this.label = 1;
                                        v0 = DelayKt.delay-VtjQ1oo((long)SubscribableWebSocket.access$getPingInterval$p(this.this$0).unbox-impl(), (Continuation)((Continuation)this));
                                        if (v0 == var6_2) {
                                            return var6_2;
                                        }
                                        ** GOTO lbl15
                                        break;
                                    }
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl15:
                                    // 2 sources

                                    if (SubscribableWebSocket.access$getWsProtocol$p(this.this$0).ping() == null) ** GOTO lbl21
                                    var3_4 = this.this$0;
                                    it = var2_3;
                                    $i$a$-let-SubscribableWebSocket$onMessage$1$1$1 = false;
                                    SubscribableWebSocketKt.access$send(SubscribableWebSocket.access$getWebSocket$p(var3_4), it);
                                    ** GOTO lbl6
lbl21:
                                    // 1 sources

                                    ** continue;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
                Job job2 = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int label;
                    final /* synthetic */ SubscribableWebSocket this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                var2_3 = SubscribableWebSocket.access$getPending$p(this.this$0);
                                var3_4 = this.this$0;
                                $i$f$forEach = false;
                                var5_6 = $this$forEach$iv.iterator();
lbl9:
                                // 2 sources

                                while (var5_6.hasNext()) {
                                    element$iv = var5_6.next();
                                    it = (ApolloRequest)element$iv;
                                    $i$a$-forEach-SubscribableWebSocket$onMessage$1$2$1 = false;
                                    var9_10 = SubscribableWebSocket.access$getWebSocket$p(var3_4);
                                    this.L$0 = var3_4;
                                    this.L$1 = var5_6;
                                    this.L$2 = var9_10;
                                    this.label = 1;
                                    v0 = SubscribableWebSocket.access$getWsProtocol$p(var3_4).operationStart(it, (Continuation<? super ClientMessage>)this);
                                    if (v0 == var10_2) {
                                        return var10_2;
                                    }
                                    ** GOTO lbl31
                                }
                                break;
                            }
                            case 1: {
                                $i$f$forEach = false;
                                $i$a$-forEach-SubscribableWebSocket$onMessage$1$2$1 = false;
                                var9_10 = (WebSocket)this.L$2;
                                var5_6 = (Iterator<T>)this.L$1;
                                var3_4 = (SubscribableWebSocket)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl31:
                                // 2 sources

                                SubscribableWebSocketKt.access$send(var9_10, (ClientMessage)v0);
                                ** GOTO lbl9
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
            finally {
                reentrantLock.unlock();
            }
        }
        if (message instanceof ConnectionErrorServerMessage) {
            this.shutdown((ApolloException)new SubscriptionConnectionException(((ConnectionErrorServerMessage)message).getPayload()), 1001, "Connection error");
        } else if (message instanceof ResponseServerMessage) {
            OperationListener operationListener;
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                boolean $i$a$-withLock-SubscribableWebSocket$onMessage$52 = false;
                OperationListener $i$a$-withLock-SubscribableWebSocket$onMessage$52 = this.activeListeners.get(((ResponseServerMessage)message).getId());
                operationListener = $i$a$-withLock-SubscribableWebSocket$onMessage$52;
            }
            finally {
                reentrantLock.unlock();
            }
            if (operationListener != null) {
                operationListener.onResponse(((ResponseServerMessage)message).getResponse());
            }
        } else if (message instanceof CompleteServerMessage) {
            OperationListener operationListener;
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                boolean $i$a$-withLock-SubscribableWebSocket$onMessage$62 = false;
                OperationListener $i$a$-withLock-SubscribableWebSocket$onMessage$62 = this.activeListeners.get(((CompleteServerMessage)message).getId());
                operationListener = $i$a$-withLock-SubscribableWebSocket$onMessage$62;
            }
            finally {
                reentrantLock.unlock();
            }
            if (operationListener != null) {
                operationListener.onComplete();
            }
        } else if (message instanceof OperationErrorServerMessage) {
            OperationListener operationListener;
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                boolean $i$a$-withLock-SubscribableWebSocket$onMessage$72 = false;
                OperationListener $i$a$-withLock-SubscribableWebSocket$onMessage$72 = this.activeListeners.get(((OperationErrorServerMessage)message).getId());
                operationListener = $i$a$-withLock-SubscribableWebSocket$onMessage$72;
            }
            finally {
                reentrantLock.unlock();
            }
            if (operationListener != null) {
                operationListener.onError(((OperationErrorServerMessage)message).getPayload());
            }
        } else if (message instanceof ParseErrorServerMessage) {
            System.out.println((Object)("Cannot parse message: '" + ((ParseErrorServerMessage)message).getErrorMessage() + "'"));
        } else if (Intrinsics.areEqual((Object)message, (Object)PingServerMessage.INSTANCE)) {
            ClientMessage clientMessage = this.wsProtocol.pong();
            if (clientMessage != null) {
                ClientMessage it = clientMessage;
                boolean bl = false;
                SubscribableWebSocketKt.access$send(this.webSocket, it);
            }
        } else if (!Intrinsics.areEqual((Object)message, (Object)PongServerMessage.INSTANCE) && !Intrinsics.areEqual((Object)message, (Object)ConnectionKeepAliveServerMessage.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void onMessage(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.onMessage(StringsKt.decodeToString((byte[])data));
    }

    @Override
    public void onError(@NotNull ApolloException cause) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.shutdownInternal(cause);
    }

    @Override
    public void onClosed(@Nullable Integer code, @Nullable String reason) {
        Integer n = code;
        this.shutdownInternal((ApolloException)new ApolloWebSocketClosedException(n != null ? n : 1001, reason, null, 4, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <D extends Operation.Data> void startOperation(@NotNull ApolloRequest<D> request, @NotNull OperationListener listener2) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        DefaultApolloException cause = null;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            Job job = this.idleTimeoutJob;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            this.idleTimeoutJob = null;
            Unit unit = switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1, 2 -> {
                    String v1 = request.getRequestUuid().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toString(...)");
                    this.activeListeners.put(v1, listener2);
                    yield Boolean.valueOf(this.pending.add(request));
                }
                case 3 -> {
                    String v3 = request.getRequestUuid().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toString(...)");
                    this.activeListeners.put(v3, listener2);
                    yield BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, null){
                        Object L$0;
                        int label;
                        final /* synthetic */ SubscribableWebSocket this$0;
                        final /* synthetic */ ApolloRequest<D> $request;
                        {
                            this.this$0 = $receiver;
                            this.$request = $request;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object var1_1) {
                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    var2_3 = SubscribableWebSocket.access$getWebSocket$p(this.this$0);
                                    this.L$0 = var2_3;
                                    this.label = 1;
                                    v0 = SubscribableWebSocket.access$getWsProtocol$p(this.this$0).operationStart(this.$request, (Continuation<? super ClientMessage>)((Continuation)this));
                                    if (v0 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl16
                                }
                                case 1: {
                                    var2_3 = (WebSocket)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl16:
                                    // 2 sources

                                    SubscribableWebSocketKt.access$send(var2_3, (ClientMessage)v0);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
                case 4 -> {
                    cause = new DefaultApolloException("Apollo: the WebSocket is shut down", (Throwable)this.shutdownCause);
                    yield Unit.INSTANCE;
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        finally {
            reentrantLock.unlock();
        }
        if (cause != null) {
            listener2.onTransportError((ApolloException)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <D extends Operation.Data> void stopOperation(@NotNull ApolloRequest<D> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        String string = request.getRequestUuid().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String id = string;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            if (this.activeListeners.containsKey(id)) {
                this.activeListeners.remove(id);
                BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, null){
                    int label;
                    final /* synthetic */ SubscribableWebSocket this$0;
                    final /* synthetic */ ApolloRequest<D> $request;
                    {
                        this.this$0 = $receiver;
                        this.$request = $request;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                SubscribableWebSocketKt.access$send(SubscribableWebSocket.access$getWebSocket$p(this.this$0), SubscribableWebSocket.access$getWsProtocol$p(this.this$0).operationStop(this.$request));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                if (this.activeListeners.isEmpty()) {
                    this.restartIdleTimeout();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public /* synthetic */ SubscribableWebSocket(WebSocketEngine webSocketEngine, String serverUrl2, List httpHeaders, WsProtocol wsProtocol, Duration pingInterval, long connectionAcknowledgeTimeout, long idleTimeout, DefaultConstructorMarker $constructor_marker) {
        this(webSocketEngine, serverUrl2, httpHeaders, wsProtocol, pingInterval, connectionAcknowledgeTimeout, idleTimeout);
    }

    public static final /* synthetic */ long access$getIdleTimeout$p(SubscribableWebSocket $this) {
        return $this.idleTimeout;
    }

    public static final /* synthetic */ WebSocket access$getWebSocket$p(SubscribableWebSocket $this) {
        return $this.webSocket;
    }

    public static final /* synthetic */ WsProtocol access$getWsProtocol$p(SubscribableWebSocket $this) {
        return $this.wsProtocol;
    }

    public static final /* synthetic */ long access$getConnectionAcknowledgeTimeout$p(SubscribableWebSocket $this) {
        return $this.connectionAcknowledgeTimeout;
    }

    public static final /* synthetic */ Duration access$getPingInterval$p(SubscribableWebSocket $this) {
        return $this.pingInterval;
    }

    public static final /* synthetic */ List access$getPending$p(SubscribableWebSocket $this) {
        return $this.pending;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SocketState.values().length];
            try {
                nArray[SocketState.AwaitOpen.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SocketState.AwaitAck.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SocketState.Connected.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SocketState.ShutDown.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

