/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized.internal;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.internal.ResolveDelegate;
import com.apollographql.apollo.cache.normalized.CacheKey;
import com.apollographql.apollo.cache.normalized.CacheKeyResolver;
import com.apollographql.apollo.cache.normalized.CacheReference;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.cache.normalized.RecordSet;
import com.apollographql.apollo.cache.normalized.internal.CacheKeyBuilder;
import com.apollographql.apollo.cache.normalized.internal.SimpleStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 8*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u00018B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H&J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0014\u0010\u001f\u001a\u00020\u00172\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0016J\b\u0010\"\u001a\u00020\u0017H\u0016J\u001f\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00192\b\u0010%\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010&J\u0012\u0010'\u001a\u00020\u00172\b\u0010(\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010)\u001a\u00020\bH\u0002J\u0012\u0010*\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010+H\u0016J\u001d\u0010,\u001a\u00020-2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010.\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010/J\"\u00100\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010(\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u00101\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001f\u00102\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00192\b\u0010%\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010&J\u000e\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020-J\u001c\u00105\u001a\u00020\u00172\u0012\u00106\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u000307H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\n0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/apollographql/apollo/cache/normalized/internal/ResponseNormalizer;", "R", "Lcom/apollographql/apollo/api/internal/ResolveDelegate;", "()V", "currentRecordBuilder", "Lcom/apollographql/apollo/cache/normalized/Record$Builder;", "dependentKeys", "", "", "path", "", "pathStack", "Lcom/apollographql/apollo/cache/normalized/internal/SimpleStack;", "recordSet", "Lcom/apollographql/apollo/cache/normalized/RecordSet;", "recordStack", "Lcom/apollographql/apollo/cache/normalized/Record;", "valueStack", "", "cacheKeyBuilder", "Lcom/apollographql/apollo/cache/normalized/internal/CacheKeyBuilder;", "", "didResolve", "", "field", "Lcom/apollographql/apollo/api/ResponseField;", "variables", "Lcom/apollographql/apollo/api/Operation$Variables;", "didResolveElement", "atIndex", "", "didResolveList", "array", "", "didResolveNull", "didResolveObject", "objectField", "objectSource", "(Lcom/apollographql/apollo/api/ResponseField;Ljava/lang/Object;)V", "didResolveScalar", "value", "pathToString", "records", "", "resolveCacheKey", "Lcom/apollographql/apollo/cache/normalized/CacheKey;", "record", "(Lcom/apollographql/apollo/api/ResponseField;Ljava/lang/Object;)Lcom/apollographql/apollo/cache/normalized/CacheKey;", "willResolve", "willResolveElement", "willResolveObject", "willResolveRecord", "cacheKey", "willResolveRootQuery", "operation", "Lcom/apollographql/apollo/api/Operation;", "Companion", "apollo-normalized-cache"})
public abstract class ResponseNormalizer<R>
implements ResolveDelegate<R> {
    private SimpleStack<List<String>> pathStack;
    private SimpleStack<Record> recordStack;
    private SimpleStack<Object> valueStack;
    private List<String> path;
    private Record.Builder currentRecordBuilder;
    private RecordSet recordSet = new RecordSet();
    private Set<String> dependentKeys;
    @JvmField
    @NotNull
    public static final ResponseNormalizer<?> NO_OP_NORMALIZER;
    public static final Companion Companion;

    @Nullable
    public Collection<Record> records() {
        return this.recordSet.allRecords();
    }

    @NotNull
    public Set<String> dependentKeys() {
        return this.dependentKeys;
    }

    public void willResolveRootQuery(@NotNull Operation<?, ?, ?> operation) {
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        this.willResolveRecord(CacheKeyResolver.Companion.rootKeyForOperation(operation));
    }

    public void willResolve(@NotNull ResponseField field, @NotNull Operation.Variables variables, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)variables, (String)"variables");
        String key = this.cacheKeyBuilder().build(field, variables);
        List<String> list = this.path;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"path");
        }
        list.add(key);
    }

    public void didResolve(@NotNull ResponseField field, @NotNull Operation.Variables variables) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)variables, (String)"variables");
        List<String> list = this.path;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"path");
        }
        List<String> list2 = this.path;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"path");
        }
        list.remove(list2.size() - 1);
        SimpleStack<Object> simpleStack = this.valueStack;
        if (simpleStack == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueStack");
        }
        Object value = simpleStack.pop();
        String cacheKey = this.cacheKeyBuilder().build(field, variables);
        StringBuilder stringBuilder = new StringBuilder();
        Record.Builder builder = this.currentRecordBuilder;
        if (builder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentRecordBuilder");
        }
        String dependentKey = stringBuilder.append(builder.getKey()).append(".").append(cacheKey).toString();
        this.dependentKeys.add(dependentKey);
        Record.Builder builder2 = this.currentRecordBuilder;
        if (builder2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentRecordBuilder");
        }
        builder2.addField(cacheKey, value);
        SimpleStack<Record> simpleStack2 = this.recordStack;
        if (simpleStack2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recordStack");
        }
        if (simpleStack2.isEmpty()) {
            Record.Builder builder3 = this.currentRecordBuilder;
            if (builder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentRecordBuilder");
            }
            this.recordSet.merge(builder3.build());
        }
    }

    public void didResolveScalar(@Nullable Object value) {
        SimpleStack<Object> simpleStack = this.valueStack;
        if (simpleStack == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueStack");
        }
        simpleStack.push(value);
    }

    public void willResolveObject(@NotNull ResponseField objectField, @Nullable R objectSource) {
        Object object;
        block11: {
            block10: {
                Intrinsics.checkParameterIsNotNull((Object)objectField, (String)"objectField");
                SimpleStack<List<String>> simpleStack = this.pathStack;
                if (simpleStack == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"pathStack");
                }
                List<String> list = this.path;
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"path");
                }
                simpleStack.push(list);
                object = objectSource;
                if (object == null) break block10;
                R r = object;
                boolean bl = false;
                boolean bl2 = false;
                R it = r;
                boolean bl3 = false;
                object = this.resolveCacheKey(objectField, it);
                if (object != null) break block11;
            }
            object = CacheKey.NO_KEY;
        }
        Object cacheKey = object;
        String cacheKeyValue = cacheKey.key();
        if (cacheKey.equals((Object)CacheKey.NO_KEY)) {
            cacheKeyValue = this.pathToString();
        } else {
            this.path = new ArrayList();
            List<String> list = this.path;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"path");
            }
            list.add(cacheKeyValue);
        }
        SimpleStack<Record> simpleStack = this.recordStack;
        if (simpleStack == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recordStack");
        }
        Record.Builder builder = this.currentRecordBuilder;
        if (builder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentRecordBuilder");
        }
        simpleStack.push(builder.build());
        this.currentRecordBuilder = Record.Companion.builder(cacheKeyValue);
    }

    public void didResolveObject(@NotNull ResponseField objectField, @Nullable R objectSource) {
        Intrinsics.checkParameterIsNotNull((Object)objectField, (String)"objectField");
        SimpleStack<List<String>> simpleStack = this.pathStack;
        if (simpleStack == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pathStack");
        }
        this.path = simpleStack.pop();
        if (objectSource != null) {
            Record.Builder builder = this.currentRecordBuilder;
            if (builder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentRecordBuilder");
            }
            Record completedRecord = builder.build();
            SimpleStack<Object> simpleStack2 = this.valueStack;
            if (simpleStack2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueStack");
            }
            simpleStack2.push(new CacheReference(completedRecord.key()));
            this.dependentKeys.add(completedRecord.key());
            this.recordSet.merge(completedRecord);
        }
        SimpleStack<Record> simpleStack3 = this.recordStack;
        if (simpleStack3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recordStack");
        }
        this.currentRecordBuilder = simpleStack3.pop().toBuilder();
    }

    public void didResolveList(@NotNull List<?> array) {
        Intrinsics.checkParameterIsNotNull(array, (String)"array");
        ArrayList<Object> parsedArray = new ArrayList<Object>(array.size());
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            SimpleStack<Object> simpleStack = this.valueStack;
            if (simpleStack == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueStack");
            }
            parsedArray.add(0, simpleStack.pop());
        }
        SimpleStack<Object> simpleStack = this.valueStack;
        if (simpleStack == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueStack");
        }
        simpleStack.push(parsedArray);
    }

    public void willResolveElement(int atIndex) {
        List<String> list = this.path;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"path");
        }
        list.add(String.valueOf(atIndex));
    }

    public void didResolveElement(int atIndex) {
        List<String> list = this.path;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"path");
        }
        List<String> list2 = this.path;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"path");
        }
        list.remove(list2.size() - 1);
    }

    public void didResolveNull() {
        SimpleStack<Object> simpleStack = this.valueStack;
        if (simpleStack == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueStack");
        }
        simpleStack.push(null);
    }

    @NotNull
    public abstract CacheKey resolveCacheKey(@NotNull ResponseField var1, R var2);

    @NotNull
    public abstract CacheKeyBuilder cacheKeyBuilder();

    public final void willResolveRecord(@NotNull CacheKey cacheKey) {
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        this.pathStack = new SimpleStack();
        this.recordStack = new SimpleStack();
        this.valueStack = new SimpleStack();
        this.dependentKeys = new HashSet();
        this.path = new ArrayList();
        this.currentRecordBuilder = Record.Companion.builder(cacheKey.key());
        this.recordSet = new RecordSet();
    }

    private final String pathToString() {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        List<String> list = this.path;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"path");
        }
        int size = list.size();
        while (i < size) {
            List<String> list2 = this.path;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"path");
            }
            String pathPiece = list2.get(i);
            stringBuilder.append(pathPiece);
            if (i < size - 1) {
                stringBuilder.append(".");
            }
            ++i;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stringBuilder.toString()");
        return string;
    }

    public ResponseNormalizer() {
        Set set;
        ResponseNormalizer responseNormalizer = this;
        boolean bl = false;
        responseNormalizer.dependentKeys = set = (Set)new LinkedHashSet();
    }

    static {
        Companion = new Companion(null);
        NO_OP_NORMALIZER = new ResponseNormalizer<Object>(){

            public void willResolveRootQuery(@NotNull Operation<?, ?, ?> operation) {
                Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
            }

            public void willResolve(@NotNull ResponseField field, @NotNull Operation.Variables variables, @Nullable Object value) {
                Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
                Intrinsics.checkParameterIsNotNull((Object)variables, (String)"variables");
            }

            public void didResolve(@NotNull ResponseField field, @NotNull Operation.Variables variables) {
                Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
                Intrinsics.checkParameterIsNotNull((Object)variables, (String)"variables");
            }

            public void didResolveScalar(@Nullable Object value) {
            }

            public void willResolveObject(@NotNull ResponseField objectField, @Nullable Object objectSource) {
                Intrinsics.checkParameterIsNotNull((Object)objectField, (String)"objectField");
            }

            public void didResolveObject(@NotNull ResponseField objectField, @Nullable Object objectSource) {
                Intrinsics.checkParameterIsNotNull((Object)objectField, (String)"objectField");
            }

            public void didResolveList(@NotNull List<?> array) {
                Intrinsics.checkParameterIsNotNull(array, (String)"array");
            }

            public void willResolveElement(int atIndex) {
            }

            public void didResolveElement(int atIndex) {
            }

            public void didResolveNull() {
            }

            @Nullable
            public Collection<Record> records() {
                return CollectionsKt.emptyList();
            }

            @NotNull
            public Set<String> dependentKeys() {
                return SetsKt.emptySet();
            }

            @NotNull
            public CacheKey resolveCacheKey(@NotNull ResponseField field, @Nullable Object record) {
                Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
                return CacheKey.NO_KEY;
            }

            @NotNull
            public CacheKeyBuilder cacheKeyBuilder() {
                return new CacheKeyBuilder(){

                    @NotNull
                    public String build(@NotNull ResponseField field, @NotNull Operation.Variables variables) {
                        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
                        Intrinsics.checkParameterIsNotNull((Object)variables, (String)"variables");
                        return CacheKey.NO_KEY.key();
                    }
                };
            }
        };
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/apollographql/apollo/cache/normalized/internal/ResponseNormalizer$Companion;", "", "()V", "NO_OP_NORMALIZER", "Lcom/apollographql/apollo/cache/normalized/internal/ResponseNormalizer;", "apollo-normalized-cache"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

