/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized.api;

import com.apollographql.apollo.cache.normalized.api.CacheHeaders;
import com.apollographql.apollo.cache.normalized.api.CacheKey;
import com.apollographql.apollo.cache.normalized.api.NormalizedCache;
import com.apollographql.apollo.cache.normalized.api.Record;
import com.apollographql.apollo.cache.normalized.api.internal.CacheLock;
import com.apollographql.apollo.cache.normalized.api.internal.LruCache;
import com.apollographql.apollo.mpp.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import okio.internal._Utf8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001,B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\fH\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0#2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0#2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010'\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030)\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120(0(H\u0016J\r\u0010*\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b+R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006-"}, d2={"Lcom/apollographql/apollo/cache/normalized/api/MemoryCache;", "Lcom/apollographql/apollo/cache/normalized/api/NormalizedCache;", "maxSizeBytes", "", "expireAfterMillis", "", "<init>", "(IJ)V", "lock", "Lcom/apollographql/apollo/cache/normalized/api/internal/CacheLock;", "lruCache", "Lcom/apollographql/apollo/cache/normalized/api/internal/LruCache;", "", "Lcom/apollographql/apollo/cache/normalized/api/MemoryCache$CacheEntry;", "size", "getSize", "()I", "loadRecord", "Lcom/apollographql/apollo/cache/normalized/api/Record;", "key", "cacheHeaders", "Lcom/apollographql/apollo/cache/normalized/api/CacheHeaders;", "loadRecords", "", "keys", "internalLoadRecord", "clearAll", "", "remove", "", "cacheKey", "Lcom/apollographql/apollo/cache/normalized/api/CacheKey;", "cascade", "pattern", "merge", "", "record", "records", "internalMerge", "dump", "", "Lkotlin/reflect/KClass;", "clearCurrentCache", "clearCurrentCache$apollo_normalized_cache_api", "CacheEntry", "apollo-normalized-cache-api"})
@SourceDebugExtension(value={"SMAP\nMemoryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryCache.kt\ncom/apollographql/apollo/cache/normalized/api/MemoryCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,181:1\n1#2:182\n1863#3,2:183\n1368#3:185\n1454#3,5:186\n1246#3,4:193\n1279#3,2:197\n1293#3,4:199\n462#4:191\n412#4:192\n503#4,7:203\n*S KotlinDebug\n*F\n+ 1 MemoryCache.kt\ncom/apollographql/apollo/cache/normalized/api/MemoryCache\n*L\n93#1:183,2\n117#1:185\n117#1:186,5\n142#1:193,4\n51#1:197,2\n51#1:199,4\n142#1:191\n142#1:192\n52#1:203,7\n*E\n"})
public final class MemoryCache
extends NormalizedCache {
    private final int maxSizeBytes;
    private final long expireAfterMillis;
    @NotNull
    private final CacheLock lock;
    @NotNull
    private final LruCache<String, CacheEntry> lruCache;

    public MemoryCache(int maxSizeBytes, long expireAfterMillis) {
        this.maxSizeBytes = maxSizeBytes;
        this.expireAfterMillis = expireAfterMillis;
        this.lock = new CacheLock();
        this.lruCache = new LruCache(this.maxSizeBytes, MemoryCache::lruCache$lambda$0);
    }

    public /* synthetic */ MemoryCache(int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 2) != 0) {
            l = -1L;
        }
        this(n, l);
    }

    public final int getSize() {
        return this.lruCache.size();
    }

    @Override
    @Nullable
    public Record loadRecord(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        return (Record)this.lock.lock(() -> MemoryCache.loadRecord$lambda$2(this, key, cacheHeaders));
    }

    @Override
    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        return (Collection)this.lock.lock(() -> MemoryCache.loadRecords$lambda$5(keys, this, cacheHeaders));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Record internalLoadRecord(String key, CacheHeaders cacheHeaders) {
        CacheEntry cacheEntry;
        CacheEntry cacheEntry2;
        CacheEntry cacheEntry3 = this.lruCache.get(key);
        if (cacheEntry3 == null) return null;
        CacheEntry cacheEntry4 = cacheEntry2 = cacheEntry3;
        boolean bl = false;
        if (cacheEntry4.isExpired() || cacheHeaders.hasHeader("evict-after-read")) {
            this.lruCache.remove(key);
        }
        CacheEntry it = cacheEntry = cacheEntry2;
        boolean bl2 = false;
        if (it.isExpired()) return null;
        CacheEntry cacheEntry5 = cacheEntry;
        cacheEntry2 = cacheEntry5;
        if (cacheEntry2 == null) return null;
        Record record = cacheEntry2.getRecord();
        return record;
    }

    @Override
    public void clearAll() {
        block0: {
            this.lruCache.clear();
            NormalizedCache normalizedCache = this.getNextCache();
            if (normalizedCache == null) break block0;
            normalizedCache.clearAll();
        }
    }

    @Override
    public boolean remove(@NotNull CacheKey cacheKey, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        CacheEntry cacheEntry = this.lruCache.remove(cacheKey.getKey());
        if (cascade && cacheEntry != null) {
            for (CacheKey cacheReference : cacheEntry.getRecord().referencedFields()) {
                this.remove(new CacheKey(cacheReference.getKey()), true);
            }
        }
        NormalizedCache normalizedCache = this.getNextCache();
        boolean chainRemoved = normalizedCache != null ? normalizedCache.remove(cacheKey, cascade) : false;
        return cacheEntry != null || chainRemoved;
    }

    @Override
    public int remove(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Regex regex = NormalizedCache.Companion.patternToRegex(pattern);
        int total = 0;
        HashSet keys = new HashSet(this.lruCache.keys());
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!regex.matches((CharSequence)it)) continue;
            this.lruCache.remove(it);
            ++total;
        }
        NormalizedCache normalizedCache = this.getNextCache();
        int chainRemoved = normalizedCache != null ? normalizedCache.remove(pattern) : 0;
        return total + chainRemoved;
    }

    @Override
    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        Set<String> changedKeys = this.internalMerge(record, cacheHeaders);
        NormalizedCache normalizedCache = this.getNextCache();
        Set set = normalizedCache != null ? normalizedCache.merge(record, cacheHeaders) : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return SetsKt.plus(changedKeys, (Iterable)set);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        Iterable $this$flatMap$iv = records;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Record record = (Record)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.internalMerge(record, cacheHeaders);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set changedKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        NormalizedCache normalizedCache = this.getNextCache();
        Set set = normalizedCache != null ? normalizedCache.merge(records, cacheHeaders) : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return SetsKt.plus((Set)changedKeys, (Iterable)set);
    }

    private final Set<String> internalMerge(Record record, CacheHeaders cacheHeaders) {
        Set set;
        Record oldRecord = this.loadRecord(record.getKey(), cacheHeaders);
        if (oldRecord == null) {
            this.lruCache.set(record.getKey(), new CacheEntry(record, this.expireAfterMillis));
            set = record.fieldKeys();
        } else {
            Pair<Record, Set<String>> pair = oldRecord.mergeWith(record);
            Record mergedRecord = (Record)pair.component1();
            Set changedKeys = (Set)pair.component2();
            this.lruCache.set(record.getKey(), new CacheEntry(mergedRecord, this.expireAfterMillis));
            set = changedKeys;
        }
        Set changedKeys = set;
        return changedKeys;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map<String, CacheEntry> map = this.lruCache.dump();
        KClass kClass = Reflection.getOrCreateKotlinClass(this.getClass());
        boolean $i$f$mapValues = false;
        void var3_4 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            CacheEntry entry3 = (CacheEntry)entry2.getValue();
            Record record = entry3.getRecord();
            map3.put(k, record);
        }
        Map map4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)kClass, (Object)destination$iv$iv));
        NormalizedCache normalizedCache = this.getNextCache();
        Map map5 = normalizedCache != null ? normalizedCache.dump() : null;
        if (map5 == null) {
            map5 = MapsKt.emptyMap();
        }
        return MapsKt.plus((Map)map4, map5);
    }

    public final void clearCurrentCache$apollo_normalized_cache_api() {
        this.lruCache.clear();
    }

    private static final int lruCache$lambda$0(String key, CacheEntry cacheEntry) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CacheEntry cacheEntry2 = cacheEntry;
        return _Utf8Kt.commonAsUtf8ToByteArray((String)key).length + (cacheEntry2 != null ? cacheEntry2.getSizeInBytes() : 0);
    }

    private static final Record loadRecord$lambda$2(MemoryCache this$0, String $key, CacheHeaders $cacheHeaders) {
        Record record = this$0.internalLoadRecord($key, $cacheHeaders);
        Object object = record;
        if (object == null) {
            Object object2 = this$0.getNextCache();
            if (object2 != null && (object2 = object2.loadRecord($key, $cacheHeaders)) != null) {
                Object object3;
                Object nextCachedRecord = object3 = object2;
                boolean bl = false;
                this$0.lruCache.set($key, new CacheEntry((Record)nextCachedRecord, this$0.expireAfterMillis));
                object = object3;
            } else {
                object = null;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final List loadRecords$lambda$5(Collection $keys, MemoryCache this$0, CacheHeaders $cacheHeaders) {
        Map recordsByKey;
        Iterable $this$associateWith$iv = $keys;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void key;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Record record = this$0.internalLoadRecord((String)key, $cacheHeaders);
            map.put(t, record);
        }
        Map $this$filterValues$iv = recordsByKey = (Map)result$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv2 = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            Record it = (Record)entry$iv.getValue();
            boolean bl = false;
            if (!(it == null)) continue;
            result$iv2.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set missingKeys = ((Map)result$iv2).keySet();
        NormalizedCache normalizedCache = this$0.getNextCache();
        Collection collection = normalizedCache != null ? normalizedCache.loadRecords(missingKeys, $cacheHeaders) : null;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Collection nextCachedRecords = collection;
        for (Record record : nextCachedRecords) {
            this$0.lruCache.set(record.getKey(), new CacheEntry(record, this$0.expireAfterMillis));
        }
        return CollectionsKt.plus((Collection)CollectionsKt.filterNotNull((Iterable)recordsByKey.values()), (Iterable)nextCachedRecords);
    }

    public MemoryCache() {
        this(0, 0L, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/apollographql/apollo/cache/normalized/api/MemoryCache$CacheEntry;", "", "record", "Lcom/apollographql/apollo/cache/normalized/api/Record;", "expireAfterMillis", "", "<init>", "(Lcom/apollographql/apollo/cache/normalized/api/Record;J)V", "getRecord", "()Lcom/apollographql/apollo/cache/normalized/api/Record;", "getExpireAfterMillis", "()J", "cachedAtMillis", "getCachedAtMillis", "sizeInBytes", "", "getSizeInBytes", "()I", "isExpired", "", "()Z", "apollo-normalized-cache-api"})
    private static final class CacheEntry {
        @NotNull
        private final Record record;
        private final long expireAfterMillis;
        private final long cachedAtMillis;
        private final int sizeInBytes;

        public CacheEntry(@NotNull Record record, long expireAfterMillis) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            this.record = record;
            this.expireAfterMillis = expireAfterMillis;
            this.cachedAtMillis = UtilsKt.currentTimeMillis();
            this.sizeInBytes = this.record.getSizeInBytes() + 8;
        }

        @NotNull
        public final Record getRecord() {
            return this.record;
        }

        public final long getExpireAfterMillis() {
            return this.expireAfterMillis;
        }

        public final long getCachedAtMillis() {
            return this.cachedAtMillis;
        }

        public final int getSizeInBytes() {
            return this.sizeInBytes;
        }

        public final boolean isExpired() {
            return this.expireAfterMillis < 0L ? false : UtilsKt.currentTimeMillis() - this.cachedAtMillis >= this.expireAfterMillis;
        }
    }
}

