/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.http;

import com.apollographql.apollo.api.cache.http.HttpCacheRecord;
import com.apollographql.apollo.api.cache.http.HttpCacheRecordEditor;
import com.apollographql.apollo.api.cache.http.HttpCacheStore;
import com.apollographql.apollo.cache.http.internal.DiskLruCache;
import com.apollographql.apollo.cache.http.internal.FileSystem;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

public final class DiskLruHttpCacheStore
implements HttpCacheStore {
    private static final int VERSION = 99991;
    private static final int ENTRY_HEADERS = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    private final FileSystem fileSystem;
    private final File directory;
    private final long maxSize;
    private DiskLruCache cache;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();

    public DiskLruHttpCacheStore(@NotNull File directory, long maxSize) {
        this(FileSystem.SYSTEM, directory, maxSize);
    }

    public DiskLruHttpCacheStore(@NotNull FileSystem fileSystem, @NotNull File directory, long maxSize) {
        this.fileSystem = fileSystem;
        this.directory = directory;
        this.maxSize = maxSize;
        this.cache = this.createDiskLruCache();
    }

    public HttpCacheRecord cacheRecord(@NotNull String cacheKey) throws IOException {
        DiskLruCache.Snapshot snapshot;
        this.cacheLock.readLock().lock();
        try {
            snapshot = this.cache.get(cacheKey);
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        if (snapshot == null) {
            return null;
        }
        HttpCacheRecord responseCacheRecord = new HttpCacheRecord(){

            @NotNull
            public Source headerSource() {
                return snapshot.getSource(0);
            }

            @NotNull
            public Source bodySource() {
                return snapshot.getSource(1);
            }

            public void close() {
                snapshot.close();
            }
        };
        return responseCacheRecord;
    }

    public HttpCacheRecordEditor cacheRecordEditor(@NotNull String cacheKey) throws IOException {
        DiskLruCache.Editor editor;
        this.cacheLock.readLock().lock();
        try {
            editor = this.cache.edit(cacheKey);
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        if (editor == null) {
            return null;
        }
        return new HttpCacheRecordEditor(){

            @NotNull
            public Sink headerSink() {
                return editor.newSink(0);
            }

            @NotNull
            public Sink bodySink() {
                return editor.newSink(1);
            }

            public void abort() throws IOException {
                editor.abort();
            }

            public void commit() throws IOException {
                editor.commit();
            }
        };
    }

    public void delete() throws IOException {
        this.cacheLock.writeLock().lock();
        try {
            this.cache.delete();
            this.cache = this.createDiskLruCache();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    public void remove(@NotNull String cacheKey) throws IOException {
        this.cacheLock.readLock().lock();
        try {
            this.cache.remove(cacheKey);
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    private DiskLruCache createDiskLruCache() {
        return DiskLruCache.create(this.fileSystem, this.directory, 99991, 2, this.maxSize);
    }
}

