/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.http;

import com.apollographql.apollo.Logger;
import com.apollographql.apollo.api.cache.http.HttpCache;
import com.apollographql.apollo.api.cache.http.HttpCacheRecord;
import com.apollographql.apollo.api.cache.http.HttpCacheRecordEditor;
import com.apollographql.apollo.api.cache.http.HttpCacheStore;
import com.apollographql.apollo.api.internal.ApolloLogger;
import com.apollographql.apollo.cache.http.CacheResponseBody;
import com.apollographql.apollo.cache.http.HttpCacheInterceptor;
import com.apollographql.apollo.cache.http.ResponseBodyProxy;
import com.apollographql.apollo.cache.http.ResponseHeaderRecord;
import com.apollographql.apollo.cache.http.Utils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.ForwardingSource;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApolloHttpCache
implements HttpCache {
    private final HttpCacheStore cacheStore;
    private final ApolloLogger logger;

    public ApolloHttpCache(@NotNull HttpCacheStore cacheStore) {
        this(cacheStore, null);
    }

    public ApolloHttpCache(@NotNull HttpCacheStore cacheStore, @Nullable Logger logger) {
        this.cacheStore = (HttpCacheStore)com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)cacheStore, (Object)"cacheStore == null");
        this.logger = new ApolloLogger(logger);
    }

    public void clear() {
        try {
            this.cacheStore.delete();
        }
        catch (IOException e) {
            this.logger.e((Throwable)e, "Failed to clear http cache", new Object[0]);
        }
    }

    public void remove(@NotNull String cacheKey) throws IOException {
        this.cacheStore.remove(cacheKey);
    }

    public void removeQuietly(@NotNull String cacheKey) {
        try {
            this.remove(cacheKey);
        }
        catch (Exception ignore) {
            this.logger.w((Throwable)ignore, "Failed to remove cached record for key: %s", new Object[]{cacheKey});
        }
    }

    public Response read(@NotNull String cacheKey) {
        return this.read(cacheKey, false);
    }

    public Response read(final @NotNull String cacheKey, final boolean expireAfterRead) {
        HttpCacheRecord responseCacheRecord = null;
        try {
            responseCacheRecord = this.cacheStore.cacheRecord(cacheKey);
            if (responseCacheRecord == null) {
                return null;
            }
            final HttpCacheRecord cacheRecord = responseCacheRecord;
            ForwardingSource cacheResponseSource = new ForwardingSource(responseCacheRecord.bodySource()){

                public void close() throws IOException {
                    super.close();
                    ApolloHttpCache.this.closeQuietly(cacheRecord);
                    if (expireAfterRead) {
                        ApolloHttpCache.this.removeQuietly(cacheKey);
                    }
                }
            };
            Response response = new ResponseHeaderRecord(responseCacheRecord.headerSource()).response();
            String contentType = response.header("Content-Type");
            String contentLength = response.header("Content-Length");
            return response.newBuilder().addHeader("X-APOLLO-FROM-CACHE", "true").body((ResponseBody)new CacheResponseBody((Source)cacheResponseSource, contentType, contentLength)).build();
        }
        catch (Exception e) {
            this.closeQuietly(responseCacheRecord);
            this.logger.e((Throwable)e, "Failed to read http cache entry for key: %s", new Object[]{cacheKey});
            return null;
        }
    }

    public Interceptor interceptor() {
        return new HttpCacheInterceptor(this, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response cacheProxy(@NotNull Response response, @NotNull String cacheKey) {
        block6: {
            if (Utils.skipStoreResponse(response.request())) {
                return response;
            }
            HttpCacheRecordEditor cacheRecordEditor = null;
            try {
                cacheRecordEditor = this.cacheStore.cacheRecordEditor(cacheKey);
                if (cacheRecordEditor == null) break block6;
                Sink headerSink = cacheRecordEditor.headerSink();
                try {
                    new ResponseHeaderRecord(response).writeTo(headerSink);
                }
                finally {
                    this.closeQuietly(headerSink);
                }
                return response.newBuilder().body((ResponseBody)new ResponseBodyProxy(cacheRecordEditor, response, this.logger)).build();
            }
            catch (Exception e) {
                this.abortQuietly(cacheRecordEditor);
                this.logger.e((Throwable)e, "Failed to proxy http response for key: %s", new Object[]{cacheKey});
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(@NotNull Response response, @NotNull String cacheKey) {
        block8: {
            HttpCacheRecordEditor cacheRecordEditor = null;
            try {
                cacheRecordEditor = this.cacheStore.cacheRecordEditor(cacheKey);
                if (cacheRecordEditor == null) break block8;
                Sink headerSink = cacheRecordEditor.headerSink();
                try {
                    new ResponseHeaderRecord(response).writeTo(headerSink);
                }
                finally {
                    this.closeQuietly(headerSink);
                }
                Sink bodySink = cacheRecordEditor.bodySink();
                try {
                    Utils.copyResponseBody(response, bodySink);
                }
                finally {
                    this.closeQuietly(bodySink);
                }
                cacheRecordEditor.commit();
            }
            catch (Exception e) {
                this.abortQuietly(cacheRecordEditor);
                this.logger.e((Throwable)e, "Failed to cache http response for key: %s", new Object[]{cacheKey});
            }
        }
    }

    void closeQuietly(HttpCacheRecord cacheRecord) {
        try {
            if (cacheRecord != null) {
                cacheRecord.close();
            }
        }
        catch (Exception ignore) {
            this.logger.w((Throwable)ignore, "Failed to close cache record", new Object[0]);
        }
    }

    private void abortQuietly(HttpCacheRecordEditor cacheRecordEditor) {
        try {
            if (cacheRecordEditor != null) {
                cacheRecordEditor.abort();
            }
        }
        catch (Exception ignore) {
            this.logger.w((Throwable)ignore, "Failed to abort cache record edit", new Object[0]);
        }
    }

    private void closeQuietly(Sink sink) {
        try {
            sink.close();
        }
        catch (Exception ignore) {
            this.logger.w((Throwable)ignore, "Failed to close sink", new Object[0]);
        }
    }
}

