/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.http;

import com.apollographql.apollo.api.cache.http.HttpCacheRecord;
import com.apollographql.apollo.api.cache.http.HttpCacheRecordEditor;
import com.apollographql.apollo.api.cache.http.HttpCacheStore;
import java.io.File;
import java.io.IOException;
import okhttp3.internal.cache.DiskLruCache;
import okhttp3.internal.io.FileSystem;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

public final class DiskLruHttpCacheStore
implements HttpCacheStore {
    private static final int VERSION = 99991;
    private static final int ENTRY_HEADERS = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    private final DiskLruCache cache;

    public DiskLruHttpCacheStore(@NotNull File directory, long maxSize) {
        this.cache = DiskLruCache.create((FileSystem)FileSystem.SYSTEM, (File)directory, (int)99991, (int)2, (long)maxSize);
    }

    public DiskLruHttpCacheStore(@NotNull FileSystem fileSystem, @NotNull File directory, long maxSize) {
        this.cache = DiskLruCache.create((FileSystem)fileSystem, (File)directory, (int)99991, (int)2, (long)maxSize);
    }

    public HttpCacheRecord cacheRecord(@NotNull String cacheKey) throws IOException {
        final DiskLruCache.Snapshot snapshot = this.cache.get(cacheKey);
        if (snapshot == null) {
            return null;
        }
        HttpCacheRecord responseCacheRecord = new HttpCacheRecord(){

            @NotNull
            public Source headerSource() {
                return snapshot.getSource(0);
            }

            @NotNull
            public Source bodySource() {
                return snapshot.getSource(1);
            }

            public void close() {
                snapshot.close();
            }
        };
        return responseCacheRecord;
    }

    public HttpCacheRecordEditor cacheRecordEditor(@NotNull String cacheKey) throws IOException {
        final DiskLruCache.Editor editor = this.cache.edit(cacheKey);
        if (editor == null) {
            return null;
        }
        return new HttpCacheRecordEditor(){

            @NotNull
            public Sink headerSink() {
                return editor.newSink(0);
            }

            @NotNull
            public Sink bodySink() {
                return editor.newSink(1);
            }

            public void abort() throws IOException {
                editor.abort();
            }

            public void commit() throws IOException {
                editor.commit();
            }
        };
    }

    public void delete() throws IOException {
        this.cache.delete();
    }

    public void remove(@NotNull String cacheKey) throws IOException {
        this.cache.remove(cacheKey);
    }
}

