/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okio;

import com.apollographql.apollo.relocated.okio.Segment;
import java.util.concurrent.atomic.AtomicReference;

public abstract class SegmentPool {
    public static final Segment LOCK;
    public static final int HASH_BUCKET_COUNT;
    public static final AtomicReference[] hashBuckets;

    public static final Segment take() {
        Segment segment;
        AtomicReference atomicReference = hashBuckets[(int)(Thread.currentThread().getId() & (long)HASH_BUCKET_COUNT - 1L)];
        Segment segment2 = atomicReference.getAndSet(segment = LOCK);
        if (segment2 == segment) {
            return new Segment();
        }
        if (segment2 == null) {
            atomicReference.set(null);
            return new Segment();
        }
        atomicReference.set(segment2.next);
        segment2.next = null;
        segment2.limit = 0;
        return segment2;
    }

    public static final void recycle(Segment segment) {
        Segment segment2 = segment;
        segment2.getClass();
        if (segment2.next == null && segment.prev == null) {
            Segment segment3;
            AtomicReference atomicReference;
            Segment segment4;
            if (segment.shared || (segment4 = (atomicReference = hashBuckets[(int)(Thread.currentThread().getId() & (long)HASH_BUCKET_COUNT - 1L)]).getAndSet(segment3 = LOCK)) == segment3) {
                return;
            }
            int n = segment4 != null ? segment4.limit : 0;
            if (n >= 65536) {
                atomicReference.set(segment4);
                return;
            }
            Segment segment5 = segment;
            segment5.next = segment4;
            segment5.pos = 0;
            segment.limit = n + 8192;
            atomicReference.set(segment);
            return;
        }
        throw new IllegalArgumentException("Failed requirement.");
    }

    static {
        int n;
        LOCK = new Segment(new byte[0], 0, 0, false, false);
        HASH_BUCKET_COUNT = n = Integer.highestOneBit(Runtime.getRuntime().availableProcessors() * 2 - 1);
        AtomicReference[] atomicReferenceArray = new AtomicReference[n];
        for (int i = 0; i < n; ++i) {
            AtomicReference atomicReference;
            AtomicReference atomicReference2 = atomicReference;
            atomicReference = new AtomicReference();
            atomicReferenceArray[i] = atomicReference2;
        }
        hashBuckets = atomicReferenceArray;
    }
}

