/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.platform;

import com.apollographql.apollo.relocated.okhttp3.OkHttpClient;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Android10Platform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.AndroidPlatform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.BouncyCastlePlatform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.ConscryptPlatform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Jdk8WithJettyBootPlatform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Jdk9Platform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.OpenJSSEPlatform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.android.AndroidLog;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.BasicCertificateChainCleaner;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.BasicTrustRootIndex;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.CertificateChainCleaner;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.TrustRootIndex;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class Platform {
    public static volatile Platform platform;
    public static final Logger logger;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Object object;
        block34: {
            block37: {
                block36: {
                    block35: {
                        block33: {
                            if (!"Dalvik".equals(System.getProperty("java.vm.name"))) break block33;
                            for (Map.Entry entry : AndroidLog.knownLoggers.entrySet()) {
                                AndroidLog.enableLogging((String)entry.getKey(), (String)entry.getValue());
                            }
                            if (Android10Platform.isSupported) {
                                Android10Platform android10Platform;
                                object = android10Platform;
                                android10Platform = new Android10Platform();
                            } else {
                                object = null;
                            }
                            if (object == null) {
                                if (AndroidPlatform.isSupported) {
                                    AndroidPlatform androidPlatform;
                                    object = androidPlatform;
                                    androidPlatform = new AndroidPlatform();
                                } else {
                                    object = null;
                                }
                                object.getClass();
                            }
                            break block34;
                        }
                        if (!"Conscrypt".equals(Security.getProviders()[0].getName())) break block35;
                        if (ConscryptPlatform.isSupported) {
                            ConscryptPlatform conscryptPlatform;
                            object = conscryptPlatform;
                            conscryptPlatform = new ConscryptPlatform();
                        } else {
                            object = null;
                        }
                        if (object != null) break block34;
                    }
                    if (!"BC".equals(Security.getProviders()[0].getName())) break block36;
                    if (BouncyCastlePlatform.isSupported) {
                        BouncyCastlePlatform bouncyCastlePlatform;
                        object = bouncyCastlePlatform;
                        bouncyCastlePlatform = new BouncyCastlePlatform();
                    } else {
                        object = null;
                    }
                    if (object != null) break block34;
                }
                if (!"OpenJSSE".equals(Security.getProviders()[0].getName())) break block37;
                if (OpenJSSEPlatform.isSupported) {
                    OpenJSSEPlatform openJSSEPlatform;
                    object = openJSSEPlatform;
                    openJSSEPlatform = new OpenJSSEPlatform();
                } else {
                    object = null;
                }
                if (object != null) break block34;
            }
            if (Jdk9Platform.isAvailable) {
                Jdk9Platform jdk9Platform;
                object = jdk9Platform;
                jdk9Platform = new Jdk9Platform();
            } else {
                object = null;
            }
            if (object == null) {
                block32: {
                    block31: {
                        Jdk8WithJettyBootPlatform jdk8WithJettyBootPlatform;
                        block30: {
                            String string;
                            String string2 = System.getProperty("java.specification.version", "unknown");
                            try {
                                string = string2;
                                string2.getClass();
                            }
                            catch (NumberFormatException numberFormatException) {}
                            if (Integer.parseInt(string) < 9) break block30;
                            break block31;
                        }
                        object = null;
                        Class<?> clazz = Class.forName("org.eclipse.jetty.alpn.ALPN", true, (ClassLoader)object);
                        object = Class.forName("org.eclipse.jetty.alpn.ALPN$Provider", true, null);
                        Class<?> clazz2 = Class.forName("org.eclipse.jetty.alpn.ALPN$ClientProvider", true, null);
                        Class<?> clazz3 = Class.forName("org.eclipse.jetty.alpn.ALPN$ServerProvider", true, null);
                        object = clazz.getMethod("put", new Class[]{SSLSocket.class, object});
                        Method method = clazz.getMethod("get", SSLSocket.class);
                        Method method2 = clazz.getMethod("remove", SSLSocket.class);
                        Jdk8WithJettyBootPlatform jdk8WithJettyBootPlatform2 = jdk8WithJettyBootPlatform;
                        GenericDeclaration genericDeclaration = object;
                        Method method3 = method;
                        Class<?> clazz4 = clazz3;
                        Class<?> clazz5 = clazz2;
                        Method method4 = method2;
                        Method method5 = method;
                        object.getClass();
                        method5.getClass();
                        method4.getClass();
                        clazz5.getClass();
                        clazz4.getClass();
                        try {
                            jdk8WithJettyBootPlatform = new Jdk8WithJettyBootPlatform((Method)genericDeclaration, method3, method2, clazz2, clazz3);
                            object = jdk8WithJettyBootPlatform2;
                            break block32;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                    object = null;
                }
                if (object == null) {
                    Platform platform;
                    object = platform;
                    platform = new Platform();
                }
            }
        }
        platform = object;
        logger = Logger.getLogger(OkHttpClient.class.getName());
    }

    public static void log(String string, int n, Throwable throwable) {
        Level level = n == 5 ? Level.WARNING : Level.INFO;
        logger.log(level, string, throwable);
    }

    public SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.getClass();
        return sSLContext;
    }

    public X509TrustManager platformTrustManager() {
        Object object;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        Object object2 = trustManagerFactory.getTrustManagers();
        object2.getClass();
        if (((TrustManager[])object2).length == 1 && (object = object2[0]) instanceof X509TrustManager) {
            Object object3 = object;
            object3.getClass();
            return (X509TrustManager)object3;
        }
        object2 = Arrays.toString((Object[])object2);
        object2.getClass();
        object2 = "Unexpected default trust managers: ".concat((String)object2);
        throw new IllegalStateException(object2.toString());
    }

    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List list) {
        list.getClass();
    }

    public void afterHandshake(SSLSocket sSLSocket) {
    }

    public String getSelectedProtocol(SSLSocket sSLSocket) {
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n) {
        inetSocketAddress.getClass();
        socket.connect(inetSocketAddress, n);
    }

    public boolean isCleartextTrafficPermitted(String string) {
        string.getClass();
        return true;
    }

    public Object getStackTraceForCloseable() {
        String string = "response.body().close()";
        if (logger.isLoggable(Level.FINE)) {
            return new Throwable(string);
        }
        return null;
    }

    public void logCloseableLeak(String string, Object object) {
        if (object == null) {
            string = string.concat(" To see where this was allocated, set the OkHttpClient logger level to FINE: Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);");
        }
        Platform.log(string, 5, (Throwable)object);
    }

    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex(x509TrustManager));
    }

    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        X509Certificate[] x509CertificateArray = x509TrustManager.getAcceptedIssuers();
        x509CertificateArray.getClass();
        return new BasicTrustRootIndex(Arrays.copyOf(x509CertificateArray, x509CertificateArray.length));
    }

    public SSLSocketFactory newSslSocketFactory(X509TrustManager x509TrustManager) {
        SSLContext sSLContext;
        try {
            sSLContext = platform.newSSLContext();
            Platform platform = null;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AssertionError("No System TLS: " + generalSecurityException, generalSecurityException);
        }
        TrustManager[] trustManagerArray = new TrustManager[1];
        TrustManager[] trustManagerArray2 = trustManagerArray;
        trustManagerArray[0] = x509TrustManager;
        sSLContext.init((KeyManager[])platform, trustManagerArray2, null);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        SSLSocketFactory sSLSocketFactory2 = sSLSocketFactory;
        sSLSocketFactory.getClass();
        return sSLSocketFactory2;
    }

    public final String toString() {
        return this.getClass().getSimpleName();
    }
}

